# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.commercial_code_entity_1 import CommercialCodeEntity1
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.line_item_entity import LineItemEntity
from fdxapi.models.payment_details_entity import PaymentDetailsEntity
from fdxapi.models.transaction_reward_entity_2 import TransactionRewardEntity2


class Transaction(object):

    """Implementation of the 'Transaction' model.

    Base entity for financial transactions

    Attributes:
        account_category (str): The model property of type str.
        account_id (str): Corresponds to AccountId in Account
        transaction_id (str): Long term persistent identity of the transaction
            (unique to account)
        reference_transaction_id (str): For reverse postings, the identity of
            the transaction being reversed. For the correction transaction,
            the identity of the reversing post. For credit card posting
            transactions, the identity of the authorization transaction
        posted_timestamp (datetime): The date and time that the transaction
            was posted to the account. If not provided then
            TransactionTimestamp can be used as PostedTimeStamp
        transaction_timestamp (datetime): The date and time that the
            transaction was added to the server backend systems
        description (str): The description of the transaction, such as
            information about a merchant's name or place of business in a
            manner that is user friendly and accessible to the customer
        memo (str): Secondary transaction description
        debit_credit_memo (DebitCreditMemo2): DEBIT, CREDIT, MEMO
        category (str): Transaction category, preferably MCC or SIC.
        sub_category (str): Transaction category detail specifying the
            standard of the transaction category. For example, "MCC"
        reference (str): A tracking reference identifier
        status (TransactionStatus2): PENDING, MEMO, POSTED, AUTHORIZATION
        amount (float): The amount of money in the account currency
        foreign_amount (float): The amount of money in the foreign currency
        foreign_currency (Iso4217CurrencyCode2): The ISO 4217 code of the
            foreign currency
        image_ids (List[str]): Array of Image Identifiers (unique to this
            transaction) used to retrieve Images of check or transaction
            receipt
        line_item (List[LineItemEntity]): Breakdown of the transaction details
        reward (TransactionRewardEntity2): Rewards earned with this transaction
        fi_attributes (List[FiAttributeEntity]): Array of FI-specific
            attributes
        links (List[HateoasLink]): Links (unique to this transaction) used to
            retrieve images of checks or transaction receipts
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'account_category',
        'account_id',
        'transaction_id',
        'reference_transaction_id',
        'posted_timestamp',
        'transaction_timestamp',
        'description',
        'memo',
        'debit_credit_memo',
        'category',
        'sub_category',
        'reference',
        'status',
        'amount',
        'foreign_amount',
        'foreign_currency',
        'image_ids',
        'line_item',
        'reward',
        'fi_attributes',
        'links',
    ]

    def __init__(self,
                 account_category='Transaction',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Transaction class"""

        # Initialize members of the class
        self.account_category = account_category 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if transaction_id is not APIHelper.SKIP:
            self.transaction_id = transaction_id 
        if reference_transaction_id is not APIHelper.SKIP:
            self.reference_transaction_id = reference_transaction_id 
        if posted_timestamp is not APIHelper.SKIP:
            self.posted_timestamp = APIHelper.apply_datetime_converter(posted_timestamp, APIHelper.RFC3339DateTime) if posted_timestamp else None 
        if transaction_timestamp is not APIHelper.SKIP:
            self.transaction_timestamp = APIHelper.apply_datetime_converter(transaction_timestamp, APIHelper.RFC3339DateTime) if transaction_timestamp else None 
        if description is not APIHelper.SKIP:
            self.description = description 
        if memo is not APIHelper.SKIP:
            self.memo = memo 
        if debit_credit_memo is not APIHelper.SKIP:
            self.debit_credit_memo = debit_credit_memo 
        if category is not APIHelper.SKIP:
            self.category = category 
        if sub_category is not APIHelper.SKIP:
            self.sub_category = sub_category 
        if reference is not APIHelper.SKIP:
            self.reference = reference 
        if status is not APIHelper.SKIP:
            self.status = status 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if foreign_amount is not APIHelper.SKIP:
            self.foreign_amount = foreign_amount 
        if foreign_currency is not APIHelper.SKIP:
            self.foreign_currency = foreign_currency 
        if image_ids is not APIHelper.SKIP:
            self.image_ids = image_ids 
        if line_item is not APIHelper.SKIP:
            self.line_item = line_item 
        if reward is not APIHelper.SKIP:
            self.reward = reward 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        discriminators = {
            'Commercial Transaction entity': CommercialTransactionEntity.from_dictionary,
            'Deposit Transaction entity': DepositTransactionEntity.from_dictionary,
            'Digital Wallet Transaction entity': DigitalWalletTransactionEntity.from_dictionary,
            'Insurance Transaction entity': InsuranceTransactionEntity.from_dictionary,
            'Investment Transaction entity': InvestmentTransactionEntity.from_dictionary,
            'Line of Credit Transaction entity': LineOfCreditTransactionEntity.from_dictionary,
            'Loan Transaction entity': LoanTransactionEntity.from_dictionary
        }
        unboxer = discriminators.get(dictionary.get('accountCategory'))

        # Delegate unboxing to another function if a discriminator
        # value for a child class is present.
        if unboxer:
            return unboxer(dictionary)

        # Extract variables from the dictionary
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Transaction'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_category={(self.account_category if hasattr(self, "account_category") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'transaction_id={(self.transaction_id if hasattr(self, "transaction_id") else None)!r}, '
                f'reference_transaction_id={(self.reference_transaction_id if hasattr(self, "reference_transaction_id") else None)!r}, '
                f'posted_timestamp={(self.posted_timestamp if hasattr(self, "posted_timestamp") else None)!r}, '
                f'transaction_timestamp={(self.transaction_timestamp if hasattr(self, "transaction_timestamp") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!r}, '
                f'debit_credit_memo={(self.debit_credit_memo if hasattr(self, "debit_credit_memo") else None)!r}, '
                f'category={(self.category if hasattr(self, "category") else None)!r}, '
                f'sub_category={(self.sub_category if hasattr(self, "sub_category") else None)!r}, '
                f'reference={(self.reference if hasattr(self, "reference") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'foreign_amount={(self.foreign_amount if hasattr(self, "foreign_amount") else None)!r}, '
                f'foreign_currency={(self.foreign_currency if hasattr(self, "foreign_currency") else None)!r}, '
                f'image_ids={(self.image_ids if hasattr(self, "image_ids") else None)!r}, '
                f'line_item={(self.line_item if hasattr(self, "line_item") else None)!r}, '
                f'reward={(self.reward if hasattr(self, "reward") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_category={(self.account_category if hasattr(self, "account_category") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'transaction_id={(self.transaction_id if hasattr(self, "transaction_id") else None)!s}, '
                f'reference_transaction_id={(self.reference_transaction_id if hasattr(self, "reference_transaction_id") else None)!s}, '
                f'posted_timestamp={(self.posted_timestamp if hasattr(self, "posted_timestamp") else None)!s}, '
                f'transaction_timestamp={(self.transaction_timestamp if hasattr(self, "transaction_timestamp") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!s}, '
                f'debit_credit_memo={(self.debit_credit_memo if hasattr(self, "debit_credit_memo") else None)!s}, '
                f'category={(self.category if hasattr(self, "category") else None)!s}, '
                f'sub_category={(self.sub_category if hasattr(self, "sub_category") else None)!s}, '
                f'reference={(self.reference if hasattr(self, "reference") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'foreign_amount={(self.foreign_amount if hasattr(self, "foreign_amount") else None)!s}, '
                f'foreign_currency={(self.foreign_currency if hasattr(self, "foreign_currency") else None)!s}, '
                f'image_ids={(self.image_ids if hasattr(self, "image_ids") else None)!s}, '
                f'line_item={(self.line_item if hasattr(self, "line_item") else None)!s}, '
                f'reward={(self.reward if hasattr(self, "reward") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')

class CommercialTransactionEntity(Transaction):

    """Implementation of the 'Commercial Transaction entity' model.

    A transaction on a commercial account type
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        immediate_available_balance (float): Immediate available balance
        next_day_available_balance (float): Next day available balance
        two_days_plus_available_balance (float): Two days plus available
            balance
        reference_bank_id (str): Reference bank id
        reference_branch_id (str): Reference branch id
        reference_customer_id (str): Reference customer id
        commercial_code (CommercialCodeEntity1): The code for a specific
            treasury management defined field
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "immediate_available_balance": 'immediateAvailableBalance',
        "next_day_available_balance": 'nextDayAvailableBalance',
        "two_days_plus_available_balance": 'twoDaysPlusAvailableBalance',
        "reference_bank_id": 'referenceBankId',
        "reference_branch_id": 'referenceBranchId',
        "reference_customer_id": 'referenceCustomerId',
        "commercial_code": 'commercialCode',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'immediate_available_balance',
        'next_day_available_balance',
        'two_days_plus_available_balance',
        'reference_bank_id',
        'reference_branch_id',
        'reference_customer_id',
        'commercial_code',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 immediate_available_balance=APIHelper.SKIP,
                 next_day_available_balance=APIHelper.SKIP,
                 two_days_plus_available_balance=APIHelper.SKIP,
                 reference_bank_id=APIHelper.SKIP,
                 reference_branch_id=APIHelper.SKIP,
                 reference_customer_id=APIHelper.SKIP,
                 commercial_code=APIHelper.SKIP,
                 account_category='Commercial Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CommercialTransactionEntity class"""

        # Initialize members of the class
        if immediate_available_balance is not APIHelper.SKIP:
            self.immediate_available_balance = immediate_available_balance 
        if next_day_available_balance is not APIHelper.SKIP:
            self.next_day_available_balance = next_day_available_balance 
        if two_days_plus_available_balance is not APIHelper.SKIP:
            self.two_days_plus_available_balance = two_days_plus_available_balance 
        if reference_bank_id is not APIHelper.SKIP:
            self.reference_bank_id = reference_bank_id 
        if reference_branch_id is not APIHelper.SKIP:
            self.reference_branch_id = reference_branch_id 
        if reference_customer_id is not APIHelper.SKIP:
            self.reference_customer_id = reference_customer_id 
        if commercial_code is not APIHelper.SKIP:
            self.commercial_code = commercial_code 

        # Call the constructor for the base class
        super(CommercialTransactionEntity, self).__init__(account_category,
                                                          account_id,
                                                          transaction_id,
                                                          reference_transaction_id,
                                                          posted_timestamp,
                                                          transaction_timestamp,
                                                          description,
                                                          memo,
                                                          debit_credit_memo,
                                                          category,
                                                          sub_category,
                                                          reference,
                                                          status,
                                                          amount,
                                                          foreign_amount,
                                                          foreign_currency,
                                                          image_ids,
                                                          line_item,
                                                          reward,
                                                          fi_attributes,
                                                          links,
                                                          additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        immediate_available_balance = dictionary.get("immediateAvailableBalance") if dictionary.get("immediateAvailableBalance") else APIHelper.SKIP
        next_day_available_balance = dictionary.get("nextDayAvailableBalance") if dictionary.get("nextDayAvailableBalance") else APIHelper.SKIP
        two_days_plus_available_balance = dictionary.get("twoDaysPlusAvailableBalance") if dictionary.get("twoDaysPlusAvailableBalance") else APIHelper.SKIP
        reference_bank_id = dictionary.get("referenceBankId") if dictionary.get("referenceBankId") else APIHelper.SKIP
        reference_branch_id = dictionary.get("referenceBranchId") if dictionary.get("referenceBranchId") else APIHelper.SKIP
        reference_customer_id = dictionary.get("referenceCustomerId") if dictionary.get("referenceCustomerId") else APIHelper.SKIP
        commercial_code = CommercialCodeEntity1.from_dictionary(dictionary.get('commercialCode')) if 'commercialCode' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Commercial Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(immediate_available_balance,
                   next_day_available_balance,
                   two_days_plus_available_balance,
                   reference_bank_id,
                   reference_branch_id,
                   reference_customer_id,
                   commercial_code,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'immediate_available_balance={(self.immediate_available_balance if hasattr(self, "immediate_available_balance") else None)!r}, '
                f'next_day_available_balance={(self.next_day_available_balance if hasattr(self, "next_day_available_balance") else None)!r}, '
                f'two_days_plus_available_balance={(self.two_days_plus_available_balance if hasattr(self, "two_days_plus_available_balance") else None)!r}, '
                f'reference_bank_id={(self.reference_bank_id if hasattr(self, "reference_bank_id") else None)!r}, '
                f'reference_branch_id={(self.reference_branch_id if hasattr(self, "reference_branch_id") else None)!r}, '
                f'reference_customer_id={(self.reference_customer_id if hasattr(self, "reference_customer_id") else None)!r}, '
                f'commercial_code={(self.commercial_code if hasattr(self, "commercial_code") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'immediate_available_balance={(self.immediate_available_balance if hasattr(self, "immediate_available_balance") else None)!s}, '
                f'next_day_available_balance={(self.next_day_available_balance if hasattr(self, "next_day_available_balance") else None)!s}, '
                f'two_days_plus_available_balance={(self.two_days_plus_available_balance if hasattr(self, "two_days_plus_available_balance") else None)!s}, '
                f'reference_bank_id={(self.reference_bank_id if hasattr(self, "reference_bank_id") else None)!s}, '
                f'reference_branch_id={(self.reference_branch_id if hasattr(self, "reference_branch_id") else None)!s}, '
                f'reference_customer_id={(self.reference_customer_id if hasattr(self, "reference_customer_id") else None)!s}, '
                f'commercial_code={(self.commercial_code if hasattr(self, "commercial_code") else None)!s})')

class DepositTransactionEntity(Transaction):

    """Implementation of the 'Deposit Transaction entity' model.

    A transaction on a deposit account type
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (DepositTransactionType2): CHECK, WITHDRAWAL,
            TRANSFER, POSDEBIT, ATMWITHDRAWAL, BILLPAYMENT, FEE, DEPOSIT,
            ADJUSTMENT, INTEREST, DIVIDEND, DIRECTDEPOSIT, ATMDEPOSIT,
            POSCREDIT
        payee (str): Payee name
        check_number (int): Check number
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "payee": 'payee',
        "check_number": 'checkNumber',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
        'payee',
        'check_number',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 payee=APIHelper.SKIP,
                 check_number=APIHelper.SKIP,
                 account_category='Deposit Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DepositTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 
        if payee is not APIHelper.SKIP:
            self.payee = payee 
        if check_number is not APIHelper.SKIP:
            self.check_number = check_number 

        # Call the constructor for the base class
        super(DepositTransactionEntity, self).__init__(account_category,
                                                       account_id,
                                                       transaction_id,
                                                       reference_transaction_id,
                                                       posted_timestamp,
                                                       transaction_timestamp,
                                                       description,
                                                       memo,
                                                       debit_credit_memo,
                                                       category,
                                                       sub_category,
                                                       reference,
                                                       status,
                                                       amount,
                                                       foreign_amount,
                                                       foreign_currency,
                                                       image_ids,
                                                       line_item,
                                                       reward,
                                                       fi_attributes,
                                                       links,
                                                       additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        payee = dictionary.get("payee") if dictionary.get("payee") else APIHelper.SKIP
        check_number = dictionary.get("checkNumber") if dictionary.get("checkNumber") else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Deposit Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   payee,
                   check_number,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r}, '
                f'payee={(self.payee if hasattr(self, "payee") else None)!r}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s}, '
                f'payee={(self.payee if hasattr(self, "payee") else None)!s}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!s})')

class DigitalWalletTransactionEntity(Transaction):

    """Implementation of the 'Digital Wallet Transaction entity' model.

    A transaction on a digital wallet account
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (DigitalWalletTransactionType2): ADJUSTMENT,
            BILL_PAYMENT, CREDIT, DEBIT, DEPOSIT, DIRECT_DEPOSIT, DIVIDEND,
            FEE, INTEREST, MERCHANT_PAYMENT, MERCHANT_REFUND, TRANSFER_IN,
            TRANSFER_OUT, WITHDRAWAL
        payee (str): Payee name
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "payee": 'payee',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
        'payee',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 payee=APIHelper.SKIP,
                 account_category='Digital Wallet Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DigitalWalletTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 
        if payee is not APIHelper.SKIP:
            self.payee = payee 

        # Call the constructor for the base class
        super(DigitalWalletTransactionEntity, self).__init__(account_category,
                                                             account_id,
                                                             transaction_id,
                                                             reference_transaction_id,
                                                             posted_timestamp,
                                                             transaction_timestamp,
                                                             description,
                                                             memo,
                                                             debit_credit_memo,
                                                             category,
                                                             sub_category,
                                                             reference,
                                                             status,
                                                             amount,
                                                             foreign_amount,
                                                             foreign_currency,
                                                             image_ids,
                                                             line_item,
                                                             reward,
                                                             fi_attributes,
                                                             links,
                                                             additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        payee = dictionary.get("payee") if dictionary.get("payee") else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Digital Wallet Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   payee,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r}, '
                f'payee={(self.payee if hasattr(self, "payee") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s}, '
                f'payee={(self.payee if hasattr(self, "payee") else None)!s})')

class InsuranceTransactionEntity(Transaction):

    """Implementation of the 'Insurance Transaction entity' model.

    An insurance transaction type
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (InsuranceTransactionType): The type of an insurance
            transaction
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 account_category='Insurance Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the InsuranceTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 

        # Call the constructor for the base class
        super(InsuranceTransactionEntity, self).__init__(account_category,
                                                         account_id,
                                                         transaction_id,
                                                         reference_transaction_id,
                                                         posted_timestamp,
                                                         transaction_timestamp,
                                                         description,
                                                         memo,
                                                         debit_credit_memo,
                                                         category,
                                                         sub_category,
                                                         reference,
                                                         status,
                                                         amount,
                                                         foreign_amount,
                                                         foreign_currency,
                                                         image_ids,
                                                         line_item,
                                                         reward,
                                                         fi_attributes,
                                                         links,
                                                         additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Insurance Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s})')

class InvestmentTransactionEntity(Transaction):

    """Implementation of the 'Investment Transaction entity' model.

    Specific transaction information
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (InvestmentTransactionType2): PURCHASED, SOLD,
            PURCHASEDTOCOVER, ADJUSTMENT, PURCHASETOOPEN, PURCHASETOCLOSE,
            SOLDTOOPEN, SOLDTOCLOSE, INTEREST, MARGININTEREST,
            REINVESTOFINCOME, RETURNOFCAPITAL, TRANSFER, CONTRIBUTION, FEE,
            OPTIONEXERCISE, OPTIONEXPIRATION, DIVIDEND, DIVIDENDREINVEST,
            SPLIT, CLOSURE, INCOME, EXPENSE, CLOSUREOPT, INVEXPENSE, JRNLSEC,
            JRNLFUND, OTHER, DIV, SRVCHG, DEP, DEPOSIT, ATM, POS, XFER, CHECK,
            PAYMENT, CASH, DIRECTDEP, DIRECTDEBIT, REPEATPMT
        shares (float): Required for stock, mutual funds. Number of shares
            (with decimals). Negative numbers indicate securities are being
            removed from the account
        face_value (float): Cash value for bonds
        price (float): Unit purchase price
        security_id (str): Unique identifier of security
        security_id_type (SecurityIdType1): CINS, CMC, CME, CUSIP, ISIN, ITSA,
            NASDAQ, SEDOL, SICC, VALOR, WKN
        security_type (SecurityType2): BOND, DEBT, DIGITALASSET, MUTUALFUND,
            OPTION, OTHER, STOCK, SWEEP
        symbol (str): Ticker symbol
        markup (float): Portion of unit price that is attributed to the dealer
            markup
        commission (float): Transaction commission
        taxes (float): Taxes on the trade
        fees (float): Fees applied to the trade
        load (float): Load on the transaction
        inv_401_k_source (Investment401KSourceType2): Source of money. One of
            PRETAX, AFTERTAX, MATCH, PROFITSHARING, ROLLOVER, OTHERVEST,
            OTHERNONVEST
        confirmation_number (str): Confirmation number of the transaction
        fractional_cash (float): Cash for fractional units (used for stock
            splits)
        income_type (IncomeType2): Type of investment income. One of CGLONG
            (capital gains-long term), CGSHORT (capital gains-short term), MISC
        old_units (float): Number of shares before split
        split_ratio_numerator (float): Split ratio numerator
        split_ratio_denominator (float): Split ratio denominator
        new_units (float): Number of shares after split
        sub_account_sec (SubAccountType1): Sub-account security Type. One of
            CASH, MARGIN, SHORT, OTHERS
        sub_account_fund (SubAccountType2): From which account money came in.
            One of CASH, MARGIN, SHORT, OTHERS
        loan_id (str): For 401k accounts only. This indicates the transaction
            was due to a loan or a loan repayment
        loan_principal (float): How much loan pre-payment is principal
        loan_interest (float): How much loan pre-payment is interest
        payroll_date (date): The date for the 401k transaction was obtained in
            payroll
        prior_year_contrib (bool): Indicates this buy was made using prior
            year's contribution
        withholding (float): Federal tax withholding
        tax_exempt (bool): Tax-exempt transaction
        gain (float): For sales
        state_withholding (float): State tax withholding
        penalty (float): Indicates amount withheld due to a penalty
        running_balance (float): Running balance of the position
        unit_price (float): Price per commonly-quoted unit. Does not include
            markup/markdown, unitprice. Share price for stocks, mutual funds,
            and others. Percentage of par for bonds. Per share (not contract)
            for options
        units (float): For security-based actions other than stock splits,
            quantity. Shares for stocks, mutual funds, and others. Face value
            for bonds. Contracts for options
        unit_type (UnitType1): SHARES, CURRENCY
        transaction_reason (TransactionReason2): Reason for this transaction;
            CALL (the debt was called), SELL (the debt was sold), MATURITY
            (the debt reached maturity)
        accrued_interest (float): Accrued interest
        transfer_action (InvestmentTransferActionDirection2): Transfer
            direction
        position_type (PositionType1): LONG, SHORT
        digital_units (str): Full precision unit number, unlimited digits
            after decimal point
        settlement_timestamp (datetime): When the trade settled
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "shares": 'shares',
        "face_value": 'faceValue',
        "price": 'price',
        "security_id": 'securityId',
        "security_id_type": 'securityIdType',
        "security_type": 'securityType',
        "symbol": 'symbol',
        "markup": 'markup',
        "commission": 'commission',
        "taxes": 'taxes',
        "fees": 'fees',
        "load": 'load',
        "inv_401_k_source": 'inv401kSource',
        "confirmation_number": 'confirmationNumber',
        "fractional_cash": 'fractionalCash',
        "income_type": 'incomeType',
        "old_units": 'oldUnits',
        "split_ratio_numerator": 'splitRatioNumerator',
        "split_ratio_denominator": 'splitRatioDenominator',
        "new_units": 'newUnits',
        "sub_account_sec": 'subAccountSec',
        "sub_account_fund": 'subAccountFund',
        "loan_id": 'loanId',
        "loan_principal": 'loanPrincipal',
        "loan_interest": 'loanInterest',
        "payroll_date": 'payrollDate',
        "prior_year_contrib": 'priorYearContrib',
        "withholding": 'withholding',
        "tax_exempt": 'taxExempt',
        "gain": 'gain',
        "state_withholding": 'stateWithholding',
        "penalty": 'penalty',
        "running_balance": 'runningBalance',
        "unit_price": 'unitPrice',
        "units": 'units',
        "unit_type": 'unitType',
        "transaction_reason": 'transactionReason',
        "accrued_interest": 'accruedInterest',
        "transfer_action": 'transferAction',
        "position_type": 'positionType',
        "digital_units": 'digitalUnits',
        "settlement_timestamp": 'settlementTimestamp',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
        'shares',
        'face_value',
        'price',
        'security_id',
        'security_id_type',
        'security_type',
        'symbol',
        'markup',
        'commission',
        'taxes',
        'fees',
        'load',
        'inv_401_k_source',
        'confirmation_number',
        'fractional_cash',
        'income_type',
        'old_units',
        'split_ratio_numerator',
        'split_ratio_denominator',
        'new_units',
        'sub_account_sec',
        'sub_account_fund',
        'loan_id',
        'loan_principal',
        'loan_interest',
        'payroll_date',
        'prior_year_contrib',
        'withholding',
        'tax_exempt',
        'gain',
        'state_withholding',
        'penalty',
        'running_balance',
        'unit_price',
        'units',
        'unit_type',
        'transaction_reason',
        'accrued_interest',
        'transfer_action',
        'position_type',
        'digital_units',
        'settlement_timestamp',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 shares=APIHelper.SKIP,
                 face_value=APIHelper.SKIP,
                 price=APIHelper.SKIP,
                 security_id=APIHelper.SKIP,
                 security_id_type=APIHelper.SKIP,
                 security_type=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 markup=APIHelper.SKIP,
                 commission=APIHelper.SKIP,
                 taxes=APIHelper.SKIP,
                 fees=APIHelper.SKIP,
                 load=APIHelper.SKIP,
                 inv_401_k_source=APIHelper.SKIP,
                 confirmation_number=APIHelper.SKIP,
                 fractional_cash=APIHelper.SKIP,
                 income_type=APIHelper.SKIP,
                 old_units=APIHelper.SKIP,
                 split_ratio_numerator=APIHelper.SKIP,
                 split_ratio_denominator=APIHelper.SKIP,
                 new_units=APIHelper.SKIP,
                 sub_account_sec=APIHelper.SKIP,
                 sub_account_fund=APIHelper.SKIP,
                 loan_id=APIHelper.SKIP,
                 loan_principal=APIHelper.SKIP,
                 loan_interest=APIHelper.SKIP,
                 payroll_date=APIHelper.SKIP,
                 prior_year_contrib=APIHelper.SKIP,
                 withholding=APIHelper.SKIP,
                 tax_exempt=APIHelper.SKIP,
                 gain=APIHelper.SKIP,
                 state_withholding=APIHelper.SKIP,
                 penalty=APIHelper.SKIP,
                 running_balance=APIHelper.SKIP,
                 unit_price=APIHelper.SKIP,
                 units=APIHelper.SKIP,
                 unit_type=APIHelper.SKIP,
                 transaction_reason=APIHelper.SKIP,
                 accrued_interest=APIHelper.SKIP,
                 transfer_action=APIHelper.SKIP,
                 position_type=APIHelper.SKIP,
                 digital_units=APIHelper.SKIP,
                 settlement_timestamp=APIHelper.SKIP,
                 account_category='Investment Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the InvestmentTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 
        if shares is not APIHelper.SKIP:
            self.shares = shares 
        if face_value is not APIHelper.SKIP:
            self.face_value = face_value 
        if price is not APIHelper.SKIP:
            self.price = price 
        if security_id is not APIHelper.SKIP:
            self.security_id = security_id 
        if security_id_type is not APIHelper.SKIP:
            self.security_id_type = security_id_type 
        if security_type is not APIHelper.SKIP:
            self.security_type = security_type 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if markup is not APIHelper.SKIP:
            self.markup = markup 
        if commission is not APIHelper.SKIP:
            self.commission = commission 
        if taxes is not APIHelper.SKIP:
            self.taxes = taxes 
        if fees is not APIHelper.SKIP:
            self.fees = fees 
        if load is not APIHelper.SKIP:
            self.load = load 
        if inv_401_k_source is not APIHelper.SKIP:
            self.inv_401_k_source = inv_401_k_source 
        if confirmation_number is not APIHelper.SKIP:
            self.confirmation_number = confirmation_number 
        if fractional_cash is not APIHelper.SKIP:
            self.fractional_cash = fractional_cash 
        if income_type is not APIHelper.SKIP:
            self.income_type = income_type 
        if old_units is not APIHelper.SKIP:
            self.old_units = old_units 
        if split_ratio_numerator is not APIHelper.SKIP:
            self.split_ratio_numerator = split_ratio_numerator 
        if split_ratio_denominator is not APIHelper.SKIP:
            self.split_ratio_denominator = split_ratio_denominator 
        if new_units is not APIHelper.SKIP:
            self.new_units = new_units 
        if sub_account_sec is not APIHelper.SKIP:
            self.sub_account_sec = sub_account_sec 
        if sub_account_fund is not APIHelper.SKIP:
            self.sub_account_fund = sub_account_fund 
        if loan_id is not APIHelper.SKIP:
            self.loan_id = loan_id 
        if loan_principal is not APIHelper.SKIP:
            self.loan_principal = loan_principal 
        if loan_interest is not APIHelper.SKIP:
            self.loan_interest = loan_interest 
        if payroll_date is not APIHelper.SKIP:
            self.payroll_date = payroll_date 
        if prior_year_contrib is not APIHelper.SKIP:
            self.prior_year_contrib = prior_year_contrib 
        if withholding is not APIHelper.SKIP:
            self.withholding = withholding 
        if tax_exempt is not APIHelper.SKIP:
            self.tax_exempt = tax_exempt 
        if gain is not APIHelper.SKIP:
            self.gain = gain 
        if state_withholding is not APIHelper.SKIP:
            self.state_withholding = state_withholding 
        if penalty is not APIHelper.SKIP:
            self.penalty = penalty 
        if running_balance is not APIHelper.SKIP:
            self.running_balance = running_balance 
        if unit_price is not APIHelper.SKIP:
            self.unit_price = unit_price 
        if units is not APIHelper.SKIP:
            self.units = units 
        if unit_type is not APIHelper.SKIP:
            self.unit_type = unit_type 
        if transaction_reason is not APIHelper.SKIP:
            self.transaction_reason = transaction_reason 
        if accrued_interest is not APIHelper.SKIP:
            self.accrued_interest = accrued_interest 
        if transfer_action is not APIHelper.SKIP:
            self.transfer_action = transfer_action 
        if position_type is not APIHelper.SKIP:
            self.position_type = position_type 
        if digital_units is not APIHelper.SKIP:
            self.digital_units = digital_units 
        if settlement_timestamp is not APIHelper.SKIP:
            self.settlement_timestamp = APIHelper.apply_datetime_converter(settlement_timestamp, APIHelper.RFC3339DateTime) if settlement_timestamp else None 

        # Call the constructor for the base class
        super(InvestmentTransactionEntity, self).__init__(account_category,
                                                          account_id,
                                                          transaction_id,
                                                          reference_transaction_id,
                                                          posted_timestamp,
                                                          transaction_timestamp,
                                                          description,
                                                          memo,
                                                          debit_credit_memo,
                                                          category,
                                                          sub_category,
                                                          reference,
                                                          status,
                                                          amount,
                                                          foreign_amount,
                                                          foreign_currency,
                                                          image_ids,
                                                          line_item,
                                                          reward,
                                                          fi_attributes,
                                                          links,
                                                          additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        shares = dictionary.get("shares") if dictionary.get("shares") else APIHelper.SKIP
        face_value = dictionary.get("faceValue") if dictionary.get("faceValue") else APIHelper.SKIP
        price = dictionary.get("price") if dictionary.get("price") else APIHelper.SKIP
        security_id = dictionary.get("securityId") if dictionary.get("securityId") else APIHelper.SKIP
        security_id_type = dictionary.get("securityIdType") if dictionary.get("securityIdType") else APIHelper.SKIP
        security_type = dictionary.get("securityType") if dictionary.get("securityType") else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        markup = dictionary.get("markup") if dictionary.get("markup") else APIHelper.SKIP
        commission = dictionary.get("commission") if dictionary.get("commission") else APIHelper.SKIP
        taxes = dictionary.get("taxes") if dictionary.get("taxes") else APIHelper.SKIP
        fees = dictionary.get("fees") if dictionary.get("fees") else APIHelper.SKIP
        load = dictionary.get("load") if dictionary.get("load") else APIHelper.SKIP
        inv_401_k_source = dictionary.get("inv401kSource") if dictionary.get("inv401kSource") else APIHelper.SKIP
        confirmation_number = dictionary.get("confirmationNumber") if dictionary.get("confirmationNumber") else APIHelper.SKIP
        fractional_cash = dictionary.get("fractionalCash") if dictionary.get("fractionalCash") else APIHelper.SKIP
        income_type = dictionary.get("incomeType") if dictionary.get("incomeType") else APIHelper.SKIP
        old_units = dictionary.get("oldUnits") if dictionary.get("oldUnits") else APIHelper.SKIP
        split_ratio_numerator = dictionary.get("splitRatioNumerator") if dictionary.get("splitRatioNumerator") else APIHelper.SKIP
        split_ratio_denominator = dictionary.get("splitRatioDenominator") if dictionary.get("splitRatioDenominator") else APIHelper.SKIP
        new_units = dictionary.get("newUnits") if dictionary.get("newUnits") else APIHelper.SKIP
        sub_account_sec = dictionary.get("subAccountSec") if dictionary.get("subAccountSec") else APIHelper.SKIP
        sub_account_fund = dictionary.get("subAccountFund") if dictionary.get("subAccountFund") else APIHelper.SKIP
        loan_id = dictionary.get("loanId") if dictionary.get("loanId") else APIHelper.SKIP
        loan_principal = dictionary.get("loanPrincipal") if dictionary.get("loanPrincipal") else APIHelper.SKIP
        loan_interest = dictionary.get("loanInterest") if dictionary.get("loanInterest") else APIHelper.SKIP
        payroll_date = dateutil.parser.parse(dictionary.get('payrollDate')).date() if dictionary.get('payrollDate') else APIHelper.SKIP
        prior_year_contrib = dictionary.get("priorYearContrib") if "priorYearContrib" in dictionary.keys() else APIHelper.SKIP
        withholding = dictionary.get("withholding") if dictionary.get("withholding") else APIHelper.SKIP
        tax_exempt = dictionary.get("taxExempt") if "taxExempt" in dictionary.keys() else APIHelper.SKIP
        gain = dictionary.get("gain") if dictionary.get("gain") else APIHelper.SKIP
        state_withholding = dictionary.get("stateWithholding") if dictionary.get("stateWithholding") else APIHelper.SKIP
        penalty = dictionary.get("penalty") if dictionary.get("penalty") else APIHelper.SKIP
        running_balance = dictionary.get("runningBalance") if dictionary.get("runningBalance") else APIHelper.SKIP
        unit_price = dictionary.get("unitPrice") if dictionary.get("unitPrice") else APIHelper.SKIP
        units = dictionary.get("units") if dictionary.get("units") else APIHelper.SKIP
        unit_type = dictionary.get("unitType") if dictionary.get("unitType") else APIHelper.SKIP
        transaction_reason = dictionary.get("transactionReason") if dictionary.get("transactionReason") else APIHelper.SKIP
        accrued_interest = dictionary.get("accruedInterest") if dictionary.get("accruedInterest") else APIHelper.SKIP
        transfer_action = dictionary.get("transferAction") if dictionary.get("transferAction") else APIHelper.SKIP
        position_type = dictionary.get("positionType") if dictionary.get("positionType") else APIHelper.SKIP
        digital_units = dictionary.get("digitalUnits") if dictionary.get("digitalUnits") else APIHelper.SKIP
        settlement_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("settlementTimestamp")).datetime if dictionary.get("settlementTimestamp") else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Investment Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   shares,
                   face_value,
                   price,
                   security_id,
                   security_id_type,
                   security_type,
                   symbol,
                   markup,
                   commission,
                   taxes,
                   fees,
                   load,
                   inv_401_k_source,
                   confirmation_number,
                   fractional_cash,
                   income_type,
                   old_units,
                   split_ratio_numerator,
                   split_ratio_denominator,
                   new_units,
                   sub_account_sec,
                   sub_account_fund,
                   loan_id,
                   loan_principal,
                   loan_interest,
                   payroll_date,
                   prior_year_contrib,
                   withholding,
                   tax_exempt,
                   gain,
                   state_withholding,
                   penalty,
                   running_balance,
                   unit_price,
                   units,
                   unit_type,
                   transaction_reason,
                   accrued_interest,
                   transfer_action,
                   position_type,
                   digital_units,
                   settlement_timestamp,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r}, '
                f'shares={(self.shares if hasattr(self, "shares") else None)!r}, '
                f'face_value={(self.face_value if hasattr(self, "face_value") else None)!r}, '
                f'price={(self.price if hasattr(self, "price") else None)!r}, '
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!r}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!r}, '
                f'security_type={(self.security_type if hasattr(self, "security_type") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'markup={(self.markup if hasattr(self, "markup") else None)!r}, '
                f'commission={(self.commission if hasattr(self, "commission") else None)!r}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!r}, '
                f'fees={(self.fees if hasattr(self, "fees") else None)!r}, '
                f'load={(self.load if hasattr(self, "load") else None)!r}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!r}, '
                f'confirmation_number={(self.confirmation_number if hasattr(self, "confirmation_number") else None)!r}, '
                f'fractional_cash={(self.fractional_cash if hasattr(self, "fractional_cash") else None)!r}, '
                f'income_type={(self.income_type if hasattr(self, "income_type") else None)!r}, '
                f'old_units={(self.old_units if hasattr(self, "old_units") else None)!r}, '
                f'split_ratio_numerator={(self.split_ratio_numerator if hasattr(self, "split_ratio_numerator") else None)!r}, '
                f'split_ratio_denominator={(self.split_ratio_denominator if hasattr(self, "split_ratio_denominator") else None)!r}, '
                f'new_units={(self.new_units if hasattr(self, "new_units") else None)!r}, '
                f'sub_account_sec={(self.sub_account_sec if hasattr(self, "sub_account_sec") else None)!r}, '
                f'sub_account_fund={(self.sub_account_fund if hasattr(self, "sub_account_fund") else None)!r}, '
                f'loan_id={(self.loan_id if hasattr(self, "loan_id") else None)!r}, '
                f'loan_principal={(self.loan_principal if hasattr(self, "loan_principal") else None)!r}, '
                f'loan_interest={(self.loan_interest if hasattr(self, "loan_interest") else None)!r}, '
                f'payroll_date={(self.payroll_date if hasattr(self, "payroll_date") else None)!r}, '
                f'prior_year_contrib={(self.prior_year_contrib if hasattr(self, "prior_year_contrib") else None)!r}, '
                f'withholding={(self.withholding if hasattr(self, "withholding") else None)!r}, '
                f'tax_exempt={(self.tax_exempt if hasattr(self, "tax_exempt") else None)!r}, '
                f'gain={(self.gain if hasattr(self, "gain") else None)!r}, '
                f'state_withholding={(self.state_withholding if hasattr(self, "state_withholding") else None)!r}, '
                f'penalty={(self.penalty if hasattr(self, "penalty") else None)!r}, '
                f'running_balance={(self.running_balance if hasattr(self, "running_balance") else None)!r}, '
                f'unit_price={(self.unit_price if hasattr(self, "unit_price") else None)!r}, '
                f'units={(self.units if hasattr(self, "units") else None)!r}, '
                f'unit_type={(self.unit_type if hasattr(self, "unit_type") else None)!r}, '
                f'transaction_reason={(self.transaction_reason if hasattr(self, "transaction_reason") else None)!r}, '
                f'accrued_interest={(self.accrued_interest if hasattr(self, "accrued_interest") else None)!r}, '
                f'transfer_action={(self.transfer_action if hasattr(self, "transfer_action") else None)!r}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!r}, '
                f'digital_units={(self.digital_units if hasattr(self, "digital_units") else None)!r}, '
                f'settlement_timestamp={(self.settlement_timestamp if hasattr(self, "settlement_timestamp") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s}, '
                f'shares={(self.shares if hasattr(self, "shares") else None)!s}, '
                f'face_value={(self.face_value if hasattr(self, "face_value") else None)!s}, '
                f'price={(self.price if hasattr(self, "price") else None)!s}, '
                f'security_id={(self.security_id if hasattr(self, "security_id") else None)!s}, '
                f'security_id_type={(self.security_id_type if hasattr(self, "security_id_type") else None)!s}, '
                f'security_type={(self.security_type if hasattr(self, "security_type") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'markup={(self.markup if hasattr(self, "markup") else None)!s}, '
                f'commission={(self.commission if hasattr(self, "commission") else None)!s}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!s}, '
                f'fees={(self.fees if hasattr(self, "fees") else None)!s}, '
                f'load={(self.load if hasattr(self, "load") else None)!s}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!s}, '
                f'confirmation_number={(self.confirmation_number if hasattr(self, "confirmation_number") else None)!s}, '
                f'fractional_cash={(self.fractional_cash if hasattr(self, "fractional_cash") else None)!s}, '
                f'income_type={(self.income_type if hasattr(self, "income_type") else None)!s}, '
                f'old_units={(self.old_units if hasattr(self, "old_units") else None)!s}, '
                f'split_ratio_numerator={(self.split_ratio_numerator if hasattr(self, "split_ratio_numerator") else None)!s}, '
                f'split_ratio_denominator={(self.split_ratio_denominator if hasattr(self, "split_ratio_denominator") else None)!s}, '
                f'new_units={(self.new_units if hasattr(self, "new_units") else None)!s}, '
                f'sub_account_sec={(self.sub_account_sec if hasattr(self, "sub_account_sec") else None)!s}, '
                f'sub_account_fund={(self.sub_account_fund if hasattr(self, "sub_account_fund") else None)!s}, '
                f'loan_id={(self.loan_id if hasattr(self, "loan_id") else None)!s}, '
                f'loan_principal={(self.loan_principal if hasattr(self, "loan_principal") else None)!s}, '
                f'loan_interest={(self.loan_interest if hasattr(self, "loan_interest") else None)!s}, '
                f'payroll_date={(self.payroll_date if hasattr(self, "payroll_date") else None)!s}, '
                f'prior_year_contrib={(self.prior_year_contrib if hasattr(self, "prior_year_contrib") else None)!s}, '
                f'withholding={(self.withholding if hasattr(self, "withholding") else None)!s}, '
                f'tax_exempt={(self.tax_exempt if hasattr(self, "tax_exempt") else None)!s}, '
                f'gain={(self.gain if hasattr(self, "gain") else None)!s}, '
                f'state_withholding={(self.state_withholding if hasattr(self, "state_withholding") else None)!s}, '
                f'penalty={(self.penalty if hasattr(self, "penalty") else None)!s}, '
                f'running_balance={(self.running_balance if hasattr(self, "running_balance") else None)!s}, '
                f'unit_price={(self.unit_price if hasattr(self, "unit_price") else None)!s}, '
                f'units={(self.units if hasattr(self, "units") else None)!s}, '
                f'unit_type={(self.unit_type if hasattr(self, "unit_type") else None)!s}, '
                f'transaction_reason={(self.transaction_reason if hasattr(self, "transaction_reason") else None)!s}, '
                f'accrued_interest={(self.accrued_interest if hasattr(self, "accrued_interest") else None)!s}, '
                f'transfer_action={(self.transfer_action if hasattr(self, "transfer_action") else None)!s}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!s}, '
                f'digital_units={(self.digital_units if hasattr(self, "digital_units") else None)!s}, '
                f'settlement_timestamp={(self.settlement_timestamp if hasattr(self, "settlement_timestamp") else None)!s})')

class LineOfCreditTransactionEntity(Transaction):

    """Implementation of the 'Line of Credit Transaction entity' model.

    A line of credit transaction
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (LineOfCreditTransactionType2): CHECK, WITHDRAWAL,
            PAYMENT, FEE, ADJUSTMENT, INTEREST, PURCHASE
        check_number (int): Check number
        payment_details (PaymentDetailsEntity): Breakdown of payment details
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "check_number": 'checkNumber',
        "payment_details": 'paymentDetails',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
        'check_number',
        'payment_details',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 check_number=APIHelper.SKIP,
                 payment_details=APIHelper.SKIP,
                 account_category='Line of Credit Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LineOfCreditTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 
        if check_number is not APIHelper.SKIP:
            self.check_number = check_number 
        if payment_details is not APIHelper.SKIP:
            self.payment_details = payment_details 

        # Call the constructor for the base class
        super(LineOfCreditTransactionEntity, self).__init__(account_category,
                                                            account_id,
                                                            transaction_id,
                                                            reference_transaction_id,
                                                            posted_timestamp,
                                                            transaction_timestamp,
                                                            description,
                                                            memo,
                                                            debit_credit_memo,
                                                            category,
                                                            sub_category,
                                                            reference,
                                                            status,
                                                            amount,
                                                            foreign_amount,
                                                            foreign_currency,
                                                            image_ids,
                                                            line_item,
                                                            reward,
                                                            fi_attributes,
                                                            links,
                                                            additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        check_number = dictionary.get("checkNumber") if dictionary.get("checkNumber") else APIHelper.SKIP
        payment_details = PaymentDetailsEntity.from_dictionary(dictionary.get('paymentDetails')) if 'paymentDetails' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Line of Credit Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   check_number,
                   payment_details,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!r}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s}, '
                f'check_number={(self.check_number if hasattr(self, "check_number") else None)!s}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!s})')

class LoanTransactionEntity(Transaction):

    """Implementation of the 'Loan Transaction entity' model.

    A transaction on a loan account
    NOTE: This class inherits from 'Transaction'.

    Attributes:
        transaction_type (LoanTransactionType2): PAYMENT, FEE, ADJUSTMENT,
            INTEREST
        payment_details (PaymentDetailsEntity): Breakdown of payment details
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "transaction_type": 'transactionType',
        "payment_details": 'paymentDetails',
        "account_category": 'accountCategory',
        "account_id": 'accountId',
        "transaction_id": 'transactionId',
        "reference_transaction_id": 'referenceTransactionId',
        "posted_timestamp": 'postedTimestamp',
        "transaction_timestamp": 'transactionTimestamp',
        "description": 'description',
        "memo": 'memo',
        "debit_credit_memo": 'debitCreditMemo',
        "category": 'category',
        "sub_category": 'subCategory',
        "reference": 'reference',
        "status": 'status',
        "amount": 'amount',
        "foreign_amount": 'foreignAmount',
        "foreign_currency": 'foreignCurrency',
        "image_ids": 'imageIds',
        "line_item": 'lineItem',
        "reward": 'reward',
        "fi_attributes": 'fiAttributes',
        "links": 'links'
    }

    _optionals = [
        'transaction_type',
        'payment_details',
    ]
    _optionals.extend(Transaction._optionals)

    def __init__(self,
                 transaction_type=APIHelper.SKIP,
                 payment_details=APIHelper.SKIP,
                 account_category='Loan Transaction entity',
                 account_id=APIHelper.SKIP,
                 transaction_id=APIHelper.SKIP,
                 reference_transaction_id=APIHelper.SKIP,
                 posted_timestamp=APIHelper.SKIP,
                 transaction_timestamp=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 debit_credit_memo=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 sub_category=APIHelper.SKIP,
                 reference=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 foreign_amount=APIHelper.SKIP,
                 foreign_currency=APIHelper.SKIP,
                 image_ids=APIHelper.SKIP,
                 line_item=APIHelper.SKIP,
                 reward=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the LoanTransactionEntity class"""

        # Initialize members of the class
        if transaction_type is not APIHelper.SKIP:
            self.transaction_type = transaction_type 
        if payment_details is not APIHelper.SKIP:
            self.payment_details = payment_details 

        # Call the constructor for the base class
        super(LoanTransactionEntity, self).__init__(account_category,
                                                    account_id,
                                                    transaction_id,
                                                    reference_transaction_id,
                                                    posted_timestamp,
                                                    transaction_timestamp,
                                                    description,
                                                    memo,
                                                    debit_credit_memo,
                                                    category,
                                                    sub_category,
                                                    reference,
                                                    status,
                                                    amount,
                                                    foreign_amount,
                                                    foreign_currency,
                                                    image_ids,
                                                    line_item,
                                                    reward,
                                                    fi_attributes,
                                                    links,
                                                    additional_properties)

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        transaction_type = dictionary.get("transactionType") if dictionary.get("transactionType") else APIHelper.SKIP
        payment_details = PaymentDetailsEntity.from_dictionary(dictionary.get('paymentDetails')) if 'paymentDetails' in dictionary.keys() else APIHelper.SKIP
        account_category = dictionary.get("accountCategory") if dictionary.get("accountCategory") else 'Loan Transaction entity'
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        transaction_id = dictionary.get("transactionId") if dictionary.get("transactionId") else APIHelper.SKIP
        reference_transaction_id = dictionary.get("referenceTransactionId") if dictionary.get("referenceTransactionId") else APIHelper.SKIP
        posted_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("postedTimestamp")).datetime if dictionary.get("postedTimestamp") else APIHelper.SKIP
        transaction_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("transactionTimestamp")).datetime if dictionary.get("transactionTimestamp") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        debit_credit_memo = dictionary.get("debitCreditMemo") if dictionary.get("debitCreditMemo") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        sub_category = dictionary.get("subCategory") if dictionary.get("subCategory") else APIHelper.SKIP
        reference = dictionary.get("reference") if dictionary.get("reference") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        foreign_amount = dictionary.get("foreignAmount") if dictionary.get("foreignAmount") else APIHelper.SKIP
        foreign_currency = dictionary.get("foreignCurrency") if dictionary.get("foreignCurrency") else APIHelper.SKIP
        image_ids = dictionary.get("imageIds") if dictionary.get("imageIds") else APIHelper.SKIP
        line_item = None
        if dictionary.get('lineItem') is not None:
            line_item = [LineItemEntity.from_dictionary(x) for x in dictionary.get('lineItem')]
        else:
            line_item = APIHelper.SKIP
        reward = TransactionRewardEntity2.from_dictionary(dictionary.get('reward')) if 'reward' in dictionary.keys() else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(transaction_type,
                   payment_details,
                   account_category,
                   account_id,
                   transaction_id,
                   reference_transaction_id,
                   posted_timestamp,
                   transaction_timestamp,
                   description,
                   memo,
                   debit_credit_memo,
                   category,
                   sub_category,
                   reference,
                   status,
                   amount,
                   foreign_amount,
                   foreign_currency,
                   image_ids,
                   line_item,
                   reward,
                   fi_attributes,
                   links,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        base_repr = super().__repr__()
        return (f'{self.__class__.__name__}('
                f'{base_repr[base_repr.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!r}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!r})')

    def __str__(self):
        base_str = super().__str__()
        return (f'{self.__class__.__name__}('
                f'{base_str[base_str.find("(") + 1:-1]}, '
                f'transaction_type={(self.transaction_type if hasattr(self, "transaction_type") else None)!s}, '
                f'payment_details={(self.payment_details if hasattr(self, "payment_details") else None)!s})')
