﻿## VSCodeでのデバッグ
```
python -m http.server 7000
```

## 操作方法

### ソフトの起動からファイルを開き、計算するまでの手順
1. ブラウザで`fem.html`を開いてFEM3Dアプリケーションを起動します
2. 「ファイル」ボタンをクリックしてファイル選択ダイアログを表示します
3. 入力ファイル（例：`data\shell\shellBeamQuad1.fem`）を選択します
4. 「読込」ボタンをクリックしてモデルデータを読み込みます
5. 「計算」ボタンをクリックして計算設定ダイアログを表示します
6. 必要に応じて計算設定（解析種類、方程式解法など）を選択します
7. 「計算開始」ボタンをクリックして構造解析を実行します
8. 「結果表示設定」ボタンから変形表示倍率やコンター図表示を設定できます

## zipの中に含まれるファイル（このreadmeを除く）
・Fem.js		Javascriptのプログラムファイルです
・Fem.min.js		上記ファイルの空白・コメント・改行を除いて容量を圧縮したファイルです
・fem.html		Webページのhtmlファイルです
・fem.css		上記htmlのスタイルシートです
・src			ソースファイルを格納したフォルダです
			プログラムファイルはsrcフォルダ内のファイルを単純に結合したものです
・FileFormat.pdf	入力データファイルの書式の説明文です


## バージョン履歴
2017/07/31	ver.1.10 梁要素・シェル要素の質量マトリックスを修正
2017/07/09	ver.1.9 線形座屈解析をLanczos法からArnoldi法に変更
		・それにより正定値行列以外の種々の荷重条件に対応可
2017/07/07	ver.1.8 以下の項追加
		・線形座屈解析
2017/06/20	ver.1.7 以下の項追加
		・歪・応力・歪エネルギー密度の出力を節点・要素から選択
		・固有振動解析
2017/06/07	ver.1.6 以下の項追加
		・局所座標系（拘束条件・荷重条件）
		・梁要素
		　要素：ベルヌーイ-オイラー梁，ティモシェンコ梁
		　断面：円形断面，矩形断面
		・ソリッド要素のみの場合は裏面出力を除去
2017/05/31	ver.1.5 計算を高速化
2017/05/28	ver.1.4 以下の項目追加
		・計算結果の歪エネルギー密度
		・ファイル出力機能
		・計算結果（ファイル入出力項目）
2017/05/24	ver.1.3 以下の項目追加
		・シェル要素の熱解析
		・Wilson-Taylor型非適合要素
		・要素辺表示
2017/05/22	ver.1.2 HTML5版作成
