# 3次元有限要素法プログラム 入力データファイル書式

* データは基本的に1行1データ
* データの各項目はタブまたはスペース区切り
* 行の最初にデータ種類を表すキーワードを記述し、後ろに必要なデータを並べる

## キーワード

* **特性データ**
  `Material`、`ShellParameter`、`BarParameter`、`Coordinates`
* **節点**
  `Node`
* **梁要素**
  `BEBarElement`、`TBarElement`
* **シェル要素**
  `TriElement1`、`QuadElement1`
* **ソリッド要素**
  `TetraElement1`、`WedgeElement1`、`HexaElement1`、`HexaElement1WT`、`TetraElement2`、`WedgeElement2`、`HexaElement2`
* **境界条件**
  `Restraint`、`Load`、`Pressure`、`Temperature`、`HTC`
* **計算結果**
  `ResultType`、`EigenValue`、`Displacement`、`Strain1`、`Strain2`、`Stress1`、`Stress2`、`StrEnergy1`、`StrEnergy2`、`Temp`

---

# 各データの書式

---

## 1. 特性データ

### 1.1 Material（材料パラメータ）

1. 材料番号
2. ヤング率（縦弾性係数）
3. ポアソン比
4. 横弾性係数（ダミー）

   * 実際にはヤング率とポアソン比から計算する
5. 密度
6. 熱伝導率
7. 質量比熱

---

### 1.2 ShellParameter（シェルパラメータ）

1. パラメータ番号
2. 板厚

---

### 1.3 BarParameter（梁パラメータ）

1. パラメータ番号
2. 断面種類（`Circle` または `Rectangle`）

#### - Circle（円形断面／パイプ状断面）の場合

3. 外径
4. 内径（穴径）

#### - Rectangle（矩形断面／角パイプ）の場合

3. 外側幅（断面基準方向）
4. 外側高さ（断面基準と垂直方向）
5. 内側（穴）幅
6. 内側（穴）高さ

---

### 1.4 Coordinates（局所座標系）

1. 座標系番号
2. ～ 4. 局所座標系の x 軸方向ベクトル $`cx`$
3. ～ 7. 局所座標系の y 軸方向ベクトル $`cy`$
4. ～10. 局所座標系の z 軸方向ベクトル $`cz`$

* 局所座標系は境界条件の拘束条件・荷重条件で使用する
* 各方向ベクトルはプログラム読み込み時に単位ベクトル `ci/|ci|` に変換される
* 条件：`|ci| > 0`，かつ `ci・cj ≠ 0`（i ≠ j）
* 局所座標 x' と全体座標 x は次の関係にある：

  ```
  x = C x'  
  x' = C^T x  
  C = [ cx  cy  cz ]
  ```

---

## 2. 節点（Node）

`Node` キーワードの後に以下を並べる（各項目はスペース区切り）：

1. 節点番号
2. x 座標
3. y 座標
4. z 座標

---

## 3. 梁要素

### BEBarElement / TBarElement（ベルヌーイ＝オイラー／ティモシェンコ梁要素）

* データ書式は両者共通
* 各項目はスペースまたはタブ区切りで入力

1. 要素番号
2. 材料番号
3. 梁パラメータ番号
4. (必須) 節点番号①
5. (必須) 節点番号②

（以下はオプション）

6. ～ 8. 断面内の基準方向ベクトル（断面幅方向）

   * ベクトルは梁要素の垂直平面に投影し、単位ベクトルに変換される
   * 指定しない場合は自動的に適当な方向（x 軸または y 軸）に設定されるため、円形断面では指定不要

---

## 4. シェル要素

### TriElement1（三角形1次要素／薄肉シェル）

1. 要素番号
2. 材料番号
3. シェルパラメータ番号
4. ～ 6. 節点番号

---

### QuadElement1（四角形1次要素／MITC4）

1. 要素番号
2. 材料番号
3. シェルパラメータ番号
4. ～ 7. 節点番号

---

#### 節点ポインタ番号・辺ポインタ番号（境界条件設定に使用）

* 入力データの節点番号はポインタ 1, 2, … に割り当てられる
* 節点番号の並び順や辺ポインタ番号は図を参照してください。

  * **図の概要（ページ3）**

    * 左図（TriElement1）：節点 1–2–3 が三角形を構成し、辺ポインタ番号が各辺に付与されている。
    * 右図（QuadElement1）：節点 1–2–3–4 の順で四角形を構成し、辺ポインタ番号が各辺に付与されている。
    * 画像を参照し、各節点のポインタ番号と辺ポインタ番号を確認してください。
  * ![シェル要素の節点ポインタ番号・辺ポインタ番号（ページ3）](img/page3_img1.png)

    * *(ページ3に掲載された図。三角形要素と四角形要素の頂点と辺に付与された番号を示しています。)*

---

## 5. ソリッド要素

各要素ともに、各項目はスペースまたはタブ区切りで入力します。

### TetraElement1（四面体1次要素）

1. 要素番号
2. 材料番号
3. ～ 6. 節点番号

---

### WedgeElement1（楔形1次要素）

1. 要素番号
2. 材料番号
3. ～ 8. 節点番号

---

### HexaElement1（六面体1次要素）

1. 要素番号
2. 材料番号
3. ～10. 節点番号

---

### HexaElement1WT（六面体1次非適合要素／Wilson-Wilson-Taylor 型）

1. 要素番号
2. 材料番号
3. ～10. 節点番号

---

### TetraElement2（四面体2次要素）

1. 要素番号
2. 材料番号
3. ～12. 節点番号

---

### WedgeElement2（楔形2次要素）

1. 要素番号
2. 材料番号
3. ～17. 節点番号

---

### HexaElement2（六面体2次要素）

1. 要素番号
2. 材料番号
3. ～22. 節点番号

---

#### 節点ポインタ番号・面ポインタ番号（境界条件設定に使用）

* 入力データの節点番号はポインタ 1, 2, … に割り当てられる
* 面ポインタ番号は境界条件設定に使用される
* 各要素ごとのポインタ番号の割り当ては図を参照してください。

  * **四面体要素（1次要素は節点4まで）**

    * ページ5の図にて、頂点1–2–3–4 の位置や面ポインタ番号（1～4）が示されています。
    * ![四面体要素の節点ポインタ番号・面ポインタ番号（ページ5）](img/page5_img1.png)

      * *(頂点と面への番号割り当てが図示されています。)*

  * **楔形要素（1次要素は節点6まで）**

    * 同じくページ5の図にて、頂点1–2–3–4–5–6 の位置や面ポインタ番号（1～5）が示されています。
    * ![楔形要素の節点ポインタ番号・面ポインタ番号（ページ5）](img/page5_img2.png)

      * *(楔形の各頂点および面に付与された番号が表示されています。)*

  * **六面体要素（1次要素は節点8まで）**

    * ページ5の図にて、頂点1–2–3–4–5–6–7–8 の位置や面ポインタ番号（1～6）が示されています。
    * ![六面体要素の節点ポインタ番号・面ポインタ番号（ページ5）](img/page5_img3.png)

      * *(各頂点および対応する面に付与された番号が図示されています。)*

---

## 6. 境界条件

### 6.1 Restraint（拘束条件）

1. 節点番号
2. x 方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
3. x 方向強制変位量
4. y 方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
5. y 方向強制変位量
6. z 方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
7. z 方向強制変位量

（以下はオプション。回転方向拘束はソリッド要素では無視される）

8. x 軸周り方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
9. x 軸周り方向強制変位量
10. y 軸周り方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
11. y 軸周り方向強制変位量
12. z 軸周り方向拘束・強制変位の有無（1＝拘束あり，0＝拘束なし）
13. z 軸周り方向強制変位量
14. （8個目または14個目）局所座標系番号

> ※ 回転成分は 13 個目まで全て記述する必要があり、途中までの記述は無視されます。

---

### 6.2 Load（荷重条件）

1. 節点番号
2. 荷重 x 方向成分
3. 荷重 y 方向成分
4. 荷重 z 方向成分

（以下はオプション。回転方向成分はソリッド要素では無視される）

5. 荷重（トルク）x 軸周り方向成分
6. 荷重（トルク）y 軸周り方向成分
7. 荷重（トルク）z 軸周り方向成分
8. （5個目または8個目）局所座標系番号

> ※ 回転成分は 7 個目まで全て記述する必要があり、途中までの記述は無視されます。

---

### 6.3 Pressure（面圧条件）

1. 要素番号
2. 要素境界 F\*（\* は面ポインタ番号）
3. 圧力の値

---

### 6.4 Temperature（節点温度条件）

1. 節点番号
2. 固定する温度

---

### 6.5 HTC（熱伝達条件）

1. 要素番号
2. 要素境界 F\*（\* は面ポインタ番号）または E\*（\* は辺ポインタ番号）
3. 熱伝達率
4. 雰囲気温度

---

## 7. 計算結果

* 変位・温度は節点での値
* 歪・応力・歪エネルギー密度は以下の何れかで出力される：

  * **節点データ**：周辺要素の値を平均した節点での値
  * **要素データ**：積分点の値を平均した要素での値

---

### 7.1 ResultType（計算結果種類）

1. 出力データ種類

   * `Node`（節点データ）
   * `Element`（要素データ）
   * ※ このキーワードを指定しない場合は節点データとなる

---

### 7.2 EigenValue（固有値）

1. 解析種類

   * `Vibration`（振動）
   * `Buckling`（座屈）
2. 固有値の数値

   * 振動の場合：振動数 $f$($\lambda$ に対し $f = \sqrt{\lambda}/(2\pi)$, $\lambda=(2\pi f)^2$)
   * 座屈の場合：固有値 $\lambda = $ 座屈荷重／モデル荷重

---

### 7.3 Displacement（節点変位）

1. 節点番号
2. 変位 x 方向成分
3. 変位 y 方向成分
4. 変位 z 方向成分
5. 変位（回転角）x 軸周り方向成分
6. 変位（回転角）y 軸周り方向成分
7. 変位（回転角）z 軸周り方向成分

---

### 7.4 Strain1, Strain2（歪／工学歪）

* `1`：シェル表面
* `2`：シェル裏面 ※

1. 節点または要素番号
2. 歪 x 成分
3. 歪 y 成分
4. 歪 z 成分
5. せん断歪 xy 成分
6. せん断歪 yz 成分
7. せん断歪 zx 成分

> ※ ソリッド要素では 1, 2 同じ値が入る

---

### 7.5 Stress1, Stress2（応力）

* `1`：シェル表面
* `2`：シェル裏面 ※

1. 節点または要素番号
2. 応力 x 成分
3. 応力 y 成分
4. 応力 z 成分
5. せん断応力 xy 成分
6. せん断応力 yz 成分
7. せん断応力 zx 成分

> ※ ソリッド要素では 1, 2 同じ値が入る

---

### 7.6 StrEnergy1, StrEnergy2（歪エネルギー密度）

* `1`：シェル表面
* `2`：シェル裏面 ※

1. 節点または要素番号
2. 歪エネルギー密度

> ※ ソリッド要素では 1, 2 同じ値が入る

---

### 7.7 Temp（節点温度）

1. 節点番号
2. 温度

---

#### ※ シェル表面・裏面の値について

* ソリッド要素では `1` と `2` が同じ値になる
* 梁要素（円形断面）の場合：曲げ応力の最大・最小の値（曲げの外側・内側の値）が `1`, `2` に入る
* 梁要素（矩形断面）の場合：辺の中点および角の計 8 点の歪エネルギー密度を比較し、最大の点およびその対称点の値が入る。

  * 曲げの外側が `1`、内側が `2`
  * 斜め方向の曲げは角、捩りでは長辺の中点が最大応力部位となるため
