# データ構造

## データ構造チートシート

### 節点定義
```json
"node": {
  "節点ID": {"x": X座標, "y": Y座標, "z": Z座標}
}
```

### 材料・断面特性（element）
**材料データは全ての要素（bar, shell, solid）で参照されますが、各フィールドの意味・用途は要素ごとに異なります。**

```json
"element": {
  "要素特性ケースID": {
    "要素ID": {
      "E": ヤング係数, // kN/m²
      "G": せん断弾性係数, // kN/m²
      "nu": ポアソン比,
      "Xp": 線膨張係数, // /℃
      "A": 断面積または厚さ, // 要素により意味が異なる
      "Iy": Y軸回り断面二次モーメント, // 梁要素のみ
      "Iz": Z軸回り断面二次モーメント, // 梁要素のみ
      "J": ねじり定数 // 梁要素のみ
    }
  }
}
```

#### A, Iy, Iz, J の要素ごとの扱い
| 変数 | 梁要素（bar） | シェル要素（shell） | ソリッド要素（tetra, wedge, hexa） |
|------|:-------------:|:------------------:|:----------------------------------:|
| **A** | ● 必須<br>断面積（m²） | ● 必須<br>厚さt（m）として利用 | × 不要 |
| **Iy** | ● 必須<br>Y軸回り断面二次モーメント | × 不要 | × 不要 |
| **Iz** | ● 必須<br>Z軸回り断面二次モーメント | × 不要 | × 不要 |
| **J** | ● 必須<br>ねじり定数 | × 不要 | × 不要 |

**注意：シェル要素の厚さはAフィールドで指定します（断面積ではなく厚さとして解釈）**

### 非線形材料定義（JR総研剛性低減RC型）

材料非線形解析では、要素特性に`nonlinear`オブジェクトを追加して履歴モデルを定義します。

```json
"element": {
  "要素特性ケースID": {
    "要素ID": {
      "E": 26500000,
      "G": 1,
      "A": 1000,
      "Iy": 1,
      "Iz": 1000,
      "J": 1,
      "n": "非線形材料",
      "nonlinear": {
        "type": "jr_stiffness_reduction",
        "delta_1": 0.00001,    // ひび割れ変位 (m)
        "delta_2": 0.0001,     // 降伏変位 (m)
        "delta_3": 0.001,      // 終局変位 (m)
        "P_1": 1000.0,         // ひび割れ荷重 (N)
        "P_2": 3000.0,         // 降伏荷重 (N)
        "P_3": 5000.0,         // 終局荷重 (N)
        "beta": 0.4,           // 剛性低減係数
        "symmetric": true,     // 正負対称スケルトンカーブ
        "hysteresis_dofs": ["moment_z"]  // 非線形適用自由度
      }
    }
  }
}
```

#### 非線形パラメータ
| パラメータ | 説明 | 単位 |
|-----------|------|------|
| type | 履歴モデルタイプ（"jr_stiffness_reduction"） | - |
| delta_1 | ひび割れ変位 | m |
| delta_2 | 降伏変位 | m |
| delta_3 | 終局変位 | m |
| P_1 | ひび割れ荷重 | N |
| P_2 | 降伏荷重 | N |
| P_3 | 終局荷重 | N |
| beta | 剛性低減係数（典型値: 0.4） | - |
| symmetric | 正負対称スケルトンカーブ | bool |
| hysteresis_dofs | 非線形適用自由度 | 配列 |

#### hysteresis_dofs の選択肢
- `"axial"`: 軸力（N）
- `"moment_y"`: Y軸周り曲げモーメント（My）
- `"moment_z"`: Z軸周り曲げモーメント（Mz）
- `"torsion"`: ねじりモーメント（Mx）

#### 非対称スケルトンカーブ
正側と負側で異なるパラメータを指定する場合：
```json
"nonlinear": {
  "type": "jr_stiffness_reduction",
  "delta_1_pos": 0.003, "delta_2_pos": 0.015, "delta_3_pos": 0.060,
  "P_1_pos": 100000, "P_2_pos": 500000, "P_3_pos": 550000,
  "delta_1_neg": 0.002, "delta_2_neg": 0.010, "delta_3_neg": 0.040,
  "P_1_neg": 80000, "P_2_neg": 400000, "P_3_neg": 420000,
  "beta": 0.4,
  "symmetric": false,
  "hysteresis_dofs": ["moment_z"]
}
```

### 部材定義（梁要素：bar）
```json
"member": {
  "部材ID": {
    "ni": 始点節点ID,
    "nj": 終点節点ID,
    "e": 要素ID,
    "code_angle": コードアングル // x軸回り回転角（度, 3Dのみ）
  }
}
```

### シェル要素定義（shell）
```json
"shell": {
  "シェルID": {
    "nodes": [節点1, 節点2, 節点3, 節点4], // 3点（三角形）または4点（四角形）
    "e": 材料ID,
    "t": 厚さ番号 // 通常は材料IDと同じ
  }
}
```

### ソリッド要素定義（tetra, wedge, hexa）
```json
"solid": {
  "ソリッドID": {
    "nodes": [節点リスト], // 4点（tetra）, 6点（wedge）, 8点（hexa）
    "e": 材料ID,
    "type": "tetra|wedge|hexa"
  }
}
```

### 支点条件
```json
"fix_node": {
  "支点ケースID": [
    {
      "n": 節点ID,
      "tx": 0, // X方向拘束（0=自由, 1=拘束, 実数=強制変位）
      "ty": 1,
      "tz": 0,
      "rx": 0,
      "ry": 1,
      "rz": 0
    }
  ]
}
```

### 荷重定義
```json
"load": {
  "荷重ケースID": {
    "rate": 1.0,
    "symbol": "DL",
    "load_node": [
      {"n": 節点ID, "tx": 0, "ty": -10, "tz": 0, "mx": 0, "my": 0, "mz": 0}
    ],
    "load_member": [
      {"m": 部材ID, "direction": "gy", "p1": -20, "p2": -20, "L1": 0, "L2": 8}
    ]
  }
}
```

## 入力データ構造

FrameWeb3 APIは構造モデルデータをJSON形式で受け取ります。以下のセクションでは、完全なデータ構造仕様について説明します。

### ルートオブジェクト
```json
{
  "dimension": 2|3, // 2次元解析(2)または3次元解析(3)の指定
  "node": { ... }, // 必須: 節点定義
  "member": { ... }, // オプション: 梁部材定義
  "shell": { ... }, // オプション: シェル要素定義
  "solid": { ... }, // オプション: ソリッド要素定義
  "element": { ... }, // 必須: 材料・断面特性
  "thickness": { ... }, // オプション: シェル厚さ定義
  "fix_node": { ... }, // オプション: 支点条件
  "fix_member": { ... }, // オプション: バネ支点
  "joint": { ... }, // オプション: 材端条件
  "load": { ... } // 必須: 荷重ケース
}
```

### 節点定義
座標を持つ構造節点を定義します。
```json
"node": {
  "1": {"x": 0.0, "y": 0.0, "z": 0.0},
  "2": {"x": 5.0, "y": 0.0, "z": 0.0}
}
```

**プロパティ:**
- `x` (float): X座標（メートル）
- `y` (float): Y座標（メートル）
- `z` (float): Z座標（メートル、3D解析では必須）

### 部材定義
2つの節点を結ぶ梁要素を定義します。
```json
"member": {
  "1": {
    "ni": 1, // 始点節点番号
    "nj": 2, // 終点節点番号
    "e": 1, // 要素特性番号
    "cg": {"x": 0, "y": 0, "z": 1}, // オプション: 局所座標系
    "angle": 0 // オプション: 回転角（度）
  }
}
```

**プロパティ:**
- `ni` (int): 始点節点番号
- `nj` (int): 終点節点番号
- `e` (int): 要素特性参照
- `cg` (object, オプション): 局所座標系ベクトル
- `angle` (float, オプション): 要素回転角（度）

### シェル定義
シェル・パネル要素を定義します。
```json
"shell": {
  "1": {
    "ni": 1, // 節点1
    "nj": 2, // 節点2
    "nk": 3, // 節点3
    "nl": 4, // 節点4（三角形要素ではオプション）
    "e": 1 // 材料特性番号
  }
}
```

**プロパティ:**
- `ni`, `nj`, `nk` (int): 必須節点番号
- `nl` (int, オプション): 四角形要素の第4節点
- `e` (int): 材料特性参照

### ソリッド定義
3Dソリッド要素を定義します。
```json
"solid": {
  "1": {
    "type": "tetra", // 要素タイプ: "tetra" または "hexa"
    "nodes": [1, 2, 3, 4], // 節点番号
    "e": 1 // 材料特性番号
  }
}
```

**プロパティ:**
- `type` (string): 要素タイプ（"tetra"は4節点、"hexa"は8節点）
- `nodes` (array): 節点番号（tetraは4個、hexaは8個）
- `e` (int): 材料特性参照

### 要素特性
材料・断面特性を定義します。
```json
"element": {
  "1": {
    "E": 205000000, // ヤング係数（kN/m²）
    "G": 79000000, // せん断弾性係数（kN/m²）
    "poi": 0.3, // ポアソン比
    "cte": 1.2e-5, // 線膨張係数（/℃）
    "A": 0.01, // 断面積（m²）
    "Iy": 0.0001, // y軸回りの断面二次モーメント（m⁴）
    "Iz": 0.0001, // z軸回りの断面二次モーメント（m⁴）
    "J": 0.0001 // ねじり定数（m⁴）
  }
}
```

**梁特性:**
- `E` (float): ヤング係数（kN/m²）
- `G` (float): せん断弾性係数（kN/m²）
- `poi` (float): ポアソン比
- `cte` (float): 線膨張係数（/℃）
- `A` (float): 断面積（m²）
- `Iy` (float): 局所y軸回りの断面二次モーメント（m⁴）
- `Iz` (float): 局所z軸回りの断面二次モーメント（m⁴）
- `J` (float): ねじり定数（m⁴）

**シェル・ソリッド特性:**
- `E` (float): ヤング係数（kN/m²）
- `G` (float): せん断弾性係数（kN/m²）
- `poi` (float): ポアソン比

### 厚さ定義
シェル要素の厚さを定義します。
```json
"thickness": {
  "1": {"t": 0.2} // 厚さ（メートル）
}
```

### 支点条件
節点での境界条件を定義します。
```json
"fix_node": {
  "1": { // 支点ケース番号
    "1": { // 節点番号
      "x": 1, // X方向変位拘束（1=固定、0=自由）
      "y": 1, // Y方向変位拘束
      "z": 1, // Z方向変位拘束
      "rx": 1, // X軸回り回転拘束
      "ry": 1, // Y軸回り回転拘束
      "rz": 1 // Z軸回り回転拘束
    }
  }
}
```

### バネ支点
部材上の弾性支点を定義します。
```json
"fix_member": {
  "1": { // バネケース番号
    "1": { // 部材番号
      "x": 1000, // X方向バネ剛性（kN/m）
      "y": 1000, // Y方向バネ剛性（kN/m）
      "z": 1000 // Z方向バネ剛性（kN/m）
    }
  }
}
```

### 材端条件
部材端の解放条件を定義します。
```json
"joint": {
  "1": { // 材端ケース番号
    "1": { // 部材番号
      "xi": 0, // i端X方向力解放（1=解放、0=固定）
      "yi": 0, // i端Y方向力解放
      "zi": 0, // i端Z方向力解放
      "rxi": 0, // i端X軸回りモーメント解放
      "ryi": 0, // i端Y軸回りモーメント解放
      "rzi": 0, // i端Z軸回りモーメント解放
      "xj": 0, // j端解放条件...
      "yj": 0,
      "zj": 0,
      "rxj": 0,
      "ryj": 0,
      "rzj": 0
    }
  }
}
```

### 荷重ケース
荷重条件を定義します。
```json
"load": {
  "1": { // 荷重ケースID
    "rate": 1.0, // 荷重係数
    "symbol": "DL", // 荷重記号
    "fix_node": 1, // 支点ケース参照
    "fix_member": 1, // バネケース参照
    "element": 1, // 材料ケース参照
    "joint": 1, // 材端ケース参照
    "n_load_steps": 10, // 荷重増分ステップ数（材料非線形用）
    "max_iterations": 50, // 最大反復回数（材料非線形用）
    "tolerance": 1e-6, // 収束判定許容差（材料非線形用）
    "n_modes": 10, // 固有モード数（モード解析用）
    "load_node": [...], // 節点荷重
    "load_member": [...], // 部材荷重
    "load_heat": [...] // 温度荷重
  }
}
```

#### 解析パラメータ
| パラメータ | 説明 | デフォルト値 | 対象解析 |
|-----------|------|-------------|---------|
| n_load_steps | 荷重増分ステップ数 | 10 | material_nonlinear |
| max_iterations | Newton-Raphson最大反復回数 | 50 | material_nonlinear |
| tolerance | 収束判定許容差 | 1e-6 | material_nonlinear |
| n_modes | 固有モード数 | 10 | modal |

#### 節点荷重
```json
"load_node": [
  {
    "n": 2, // 節点番号
    "tx": 0, // X方向力（kN）
    "ty": -50, // Y方向力（kN）
    "tz": 0, // Z方向力（kN）
    "rx": 0, // X軸回りモーメント（kNm）
    "ry": 0, // Y軸回りモーメント（kNm）
    "rz": 0, // Z軸回りモーメント（kNm）
    "dx": 0, // X方向強制変位（m）
    "dy": 0, // Y方向強制変位（m）
    "dz": 0 // Z方向強制変位（m）
  }
]
```

## 出力データ構造

### 節点変位
```json
"disg": {
  "節点ID": {
    "dx": X方向変位, // mm
    "dy": Y方向変位, // mm
    "dz": Z方向変位, // mm (3Dのみ)
    "rx": X軸回り回転角, // ‰rad (3D)
    "ry": Y軸回り回転角, // ‰rad (3D)
    "rz": Z軸回り回転角 // ‰rad
  }
}
```

### 支点反力
```json
"reac": {
  "節点ID": {
    "tx": X方向反力, // kN
    "ty": Y方向反力, // kN
    "tz": Z方向反力, // kN (3Dのみ)
    "mx": X軸回り反力モーメント, // kNm (3D)
    "my": Y軸回り反力モーメント, // kNm (3D)
    "mz": Z軸回り反力モーメント // kNm
  }
}
```

### 部材断面力（梁要素）
```json
"fsec": {
  "部材ID": {
    "断面ID": {
      "fxi": 軸方向力, // kN
      "fyi": Y軸方向せん断力, // kN
      "fzi": Z軸方向せん断力, // kN (3D)
      "mxi": ねじりモーメント, // kNm (3D)
      "myi": Y軸回り曲げモーメント, // kNm (3D)
      "mzi": Z軸回り曲げモーメント // kNm
    }
  }
}
```

### シェル要素応力・ひずみ
```json
"shell_stress": {
  "シェルID": {
    "節点ID": {
      "sx": σx応力, // kN/m²
      "sy": σy応力, // kN/m²
      "txy": τxy応力 // kN/m²
    }
  }
}
```

### ソリッド要素応力・ひずみ
```json
"solid_stress": {
  "ソリッドID": {
    "節点ID": {
      "sx": σx応力, // kN/m²
      "sy": σy応力, // kN/m²
      "sz": σz応力, // kN/m²
      "txy": τxy応力, // kN/m²
      "tyz": τyz応力, // kN/m²
      "tzx": τzx応力 // kN/m²
    }
  }
}
```
