# 3. 要素

## 3.1. 梁要素

### 3.1.1. 要素座標系

梁要素の X_l 軸は i 端から j 端に向かう方向になります。梁要素の要素座標系の Y_l 軸の方向はコードアングルによって定義されます。

### 3.1.2. 剛性マトリクス

梁要素の剛性マトリクスは 12x12 の対称マトリクスで、以下の成分を持ちます。

**基本剛性マトリクス（両端固定）**

主な対角成分：
- 軸方向剛性: EA/L
- せん断剛性（Y方向）: 12EI_z / [L^3(1 + phi_y)]
- せん断剛性（Z方向）: 12EI_y / [L^3(1 + phi_z)]
- ねじり剛性: GJ/L
- 曲げ剛性（Y軸回り）: (4 + phi_z)EI_y / [L(1 + phi_z)]
- 曲げ剛性（Z軸回り）: (4 + phi_y)EI_z / [L(1 + phi_y)]

ここで、せん断変形係数：
- phi_y = 12EI_z / (GA_y L^2)
- phi_z = 12EI_y / (GA_z L^2)

**記号の定義：**
| 記号 | 説明 |
|------|------|
| E | ヤング率 |
| G | せん断弾性係数 |
| A | 断面積 |
| A_y, A_z | 有効せん断断面積 |
| I_y, I_z | 断面2次モーメント |
| J | 断面2次極モーメント |
| L | 要素長 |

**材端ピン条件がある場合**

材端ピン条件により、剛性マトリクスは以下のように変化します：

1. **XY平面 i端ピン**: せん断剛性係数が 12 から 3 に変化
2. **XY平面 j端ピン**: 同様にせん断剛性係数が変化
3. **XZ平面 i端ピン**: Z方向のせん断成分が変化
4. **XZ平面 j端ピン**: 同様の変化
5. **XY平面両端ピン**: XY平面の曲げ成分が 0 に
6. **XZ平面両端ピン**: XZ平面の曲げ成分が 0 に
7. **ねじりピン（片端も同じ）**: ねじり剛性成分が 0 に

**初期軸力がある場合**

部材座標系の剛性マトリクスに幾何剛性マトリクス K_G が付加されます。

K_G = (f/L) * [幾何剛性マトリクス]

主な成分：
- せん断方向: 6/5
- 曲げ-せん断連成: L/10
- 曲げ: 2L^2/15, 4L^2/30

ここで、f は初期軸力です。

幾何学的非線形を考慮する場合、解析ステップごとに部材長 L も更新します。

### 3.1.3. 質量マトリクス

**集中質量**

質量マトリクス M = rho * A * L * [対角マトリクス]

対角成分：
- 並進方向（i端, j端）: 1/2
- 回転方向: 0

ここで、rho は質量密度です。

**整合質量**

質量マトリクス M = (rho * A * L / 420) * [整合質量マトリクス]

主な成分：
- 並進（i端対角）: 140, 156, 156
- 並進（j端対角）: 140, 156, 156
- 回転（対角）: 140(rho*J)/(rho*A), 4L^2
- 連成成分: 54, 70, 13L, 22L, -3L^2 など

**両端ピンの場合**

質量マトリクス M = (rho * A * L / 420) * [簡略化マトリクス]

対角成分: 140（並進方向のみ）、回転成分は 0

**初期軸力がある場合（両端ピン）**

幾何剛性マトリクス K_G = (f/L) * [簡略化幾何剛性マトリクス]

対角成分: 0, 1, 1, 0, 0, 0（せん断方向のみ非ゼロ）

---

## 3.2. トラス要素

### 3.2.1. 要素座標系

トラス要素の X_l 軸は i 端から j 端に向かう方向になります。

### 3.2.2. 剛性マトリクス

トラス要素の剛性マトリクスは以下のようになります。

K = (EA/L) * [剛性マトリクス]

12x12 マトリクスで、軸方向成分のみ非ゼロ：
- K(1,1) = 1, K(1,7) = -1
- K(7,1) = -1, K(7,7) = 1
- その他の成分は全て 0

**記号の定義：**
| 記号 | 説明 |
|------|------|
| E | ヤング率 |
| A | 断面積 |
| L | 要素長 |

### 3.2.3. 質量マトリクス

**集中質量**

質量マトリクス M = rho * A * L * [対角マトリクス]

対角成分：
- 並進方向（i端, j端）: 1/2
- 回転方向: 0

**整合質量**

質量マトリクス M = (rho * A * L / 420) * [整合質量マトリクス]

対角成分：
- i端: 140, 140, 140, 0, 0, 0
- j端: 140, 140, 140, 0, 0, 0

連成成分：
- 並進連成: 70

---

## 3.3. ばね要素

### 3.3.1. 要素座標系

ばね要素の X_l 軸は i 端から j 端に向かう方向になります。ばね要素の要素座標系の Y_l 軸の方向はコードアングルによって定義されます。

### 3.3.2. 剛性マトリクス

ばね要素の剛性マトリクスは以下のようになります。

K = [12x12 対称マトリクス]

マトリクス構造（対称）：

```
     | i端                          | j端                          |
     | x    y    z   Rx   Ry   Rz  | x    y    z   Rx   Ry   Rz  |
-----|------------------------------|------------------------------|
i-x  | k_x                          | -k_x                         |
i-y  | 0   k_y                      | 0   -k_y                     |
i-z  | 0   0   k_z                  | 0   0   -k_z                 |
i-Rx | 0   0   0   k_Rx             | 0   0   0   -k_Rx            |
i-Ry | 0   0   0   0   k_Ry         | 0   0   0   0   -k_Ry        |
i-Rz | 0   0   0   0   0   k_Rz     | 0   0   0   0   0   -k_Rz    |
-----|------------------------------|------------------------------|
j-x  |                              | k_x                          |
j-y  |                              | 0   k_y                      |
j-z  |                              | 0   0   k_z                  |
j-Rx |                              | 0   0   0   k_Rx             |
j-Ry |                              | 0   0   0   0   k_Ry         |
j-Rz |                              | 0   0   0   0   0   k_Rz     |
```

**記号の定義：**
| 記号 | 説明 |
|------|------|
| k_x | X_l 方向のばね係数 |
| k_y | Y_l 方向のばね係数 |
| k_z | Z_l 方向のばね係数 |
| k_Rx | X_l 軸回りのばね係数 |
| k_Ry | Y_l 軸回りのばね係数 |
| k_Rz | Z_l 軸回りのばね係数 |

---

## 3.4. SR ばね要素

### 3.4.1. 要素座標系

SR ばね要素の X_l 軸は i 端から j 端に向かう方向になります。SR ばね要素の要素座標系の Y_l 軸の方向はコードアングルによって定義されます。

### 3.4.2. 剛性マトリクス

SR ばね要素の剛性マトリクスは以下のようになります。通常のばね要素と異なり、並進-回転の連成項を持ちます。

K = [12x12 対称マトリクス]

i端ブロック（6x6、対称）：

```
     | x        y        z        Rx       Ry       Rz      |
-----|-------------------------------------------------------|
x    | k_x                                                   |
y    | 0        k_y                                          |
z    | 0        0        k_z                                 |
Rx   | 0        k_y-Rx   k_z-Rx   k_Rx                       |
Ry   | k_x-Ry   0        k_z-Ry   0        k_Ry              |
Rz   | k_x-Rz   k_y-Rz   0        0        0        k_Rz     |
```

j端ブロックは i端ブロックと同様の構造で、連成項は符号が反転します。

**記号の定義：**
| 記号 | 説明 |
|------|------|
| k_x | X_l 方向のばね係数 |
| k_y | Y_l 方向のばね係数 |
| k_z | Z_l 方向のばね係数 |
| k_Rx | X_l 軸回りのばね係数 |
| k_Ry | Y_l 軸回りのばね係数 |
| k_Rz | Z_l 軸回りのばね係数 |
| k_x-Ry | X_l 方向と Y_l 軸回りの連成ばね係数 |
| k_x-Rz | X_l 方向と Z_l 軸回りの連成ばね係数 |
| k_y-Rx | Y_l 方向と X_l 軸回りの連成ばね係数 |
| k_y-Rz | Y_l 方向と Z_l 軸回りの連成ばね係数 |
| k_z-Rx | Z_l 方向と X_l 軸回りの連成ばね係数 |
| k_z-Ry | Z_l 方向と Y_l 軸回りの連成ばね係数 |

---

## 3.5. ダンパー要素

### 3.5.1. 要素座標系

ダンパー要素の X_l 軸は i 端から j 端に向かう方向になります。ダンパー要素の要素座標系の Y_l 軸の方向はコードアングルによって定義されます。

### 3.5.2. 減衰マトリクス

ダンパー要素の減衰マトリクスは以下のようになります。

C = [12x12 対称マトリクス]

マトリクス構造（対称）：

```
     | i端                          | j端                          |
     | x    y    z   Rx   Ry   Rz  | x    y    z   Rx   Ry   Rz  |
-----|------------------------------|------------------------------|
i-x  | c_x                          | -c_x                         |
i-y  | 0   c_y                      | 0   -c_y                     |
i-z  | 0   0   c_z                  | 0   0   -c_z                 |
i-Rx | 0   0   0   c_Rx             | 0   0   0   -c_Rx            |
i-Ry | 0   0   0   0   c_Ry         | 0   0   0   0   -c_Ry        |
i-Rz | 0   0   0   0   0   c_Rz     | 0   0   0   0   0   -c_Rz    |
-----|------------------------------|------------------------------|
j-x  |                              | c_x                          |
j-y  |                              | 0   c_y                      |
j-z  |                              | 0   0   c_z                  |
j-Rx |                              | 0   0   0   c_Rx             |
j-Ry |                              | 0   0   0   0   c_Ry         |
j-Rz |                              | 0   0   0   0   0   c_Rz     |
```

**記号の定義：**
| 記号 | 説明 |
|------|------|
| c_x | X_l 方向の減衰係数 |
| c_y | Y_l 方向の減衰係数 |
| c_z | Z_l 方向の減衰係数 |
| c_Rx | X_l 軸回りの減衰係数 |
| c_Ry | Y_l 軸回りの減衰係数 |
| c_Rz | Z_l 軸回りの減衰係数 |
