# 6. 幾何学的非線形性

微小変位の仮定の下では局所座標系は常に一定ですが、大変形時には節点の変位に伴う要素の長さや方向の変化が無視できません。このような幾何学的非線形性を考慮する場合、局所座標系を各ステップで更新する必要があります。

初期の局所座標系を $x_0$、$y_0$、$z_0$ とします。初期の局所座標系での相対変位量を $u_{jx}$、$u_{jy}$、$u_{jz}$ とします。この相対変位量を用いて初期の局所座標系から現在の局所座標系への回転角度 $\alpha$、$\beta$ を求めます。

$y$ 軸回りに $\alpha$ 回転させるマトリクスを $R_\alpha$、$z$ 軸回りに $\beta$ 回転させるマトリクスを $R_\beta$ とすると、以下の式で表されます。

$$
R_\alpha = \begin{bmatrix}
\cos\alpha & 0 & \sin\alpha \\
0 & 1 & 0 \\
-\sin\alpha & 0 & \cos\alpha
\end{bmatrix} \tag{6.1}
$$

$$
R_\beta = \begin{bmatrix}
\cos\beta & \sin\beta & 0 \\
-\sin\beta & \cos\beta & 0 \\
0 & 0 & 1
\end{bmatrix} \tag{6.2}
$$

よって、初期の局所座標系から現在の局所座標系に変換するマトリクス $R_d$ は次式のようになります。

$$
R_d = R_\beta R_\alpha = \begin{bmatrix}
\cos\alpha\cos\beta & \sin\beta & \sin\alpha\cos\beta \\
-\cos\alpha\sin\beta & \cos\beta & -\sin\alpha\sin\beta \\
-\sin\alpha & 0 & \cos\alpha
\end{bmatrix} \tag{6.3}
$$

実際には部材軸回りにねじれが生じているため、この変換を行った座標系 $x'$、$y'$、$z'$ における $i$, $j$ 端の $x'$ 軸回りの回転角 $\gamma_i$, $\gamma_j$ を求め、両者の平均値 $\gamma = (\gamma_i + \gamma_j)/2$ だけ回転することでねじれの補正を行います。この座標変換マトリクス $R_\gamma$ は次式のようにあらわされます。

$$
R_\gamma = \begin{bmatrix}
1 & 0 & 0 \\
0 & \cos\gamma & \sin\gamma \\
0 & -\sin\gamma & \cos\gamma
\end{bmatrix} \tag{6.4}
$$

よって、全体座標系から初期の局所座標系への座標変換マトリクスを $R$ とすると、最終的に全体座標系から現在の局所座標系への座標変換マトリクス $R_m$ は次式のようにあらわされます。

$$
R_m = R_\gamma R_d R \tag{6.5}
$$
