# 1. 座標系

## 1.1. 全体座標系

isas で用いる全体座標系は右手座標系としています。各節点は𝑥, 𝑦, 𝑧の並進3 方向および𝜃𝑥, 𝜃𝑦, 𝜃𝑧の回転３方向の合計6 自由度を持っています。

全体座標系は図に示すようになります。

![](./img/1.1.png)

## 1.2. 要素座標系

各要素には全体座標系とは独立して要素座標系が定義されます。１節点から成る要素の場合、要素座標系は全体座標系と一致します。

梁要素などの2 節点から成る要素の場合は、要素座標系は𝑖端から𝑗端に向かう方向を X𝑙軸、後述するコードアングルによりY𝑙軸およびZ𝑙軸が定まります。コードアングルは軸方向にねじれている部材について使用します。

```
𝑖端
X
Y
Z
X𝑙
Y𝑙
Z𝑙
```

また、2 節点が同一の座標値（2 重節点）の場合、要素座標系は全体座標系と一致します。

コードアングルを考慮しない場合の標準的な梁の要素座標系は以下のようになります。方向や符号は断面力図に影響します。

```
𝑗端
𝑖端
X
Y
Z
X𝑙
Y𝑙
Z𝑙

𝑖端
X
Y
Z
X𝑙
Y𝑙
Z𝑙
𝑗端(𝑖端と一致)
```

## 1.3. コードアングル

梁要素などの２つの節点から成る要素は𝑖端と𝑗端から軸方向が決まりますが、軸回りの回転については決定できません。そのため、コードアングル^1)を導入して全体座標系における軸回りの回転角を定義します。コードアングルの定義の方法は以下のようになります。

### (1) 要素のX𝑙軸が全体座標系のZ 軸と平行でない場合

まず、要素のX𝑙軸に垂直な平面𝑝を考えます。次にこの平面𝑝上でXY平面に平行な𝑦′軸を考えます。その後、要素X𝑙軸と𝑦′軸で右手系の関係をなす𝑧′軸を考えます。𝑦′軸の正の方向は𝑧′軸の正の方向が全体座標系のZ 方向が増加するように定義します。平面𝑝上で𝑦′軸からY𝑙軸へ図った角度𝜃をコードアングルとします。コードアングルはX𝑙軸回りに右ねじの方向を正とします。

```
p
Zg
Yg
Xg
Xl
y'
z'
(Zg軸正方向)
Yl
Zl
θ
i端
j端

全体座標系：Xg ，Yg ，Zg
要素座標系：Xl，Yl ，Zl
平面p：i端を含んでXlと直行する面
y' 軸：平面pとXY平面が交差する線上（方向はｚ'に依存）
z' 軸：Zg軸の正側をz' 軸の正方向とする
Yl・Zl軸の方向：平面p内のXl軸回りの角度θで決まる
```

### (2) 要素のX𝑙軸が全体座標系のZ 軸と平行の場合

全体座標系のY 軸から要素座標系のZ𝑙軸へ図った角度𝜃をコードアングルとします。コードアングルは要素座標系のX𝑙軸回りに右ねじの方向を正とします。

```
Yg
Xg
Yl
Zl
θ
```

### 参考文献

1) 信原泰夫，桜井達美，吉村信敏：有限要素法のプログラムデザイン，培風館，1972．
