# 2. 拘束条件

## 2.1. 固定拘束

isas では、固定拘束の拘束条件が導入できます。任意の節点の自由度に対して拘束条件を適用すると、その節点の自由度に関する加速度、速度、変位は全て0 で拘束されるものとします。全体変位ベクトルの第k 行が拘束されているとすると、k 行目の変位ベクトルは0 で既知であるため、運動方程式を構成するマトリクスにおいて、k 行目については考慮する必要がありません。また、全体マトリクスのk 列目と変位ベクトルk 行目の積も常に0 であるため、k 列目に関しても考慮する必要がありません。

そのため、運動方程式では拘束された自由度を縮約したマトリクスを解くことで、縮約した加速度、速度、変位ベクトルを求め、最後に拘束された自由度に零ベクトルを挿入することで、全節点の応答を求めます。

## 2.2. 多点拘束

多点拘束は、各自由度間の絶対変位に以下の線形関係式を与えます。

$$u_0 = a_1 u_1 + a_2 u_2 + \cdots + a_6 u_6 \tag{2.2.1}$$

ここで、$u_0$は従属自由度、$u_1 \sim u_6$は独立自由度、$a_1 \sim a_6$は定数となります。

構造の静的な平衡方程式

$$Ku = F \tag{2.2.2}$$

において、独立自由度の変位$u_m$、従属自由度の変位を$u_s$とし、線形関係を$R$とすると、次の式が成り立ちます。

$$u_s = R u_m \tag{2.2.3}$$

$$u = \begin{bmatrix} u_m \\ u_s \end{bmatrix} = \begin{bmatrix} I \\ R \end{bmatrix} u_m \tag{2.2.4}$$

変位$u_m$に対する等価剛性マトリクスを$K^*$とします。仮想変位$\delta u$を導入し、２つの剛性マトリクスに対する仮想仕事が等しいとすると、次のようになります。

$$\delta u_m^T K^* u_m = \delta u^T K u \tag{2.2.5}$$

$$= \begin{bmatrix} \delta u_m^T & \delta u_s^T \end{bmatrix} K \begin{bmatrix} u_m \\ u_s \end{bmatrix} \tag{2.2.6}$$

$$= \delta u_m^T \begin{bmatrix} I & R^T \end{bmatrix} K \begin{bmatrix} I \\ R \end{bmatrix} u_m \tag{2.2.7}$$

したがって、

$$K^* = \begin{bmatrix} I & R^T \end{bmatrix} K \begin{bmatrix} I \\ R \end{bmatrix} \tag{2.2.8}$$

となります。

同様に、等価質量マトリクス$M^*$、等価荷重ベクトル$F^*$に対しても次の関係式が成り立ちます。

$$M^* = \begin{bmatrix} I & R^T \end{bmatrix} M \begin{bmatrix} I \\ R \end{bmatrix} \tag{2.2.9}$$

$$F^* = \begin{bmatrix} I & R^T \end{bmatrix} F \tag{2.2.10}$$

まとめて表すと、

$$u_s = R u_m \tag{2.2.11}$$

$$u = \begin{bmatrix} u_m \\ u_s \end{bmatrix} = \begin{bmatrix} I \\ R \end{bmatrix} u_m = T u_m \tag{2.2.12}$$

なる線形関係があるときに、$m$に縮合された自由度に対する等価マトリクスはそれぞれ次のように表されます。

$$K^* = T^T K T \tag{2.2.13}$$

$$M^* = T^T M T \tag{2.2.14}$$

$$F^* = T^T F \tag{2.2.15}$$

ただし、

$$T = \begin{bmatrix} I \\ R \end{bmatrix} \tag{2.2.16}$$
