# 5. 減衰

## 5.1. レイリー減衰

レイリー減衰では減衰マトリクス $C$ は質量マトリクス $M$ と剛性マトリクス $K$ に比例し、次式となります。

$$
C = \alpha M + \beta K \tag{5.1.1}
$$

固有ベクトル $\Phi$ を前後から乗じると次式となります。

$$
\Phi^T C \Phi = \alpha \Phi^T M \Phi + \beta \Phi^T K \Phi \tag{5.1.2}
$$

固有ベクトルの直交性と $\Phi$ の $M$ に関する正規化を適用すると次式のようになります。

$$
\Phi^T M \Phi = I \tag{5.1.3}
$$

$$
\Phi^T K \Phi = \begin{bmatrix} \ddots & & \\ & \omega_i^2 & \\ & & \ddots \end{bmatrix} \tag{5.1.4}
$$

$$
\Phi^T C \Phi = \begin{bmatrix} \ddots & & \\ & 2h_i\omega_i & \\ & & \ddots \end{bmatrix} \tag{5.1.5}
$$

よって、$i$ 次の減衰係数 $h_i$ と固有円振動数 $\omega_i$ の関係は次式となります。

$$
2h_i\omega_i = \alpha + \beta\omega_i^2 \tag{5.1.6}
$$

任意の2組の減衰定数と固有円振動数 $h_1, \omega_1, h_2, \omega_2$ を代入し、$\alpha$ と $\beta$ について解くと次式となります。

$$
\begin{Bmatrix} 2h_1\omega_1 \\ 2h_2\omega_2 \end{Bmatrix} = \begin{bmatrix} 1 & \omega_1^2 \\ 1 & \omega_2^2 \end{bmatrix} \begin{Bmatrix} \alpha \\ \beta \end{Bmatrix} \tag{5.1.7}
$$

$$
\alpha = \frac{2\omega_1\omega_2}{\omega_2^2 - \omega_1^2}(h_1\omega_2 - h_2\omega_1) \tag{5.1.8}
$$

$$
\beta = \frac{2}{\omega_2^2 - \omega_1^2}(h_2\omega_2 - h_1\omega_1) \tag{5.1.9}
$$

以上のように求められた $\alpha$ と $\beta$ を用いて減衰マトリクス $C$ を決定します。

レイリー減衰では非線形解析において、剛性マトリクス $K$ が更新された場合、減衰マトリクスは更新されません。

## 5.2. 要素別剛性比例減衰

要素別剛性比例減衰では、要素ごとの減衰が要素ごとの剛性に比例するものとし、その集計が全体減衰マトリクス $C$ になると仮定し以下の式で表されます。

$$
C = \sum_{i=1}^{N} \frac{2h_i}{\omega_1} K_i \tag{5.2.1}
$$

ここで、

- $N$ : 全要素数
- $h_i$ : 要素 $i$ の減衰定数
- $\omega_1$ : 1次の固有円振動数 (rad/sec)
- $K_i$ : 要素 $i$ の要素剛性マトリクス

1次の固有円振動数を与えることにより、要素ごとの剛性に対する比例係数を求め、減衰マトリクスを決定します。

要素別剛性比例減衰では、非線形解析において、剛性マトリクスが更新された場合、減衰マトリクスは更新されません。

## 5.3. 要素別レイリー減衰

要素別レイリー減衰では、要素ごとの減衰が要素ごとの質量と剛性に比例するものとし、その集計が全体減衰マトリクス $C$ になると仮定し以下の式で表されます。

$$
C = \sum_{i=1}^{N} (\alpha_i M_i + \beta_i K_i) \tag{5.3.1}
$$

ここで、

- $N$ : 全要素数
- $M_i$ : 要素 $i$ の要素質量マトリクス
- $K_i$ : 要素 $i$ の要素剛性マトリクス
- $\alpha_i$ : 要素 $i$ の質量に対する比例係数
- $\beta_i$ : 要素 $i$ の剛性に対する比例係数

比例定数 $\alpha$, $\beta$ は要素ごとに指定します。

要素別レイリー減衰では、非線形解析において、剛性マトリクスが更新された場合、減衰マトリクスは更新されません。
