# 8. 作用荷重

## 8.1. 静的荷重

isas では節点荷重，要素荷重，自重・慣性力，温度荷重の4種類の静的荷重を考慮できます．
静的荷重は全て初期荷重としても増分荷重としても使用できます．

静的荷重 $F_{static}$ は以下の式で計算されます．

$$F_{static} = F_{node} + F_{element} + F_{inertia} + F_{temperature}$$
(8.1.1)

ここで，
- $F_{node}$：節点荷重
- $F_{element}$：要素荷重
- $F_{inertia}$：自重・慣性力
- $F_{temperature}$：温度荷重

です．

### 8.1.1. 節点荷重

節点荷重は節点に作用する集中荷重として設定し，以下の式で計算されます．

$$F_{node} = \sum_{i=1}^{n} F_i$$
(8.1.2)

ただし，$F_i$：節点 $i$ に作用する集中荷重

### 8.1.2. 要素荷重

要素荷重<sup>1) 2)</sup>は要素内に作用する荷重です．要素集中荷重および要素分布荷重として設定された荷重を等価節点力に変換して作用させます．要素荷重は梁要素とトラス要素に作用させることが可能です．

梁要素の軸方向の形状関数は以下のように定義されます．

$$H(x) = \begin{Bmatrix} 1 - \frac{x}{L} \\ \frac{x}{L} \end{Bmatrix}$$
(8.1.3)

軸方向に分布荷重 $p(x)$ が作用しているときの等価節点力 $F_{element}$ は以下のように表されます．

$$F_{element} = \int_0^L p(x) H(x) dx$$
(8.1.4)

梁要素のXY平面内のせん断と曲げの形状関数は以下のように定義されます．

$$H(x) = \begin{Bmatrix} 1 - \frac{3x^2}{L^2} + \frac{2x^3}{L^3} \\ x - \frac{2x^2}{L} + \frac{x^3}{L^2} \\ \frac{3x^2}{L^2} - \frac{2x^3}{L^3} \\ -\frac{x^2}{L} + \frac{x^3}{L^2} \end{Bmatrix}$$
(8.1.5)

梁要素のせん断方向に分布荷重 $p(x)$ が作用しているときの等価節点力 $F_{element}$ は以下のように表されます．

$$F_{element} = \int_0^L p(x) H(x) dx$$
(8.1.6)

要素に作用している任意の荷重 $q(x)$ の等価節点力 $F_{element}$ は形状関数を用いて以下の式で表されます．

$$F_{element} = \int_0^L q(x) H(x) dx$$
(8.1.7)

**参考文献**

1. J. N. Reddy: An Introduction To The Finite Element Method Third Edition, Mcgraw-Hill Education, 2005.
2. Young W. Kwon, Hyochoong Bang: The Finite Element method Using MATLAB Second Edition, CRC Press, 2000.

### 8.1.3. 自重・慣性力

自重・慣性力は構造物に作用する加速度を設定し，以下の式で求められる慣性力として作用させます．

$$F_{inertia} = M(I_x \ddot{u}_x + I_y \ddot{u}_y + I_z \ddot{u}_z)$$
(8.1.8)

ただし，
- $\ddot{u}_x$：$x$ 方向作用加速度
- $\ddot{u}_y$：$y$ 方向作用加速度
- $\ddot{u}_z$：$z$ 方向作用加速度
- $I_x$：並進 $x$ 方向の自由度を1，それ以外の自由度を0としたベクトル
- $I_y$：並進 $y$ 方向の自由度を1，それ以外の自由度を0としたベクトル
- $I_z$：並進 $z$ 方向の自由度を1，それ以外の自由度を0としたベクトル

### 8.1.4. 温度荷重

温度荷重は要素内に作用する荷重です．温度荷重として設定された荷重を等価節点力に変換して作用させます．温度荷重は梁要素とトラス要素に作用させることが可能です．

温度荷重の軸力，曲げモーメントの等価節点力はそれぞれ以下の式で計算します．

**軸力**

$$\begin{Bmatrix} F_{xi} \\ F_{xj} \end{Bmatrix} = \begin{Bmatrix} -\alpha(t_1 + t_2 + t_3 + t_4)/2 \cdot EA \\ \alpha(t_1 + t_2 + t_3 + t_4)/2 \cdot EA \end{Bmatrix}$$
(8.1.9)

**曲げモーメント**

$$\begin{Bmatrix} M_{yi} \\ M_{zi} \\ M_{yj} \\ M_{zj} \end{Bmatrix} = \begin{Bmatrix} -\alpha(t_3 - t_4)/H_z \cdot EI_y \\ \alpha(t_1 - t_2)/H_y \cdot EI_z \\ \alpha(t_3 - t_4)/H_z \cdot EI_y \\ -\alpha(t_1 - t_2)/H_y \cdot EI_z \end{Bmatrix}$$
(8.1.10)

ここで，
- $\alpha$：線膨張係数
- $E$：ヤング係数
- $A$：断面積
- $I_y, I_z$：断面2次モーメント
- $h_y, h_z$：断面高さ
- $t_1, t_3$：上面温度変化量
- $t_2, t_4$：下面温度変化量

## 8.2. 動的荷重

### 8.2.1. 単一加速度入力

単一加速度入力時は，全支点が一様の変位を受けているとします．絶対変位 $u^t$ を強制変位と相対変位に分けると以下の式で表すことができます．

$$u^t = \begin{bmatrix} u_a^t \\ u_b^t \end{bmatrix} = \begin{bmatrix} u_a^k \\ u_b^k \end{bmatrix} + \begin{bmatrix} u_a \\ 0 \end{bmatrix}$$
(8.2.1)

ここで，
- 第1項：強制変位
- 第2項：相対変位
- $a$：内部自由度
- $b$：加振自由度

です．

絶対変位系での運動方程式は以下のようになります．

$$M\ddot{u}^t + C\dot{u}^t + Ku^t = 0$$
(8.2.2)

内部自由度と加振自由度に分けると以下のようになります．

$$\begin{bmatrix} M_{aa} & M_{ab} \\ M_{ba} & M_{bb} \end{bmatrix} \begin{Bmatrix} \ddot{u}_a^t \\ \ddot{u}_b^t \end{Bmatrix} + \begin{bmatrix} C_{aa} & C_{ab} \\ C_{ba} & C_{bb} \end{bmatrix} \begin{Bmatrix} \dot{u}_a^t \\ \dot{u}_b^t \end{Bmatrix} + \begin{bmatrix} K_{aa} & K_{ab} \\ K_{ba} & K_{bb} \end{bmatrix} \begin{Bmatrix} u_a^t \\ u_b^t \end{Bmatrix} = \begin{Bmatrix} 0 \\ 0 \end{Bmatrix}$$
(8.2.3)

第1行を整理すると以下のようになります．

$$M_{aa}\ddot{u}_a^t + C_{aa}\dot{u}_a^t + K_{aa}u_a^t = -(M_{ab}\ddot{u}_b^t + C_{ab}\dot{u}_b^t + K_{ab}u_b^t)$$
(8.2.4)

さらに，

$$M_{aa}\ddot{u}_a + C_{aa}\dot{u}_a + K_{aa}u_a = -(M_{aa}\ddot{u}_a^k + M_{ab}\ddot{u}_b^t + C_{aa}\dot{u}_b^k + C_{ab}\dot{u}_b^t + K_{aa}u_b^k + K_{ab}u_b^t)$$
(8.2.5)

剛体変位であるため，強制変位は以下のように表されます．

$$\begin{bmatrix} u_a^k \\ u_b^k \end{bmatrix} = \begin{bmatrix} I_a \\ I_b \end{bmatrix} u_e$$
(8.2.6)

ただし，$I_a$, $I_b$：すべての要素が1の列ベクトル

剛体変形であることから，以下の式が成り立ちます．

$$K_{aa}u_a^k + K_{ab}u_b^k = 0$$
(8.2.7)

さらに，慣性項に比較して減衰項が十分小さいことを考えてこれを無視すると以下運動方程式が導かれます．

$$M_{aa}\ddot{u}_a + C_{aa}\dot{u}_a + K_{aa}u_a = -M_{aa}I_a\ddot{u}_e - M_{ab}I_b\ddot{u}_e$$
(8.2.8)

動的解析の出力では，加速度は絶対加速度，速度は相対速度，変位は相対変位として出力されます．

### 8.2.2. 多点加速度入力

多点加速度入力<sup>1)</sup>時は，各支点が異なる変位を受けているとします．

構造物の絶対変位 $X_1$ は境界部に生じる絶対変位 $X_2$ によって生じる構造物の絶対変位 $X_0$ とこの変位に対する相対変位 $Y$ を用いて以下の式で表すことができます。

$$X_1 = X_0 + Y$$
(8.2.9)

構造物に対する外力 $P_1$ と変位 $u_1$、境界に生じる反力 $P_2$ と変位 $u_2$ の関係は、

$$\begin{Bmatrix} P_1 \\ P_2 \end{Bmatrix} = \begin{bmatrix} K_{11} & K_{12} \\ K_{21} & K_{22} \end{bmatrix} \begin{Bmatrix} u_1 \\ u_2 \end{Bmatrix}$$
(8.2.10)

と表されます。

ここで、
- $K_{11}$：構造物の剛性と構造物と境界間の剛性の和
- $K_{12} = K_{21}$：構造物との境界間の剛性の和
- $K_{22}$：境界より外側の剛性

となります。

構造物に作用する外力 $P_1 = 0$、$u_2 = X_2$ とすると、境界変位 $X_2$ における構造物に生じる変位 $u_1 = X_0$ は第1行から以下の式で求められます。

$$X_0 = -K_{11}^{-1}K_{12}X_2 = SX_2$$
(8.2.11)

また、運動方程式は、次式のようになります。

$$\begin{Bmatrix} M_1\ddot{X}_1 \\ P_2 \end{Bmatrix} + \begin{bmatrix} C_{11} & C_{12} \\ C_{21} & C_{22} \end{bmatrix} \begin{Bmatrix} \dot{X}_1 \\ \dot{X}_2 \end{Bmatrix} + \begin{bmatrix} K_{11} & K_{12} \\ K_{21} & K_{22} \end{bmatrix} \begin{Bmatrix} X_1 \\ X_2 \end{Bmatrix} = \begin{Bmatrix} 0 \\ 0 \end{Bmatrix}$$
(8.2.12)

ここで、
- $C_{11}$：構造物の減衰と構造物と境界間の減衰の和
- $C_{12} = C_{21}$：構造物と境界間の減衰
- $C_{22}$：境界より外側の減衰

1行目より、構造物のつり合い式は

$$M\ddot{X}_1 + C_{11}\dot{X}_1 + K_{11}X_1 = -C_{12}\dot{X}_2 - K_{12}X_2$$
(8.2.13)

式(8.2.9)の $X_0$ を式(8.2.11)に代入し、その結果を式(8.2.13)に代入すると

$$M_1\ddot{Y} + C_{11}\dot{Y} + K_{11}Y = -M_1S\ddot{X}_2 - C_{11}S\dot{X}_2 - C_{12}\dot{X}_2$$
(8.2.14)

ここで、減衰が剛性に比例すると仮定すると、

$$C_{11}S\dot{X}_2 = -C_{11}K_{11}^{-1}K_{12}\dot{X}_2 = -C_{11}C_{11}^{-1}\dot{X}_2 = -C_{12}\dot{X}_2$$
(8.2.15)

この式を式(8.2.14)に代入すると、加速度を入力としたつり合い式が得られます。

$$M_1\ddot{Y} + C_{11}\dot{Y} + K_{11}Y = -M_1S\ddot{X}_2$$
(8.2.16)

**参考文献**

1. 山本泰幹，藤野陽三，矢部正明：地震観測された長大吊構造系橋梁の道徳性と動的解析モデルによる再現性，土木学会論文集A，Vol.65 No3，pp.738-757，2009.
