# 9. 解析機能

## 9.1. 固有値解析

サブスペース法により固有値解析を行います。サブスペース法は、大規模な固有値問題を部分空間の固有値問題に帰着させて解く方法です。

まず、初期反復ベクトルを設定します。

$$X_1 = \{x_1, x_2, \ldots, x_m\}$$
(9.1.1)

ここで、
- $X$：反復ベクトル
- $m$：求めたい固有値の次数

反復ベクトルに $M$ を乗じます。

$$Z = MX_k$$
(9.1.2)

部分空間への射影マトリクス $Y_{k+1}$ を求めます。

$$KY_{k+1} = Z$$
(9.1.3)

$$Y_{k+1} = K^{-1}MX_k$$
(9.1.4)

剛性マトリクス $K$ と質量マトリクス $M$ を部分空間へ射影すると

$$\tilde{K}_{k+1} = Y_{k+1}^T K Y_{k+1}$$
(9.1.5)

$$\tilde{M}_{k+1} = Y_{k+1}^T M Y_{k+1}$$
(9.1.6)

ここで、
- $\tilde{K}$：剛性マトリクスの射影マトリクス
- $\tilde{M}$：質量マトリクスの射影マトリクス

部分空間の固有値問題は次式のようになります。

$$\tilde{K}_{k+1} = \lambda_{k+1} \tilde{M}_{k+1} \Phi_{k+1}$$
(9.1.7)

ここで、$\Phi = \{\phi_1, \phi_2, \ldots, \phi_n\}$：部分空間の固有ベクトル

部分空間の固有ベクトルを元の空間へ変換します。

$$X_{k+1} = Y_{k+1} \Phi_{k+1}$$
(9.1.8)

収束判定を行い、収束していなければ反復ベクトルに再度 $M$ を乗じ収束計算を行います。
収束判定は次式となります。

$$\frac{|\lambda_i^{(k+1)} - \lambda_i^{(k)}|}{\lambda_i^{(k+1)}} \leq \varepsilon$$
(9.1.9)

ここで、$\varepsilon$：許容値

収束していれば、固有値 $\lambda$、固有ベクトル $X$ が求められます。

## 9.2. 静的解析

### 9.2.1. 荷重制御

荷重制御は入力された荷重の分布形状と荷重倍率から増分荷重を求め、それに対する増分変位を計算する方法です。

静的解析の方程式を増分形式で表すと次式のようになります．

$$K \cdot \Delta U = \Delta R + R_{unb}$$
(9.2.1)

ここで，
- $K$：剛性マトリクス
- $\Delta U$：増分変位ベクトル
- $\Delta R$：増分荷重ベクトル
- $R_{unb}$：不平衡力ベクトル

荷重制御では，荷重増分ベクトルは，次式で求めます．

$$\Delta R = \sum_{k=1}^{n} (\Delta \lambda \cdot R_{ref,k})$$
(9.2.2)

ここで、
- $\Delta R$：増分荷重ベクトル
- $\Delta \lambda$：増分荷重倍率
- $R_{ref,k}$：荷重ケース $k$ の基準荷重分布形状
- $n$：荷重ケース数

$R_{ref}$ は入力データで定義される荷重分布です．$\Delta \lambda$ はステップごとの $R_{ref}$ に対する荷重倍率です．各ステップの増分荷重には複数の荷重ケースを設定することができます．

非線形解析では，不平衡力は次のステップに持ち越されます．反復計算は行われないため，荷重の分割数を増やす必要があります．

荷重増分法は，増分荷重に対応する増分変位を求める方法であるため，構造系全体の剛性が負になるなど，ある荷重に対応する解が複数存在する場合には適用できません．このような場合は変位制御を使用してください．

### 9.2.2. 変位制御

変位制御は基準荷重分布形状と1自由度分の節点変位ベクトルから増分荷重倍率、増分荷重を求め、それに対する増分変位を計算していく方法です。変位制御でも荷重制御と同様に複数の荷重ケースを扱うことができます．

拘束する節点増分変位ベクトルを $\Delta u_j$，それ以外の節点増分変位ベクトルを $\Delta u_i$ として，静的解析の方程式を書き直すと次式のようになります．

$$\begin{bmatrix} K_{ii} & K_{ij} \\ K_{ji} & K_{jj} \end{bmatrix} \begin{Bmatrix} \Delta u_i \\ \Delta u_j \end{Bmatrix} = \Delta \lambda \cdot \begin{Bmatrix} R_{ref,i} \\ R_{ref,j} \end{Bmatrix} + \begin{Bmatrix} R_{unb,i} \\ R_{unb,j} \end{Bmatrix}$$
(9.2.3)

ここで，
- $K_{ii}, K_{ij}, K_{ji}, K_{jj}$：剛性マトリクス
- $\Delta u_i, \Delta u_j$：増分変位ベクトル
- $\Delta \lambda$：増分荷重倍率
- $R_{ref,i}, R_{ref,j}$：基準荷重分布形状
- $R_{unb,i}, R_{unb,j}$：不平衡力ベクトル

$\lambda$ を未知数として書き換えると次式のようになります．

$$\begin{bmatrix} K_{ii} & -R_{ref,i} \\ K_{ji} & -R_{ref,j} \end{bmatrix} \begin{Bmatrix} \Delta u_i \\ \Delta \lambda \end{Bmatrix} = \begin{Bmatrix} R_{unb,i} \\ R_{unb,j} \end{Bmatrix} - \Delta u_j \begin{Bmatrix} K_{ij} \\ K_{jj} \end{Bmatrix}$$
(9.2.4)

式を展開すると次式のようになります．

$$K_{ii} \cdot \Delta u_i = \Delta \lambda \cdot R_{ref,i} + R_{unb,i} - \Delta u_j \cdot K_{ij}$$
(9.2.5)

$$K_{ji} \cdot \Delta u_i = \Delta \lambda \cdot R_{ref,j} + R_{unb,i} - \Delta u_j \cdot K_{jj}$$
(9.2.6)

この式から3つの式を抽出します．

$$K_{ii} \cdot \Delta u_{i,1} = R_{ref,i}$$
(9.2.7)

$$K_{ii} \cdot \Delta u_{i,2} = -\Delta u_j \cdot K_{ij}$$
(9.2.8)

$$K_{ii} \cdot \Delta u_{i,3} = R_{unb,i}$$
(9.2.9)

3つの式から $\Delta u_{i,1}$，$\Delta u_{i,2}$，$\Delta u_{i,3}$ を求め，$\Delta u_i$ をその和で表せば次式のようになります．

$$\Delta u_i = \Delta \lambda \cdot \Delta u_{i,1} + \Delta u_{i,2} + \Delta u_{i,3}$$
(9.2.10)

この(4)式を代入すれば次式のようになります．

$$\Delta \lambda \cdot K_{ji} \cdot \Delta u_{i,1} + K_{ji} \cdot \Delta u_{i,2} = \Delta \lambda \cdot R_{ref,j} + R_{unb,i} - \Delta u_j \cdot K_{jj}$$
(9.2.11)

$$\Delta \lambda \cdot R_{ref,j} - \Delta \lambda \cdot K_{ji} \cdot \Delta u_{i,1} = -R_{unb,j} + K_{ji} \cdot \Delta u_{i,2} - \Delta u_j \cdot K_{jj}$$
(9.2.12)

$$\Delta \lambda = \frac{-R_{unb,j} + K_{ji} \cdot \Delta u_{i,2} + u_j \cdot K_{jj}}{R_{ref,j} - K_{ji} \cdot \Delta u_{i,1}}$$
(9.2.13)

非線形解析では，不平衡力は次の増分ステップに持ち越されます．変位制御は指定した節点の増分変位から対応する増分荷重倍率を求める方法であるため，ある荷重値に対応する解が複数存在するような場合でも適用することができます．

### 9.2.3. 強制変位

強制変位は基準変位分布形状とステップの増分荷重倍率から節点に強制的に増分変位を作用させて，非拘束自由度に対する等価な荷重ベクトルを求め，非拘束自由度の増分変位を計算する方法です．

強制変位を作用させる自由度の増分変位ベクトルを $\Delta u_j$，それ以外の節点増分変位ベクトルを $\Delta u_i$ として，静的解析の方程式を書き直すと次式のようになります．

$$\begin{bmatrix} K_{ii} & K_{ij} \\ K_{ji} & K_{jj} \end{bmatrix} \begin{Bmatrix} \Delta u_i \\ \Delta u_j \end{Bmatrix} = \begin{Bmatrix} 0 \\ R_j \end{Bmatrix} + \begin{Bmatrix} R_{unb,i} \\ R_{unb,j} \end{Bmatrix}$$
(9.2.14)

$$\Delta u_j = \Delta \lambda \cdot D_{ref}$$
(9.2.15)

ここで，
- $K_{ii}, K_{ij}, K_{ji}, K_{jj}$：剛性マトリクス
- $\Delta u_i, \Delta u_j$：増分変位ベクトル
- $\Delta \lambda$：増分荷重倍率
- $D_{ref}$：基準荷重分布形状
- $R_{unb,i}, R_{unb,j}$：不平衡力ベクトル

$\lambda$ を未知数として書き換えると次式のようになります．

$$\begin{bmatrix} K_{ii} & -R_{ref,i} \\ K_{ji} & -R_{ref,j} \end{bmatrix} \begin{Bmatrix} \Delta u_i \\ \Delta \lambda \end{Bmatrix} = \begin{Bmatrix} R_{unb,i} \\ R_{unb,j} \end{Bmatrix} - \Delta u_j \begin{Bmatrix} K_{ij} \\ K_{jj} \end{Bmatrix}$$
(9.2.16)

第一式を展開すると次式のようになります．

$$K_{ii} \cdot \Delta u_i + K_{ij} \cdot \Delta u_i = R_{unb,i}$$
(9.2.17)

この式をまとめると，次式となります．

$$K_{ii} \cdot \Delta u_i = \Delta R_i$$
(9.2.18)

$$\Delta R_i = R_{unb,i} - K_{ij} \cdot \Delta u_j$$
(9.2.19)

(9.2.15)式から強制変位を作用させる自由度に対する増分変位を求め，(9.2.19)式から非拘束自由度に対する等価な荷重ベクトルを求め，(9.2.18)式を解きます．非線形解析では，不平衡力は次の増分ステップに持ち越されます．

## 9.3. 動的解析

動的解析には増分系のNewmark-β法を用いています．パラメータ $\beta$，$\delta$ はそれぞれ0.25，0.5としています．

時刻 $t$ における質量マトリクス，減衰マトリクス，剛性マトリクスをそれぞれ $M_t, C_t, K_t$ とし，加速度ベクトルの増分，速度ベクトルの増分，変位ベクトルの増分，外力ベクトルの増分をそれぞれ $d\ddot{U}_t, d\dot{U}_t, dU_t, dF_t$ とすると，運動方程式は以下のようにあらわされます．

$$M_t d\ddot{U}_t + C_t d\dot{U}_t + K_t dU_t = dF_t$$
(9.3.1)

これを時刻0から $t + \Delta t$ まで積分すると，

$$\int_0^{t+\Delta t} M_t d\ddot{U}_t + \int_0^{t+\Delta t} C_t d\dot{U}_t + \int_0^{t+\Delta t} K_t dU_t = \int_0^{t+\Delta t} dF_t$$
(9.3.2)

ここで，

$$E_t = \int_0^t M_t d\ddot{U}_t + \int_0^t C_t d\dot{U}_t + \int_0^t K_t dU_t$$
(9.3.3)

$$F_{t+\Delta t} = \int_0^{t+\Delta t} dF_t$$
(9.3.4)

とおくと，

$$\int_t^{t+\Delta t} M_t d\ddot{U}_t + \int_t^{t+\Delta t} C_t d\dot{U}_t + \int_t^{t+\Delta t} K_t dU_t + E_t = F_{t+\Delta t}$$
(9.3.5)

ここで，

$$\ddot{U}_t = \int_0^t d\ddot{U}_t$$
(9.3.6)

$$\dot{U}_t = \int_0^t d\dot{U}_t$$
(9.3.7)

$$U_t = \int_0^t dU_t$$
(9.3.8)

$$\Delta \ddot{U}_t = \int_t^{t+\Delta t} d\ddot{U}_t$$
(9.3.9)

$$\Delta \dot{U}_t = \int_t^{t+\Delta t} d\dot{U}_t$$
(9.3.10)

$$\Delta U_t = \int_t^{t+\Delta t} dU_t$$
(9.3.11)

とおくと，運動方程式は

$$M_t \Delta \ddot{U}_t + C_t \Delta \dot{U}_t + K_t \Delta U_t + E_t = F_{t+\Delta t}$$
(9.3.12)

となります．

この式を用いて，時刻 $t$ における系の状態をもとに，時刻 $t + \Delta t$ における系の状態を以下の手順で求めます．

### ステップ1

時刻 $t + \Delta t$ の荷重ベクトル $F_{t+\Delta t}$ を計算します．

### ステップ2

時刻 $t + \Delta t$ の荷重ベクトル $F_{t+\Delta t}$ に対する加速度，速度，変位の増分ベクトル $\Delta \ddot{U}_t$，$\Delta \dot{U}_t$，$\Delta U_t$ を求めます．

$$\ddot{U}_{t+\Delta t} = \dot{U}_t + \{(1 - \delta)\ddot{U}_t + \delta \ddot{U}_{t+\Delta t}\}\Delta t$$
(9.3.13)

$$U_{t+\Delta t} = U_t + \dot{U}_t \Delta t + \{(\frac{1}{2} - \beta)\ddot{U}_t + \delta \ddot{U}_{t+\Delta t}\}\Delta t^2$$
(9.3.14)

よって，速度，加速度の増分ベクトルは次式のように表されます．

$$\Delta \dot{U}_t = \{\ddot{U}_t + \delta \Delta \ddot{U}_t\}\Delta t$$
(9.3.15)

$$\Delta \ddot{U}_t = \frac{1}{\beta \Delta t^2}\{\Delta U_t - \dot{U}_t \Delta t - \frac{\Delta t^2}{2}\ddot{U}_t\}$$
(9.3.16)

これを運動方程式に代入し，$\Delta \dot{U}_t$，$\Delta \ddot{U}_t$ を消去すると，

$$(K_t + \frac{1}{\beta \Delta t^2}M + \frac{\delta}{\beta t}C)\Delta U_t = F_{t+\Delta t} - E_t + M(\frac{1}{\beta \Delta t}\ddot{U}_t + \frac{1}{2\beta}\ddot{U}_t) + C\{\frac{\delta}{\beta}\dot{U}_t + (\frac{\delta}{2\beta} - 1)\Delta t \dot{U}_t\}$$
(9.3.17)

この式から $\Delta U_t$ を求め，式に代入することで $\Delta \dot{U}_t$，$\Delta \ddot{U}_t$ を求めます．

### ステップ3

時刻 $t + \Delta t$ の変位，速度，加速度ベクトルを計算します．

$$U_{t+\Delta t} = U_t + \Delta U_t$$
(9.3.18)

$$\dot{U}_{t+\Delta t} = \dot{U}_t + \Delta \dot{U}_t$$
(9.3.19)

$$\ddot{U}_{t+\Delta t} = \ddot{U}_t + \Delta \ddot{U}_t$$
(9.3.20)

### ステップ4

不平衡力ベクトルを次式から求めます．

$$\gamma_{t+\Delta t} = \sum(K_t \Delta U_t - \Delta f_k) + \sum(C_t \Delta \dot{U}_t - \Delta f_c)$$
(9.3.21)

ここで，
- $\Delta f_k$：増分変位 $\Delta U_t$ による要素の部材力増分
- $\Delta f_c$：増分速度 $\Delta \dot{U}_t$ による要素の減衰力増分

負担力ベクトルを次式から求めます．

$$E_{t+\Delta t} = F_{t+\Delta t} - \gamma_{t+\Delta t}$$
(9.3.22)

### ステップ5

新たに剛性マトリクスを作り直します．

### ステップ6

時刻 $t$ を $\Delta t$ だけ進めてステップ1に戻ります．
