import os
from setuptools import setup, find_packages


def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()


setup(
    name="FicusFrameworkAPI",
    version="2.7.1",

    packages=find_packages('src'),
    package_dir={'': 'src'},
    test_suite="test",

    install_requires=[],

    author='sunxiang0918',
    author_email="sunxiang0918@gmail.com",
    description="A framework for Ficus by Python3.",
    long_description=read("README.rst"),
    license="MIT",
    keywords="ficus framework python Api",
    url="https://git.sobey.com/SobeyHive/FicusFramework4Py-Api",
    classifiers=[
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Lesser General Public License v2 or later (LGPLv2+)",
        "Natural Language :: Chinese (Simplified)",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6"
    ],
    zip_safe=False
)
