from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.http_validation_error import HTTPValidationError
from ...models.project_info import ProjectInfo
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    skip: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
    tags: Union[Unset, list[str]] = UNSET,
    external_id: Union[None, Unset, str] = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["skip"] = skip

    params["limit"] = limit

    json_tags: Union[Unset, list[str]] = UNSET
    if not isinstance(tags, Unset):
        json_tags = tags

    params["tags"] = json_tags

    json_external_id: Union[None, Unset, str]
    if isinstance(external_id, Unset):
        json_external_id = UNSET
    else:
        json_external_id = external_id
    params["external_id"] = json_external_id

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/projects",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[HTTPValidationError, list["ProjectInfo"]]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = ProjectInfo.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200

    if response.status_code == 422:
        response_422 = HTTPValidationError.from_dict(response.json())

        return response_422

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[HTTPValidationError, list["ProjectInfo"]]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    skip: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
    tags: Union[Unset, list[str]] = UNSET,
    external_id: Union[None, Unset, str] = UNSET,
) -> Response[Union[HTTPValidationError, list["ProjectInfo"]]]:
    """Get Projects

     Get all projects you have access to.

    You may limit the projects returned by passing in tags to filter on.

    You may limit the projects by passing an external_id or part of an external_id as a query parameter.

    Args:
        skip (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.
        tags (Union[Unset, list[str]]):
        external_id (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[HTTPValidationError, list['ProjectInfo']]]
    """

    kwargs = _get_kwargs(
        skip=skip,
        limit=limit,
        tags=tags,
        external_id=external_id,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
    skip: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
    tags: Union[Unset, list[str]] = UNSET,
    external_id: Union[None, Unset, str] = UNSET,
) -> Optional[Union[HTTPValidationError, list["ProjectInfo"]]]:
    """Get Projects

     Get all projects you have access to.

    You may limit the projects returned by passing in tags to filter on.

    You may limit the projects by passing an external_id or part of an external_id as a query parameter.

    Args:
        skip (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.
        tags (Union[Unset, list[str]]):
        external_id (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[HTTPValidationError, list['ProjectInfo']]
    """

    return sync_detailed(
        client=client,
        skip=skip,
        limit=limit,
        tags=tags,
        external_id=external_id,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    skip: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
    tags: Union[Unset, list[str]] = UNSET,
    external_id: Union[None, Unset, str] = UNSET,
) -> Response[Union[HTTPValidationError, list["ProjectInfo"]]]:
    """Get Projects

     Get all projects you have access to.

    You may limit the projects returned by passing in tags to filter on.

    You may limit the projects by passing an external_id or part of an external_id as a query parameter.

    Args:
        skip (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.
        tags (Union[Unset, list[str]]):
        external_id (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[HTTPValidationError, list['ProjectInfo']]]
    """

    kwargs = _get_kwargs(
        skip=skip,
        limit=limit,
        tags=tags,
        external_id=external_id,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    skip: Union[Unset, int] = 0,
    limit: Union[Unset, int] = 100,
    tags: Union[Unset, list[str]] = UNSET,
    external_id: Union[None, Unset, str] = UNSET,
) -> Optional[Union[HTTPValidationError, list["ProjectInfo"]]]:
    """Get Projects

     Get all projects you have access to.

    You may limit the projects returned by passing in tags to filter on.

    You may limit the projects by passing an external_id or part of an external_id as a query parameter.

    Args:
        skip (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.
        tags (Union[Unset, list[str]]):
        external_id (Union[None, Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[HTTPValidationError, list['ProjectInfo']]
    """

    return (
        await asyncio_detailed(
            client=client,
            skip=skip,
            limit=limit,
            tags=tags,
            external_id=external_id,
        )
    ).parsed
