from __future__ import annotations

from collections.abc import Mapping
from typing import Any, TypeVar, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.piezometer_type import PiezometerType
from ..models.transformation_type import TransformationType
from ..types import UNSET, Unset

T = TypeVar("T", bound="PizeometerUnits")


@_attrs_define
class PizeometerUnits:
    """
    Attributes:
        type_ (PiezometerType | Unset): (
            ELECTRIC = Piezometer Electric,
            HYDRAULIC = Piezometer Hydraulic,
            STANDPIPE = Piezometer Standpipe,
            )
        transformation (TransformationType | Unset): Piezometer Transformation Types
        units (list[None | str] | Unset):
        default_unit (None | str | Unset):
    """

    type_: PiezometerType | Unset = UNSET
    transformation: TransformationType | Unset = UNSET
    units: list[None | str] | Unset = UNSET
    default_unit: None | str | Unset = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        type_: str | Unset = UNSET
        if not isinstance(self.type_, Unset):
            type_ = self.type_.value

        transformation: str | Unset = UNSET
        if not isinstance(self.transformation, Unset):
            transformation = self.transformation.value

        units: list[None | str] | Unset = UNSET
        if not isinstance(self.units, Unset):
            units = []
            for units_item_data in self.units:
                units_item: None | str
                units_item = units_item_data
                units.append(units_item)

        default_unit: None | str | Unset
        if isinstance(self.default_unit, Unset):
            default_unit = UNSET
        else:
            default_unit = self.default_unit

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if type_ is not UNSET:
            field_dict["type"] = type_
        if transformation is not UNSET:
            field_dict["transformation"] = transformation
        if units is not UNSET:
            field_dict["units"] = units
        if default_unit is not UNSET:
            field_dict["default_unit"] = default_unit

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        _type_ = d.pop("type", UNSET)
        type_: PiezometerType | Unset
        if isinstance(_type_, Unset):
            type_ = UNSET
        else:
            type_ = PiezometerType(_type_)

        _transformation = d.pop("transformation", UNSET)
        transformation: TransformationType | Unset
        if isinstance(_transformation, Unset):
            transformation = UNSET
        else:
            transformation = TransformationType(_transformation)

        units = []
        _units = d.pop("units", UNSET)
        for units_item_data in _units or []:

            def _parse_units_item(data: object) -> None | str:
                if data is None:
                    return data
                return cast(None | str, data)

            units_item = _parse_units_item(units_item_data)

            units.append(units_item)

        def _parse_default_unit(data: object) -> None | str | Unset:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(None | str | Unset, data)

        default_unit = _parse_default_unit(d.pop("default_unit", UNSET))

        pizeometer_units = cls(
            type_=type_,
            transformation=transformation,
            units=units,
            default_unit=default_unit,
        )

        pizeometer_units.additional_properties = d
        return pizeometer_units

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
