# Contribute!

Thank you for your interest in improving this project. Your contributions are
appreciated.

This document is a guide to help you through the process of contributing.

## Become a contributor

You can contribute in several ways. Here are some examples:

- Contribute to the codebase.
- Report and triage bugs.
- Write documentation for users and devs.
- Help others by answering questions.

For more ways to contribute, check out the
[Open Source Guides](https://opensource.guide/how-to-contribute).

## Submit changes

If you have a trivial fix or improvement, go ahead and create a pull request.

If you plan something more involved, first raise an issue to discuss.

Should you wish to work on an issue, please claim it first by commenting on it.

When submitting changes, respect the following guidelines:

- Branch from the master branch and, if needed, rebase to the master branch
  before submitting your pull request.
- Update [`CHANGELOG.md`](CHANGELOG.md) if the contribution is relevant for the
  changelog according to the
  [Keep a Changelog](https://keepachangelog.com/en/1.1.0) specification.
- Ensure that your code has an appropriate set of tests which all pass.
- Ensure that your code adheres to the existing style in the code to which you
  are contributing.
- Title your pull request following
  [Conventional Commits](https://www.conventionalcommits.org/) styling.

## Where to go from here?

There are several other documents to check out:

- [`DEVELOP.md`](DEVELOP.md)
- [`MAINTAIN`](MAINTAIN.md)
- [`RELEASE.md`](RELEASE.md)

If some things are unclear, feel free to reach out via GitHub Discussions.
