# Introduction

## 为什么要使用``Analysis``?

``Finance-Python``中的``Analysis``模块对标的是[``TA-Lib``](http://ta-lib.org/)，目标都是提供金融时间序列的指标计算功能。相比与``TA-Lib``，``Analysis``模块有下面这些特点：

* *基于表达式*

``Analysis``模块更加接近数学中表达式的概念。用户在使用的时候，首先是构造想要计算的公式，而不是直接开始计算的过程。

* *方便的组合运算*

由于基于表达式的理念进行构造，``Analysis``模块下的算符，组合的能力更强。不光是可以进行加减乘除四则运算，还可以进行链式复合。

* *增量计算*

``Analysis``模块下的表达式都是进行增量计算的，它只会保留最近的必要信息。这在处理很大的数据量的时候有更明显的优势。``Ta-Lib``中表达式计算需要的数据必须一次性全部输入。

* *更方便的截面数据特性*

相比于``TA-Lib``专注于时间序列数据，``Analysis``通过引入``Symbol``的概念，使得可以处理截面上的时间序列集合。这一特性，更加符合金融中多资产的情形。

* *表达力与性能兼顾*

``Finance-Python`` 在很多情况下与``pandas``的``groupby``操作有相近的性能，但是却有更加强的表达力和扩展能力。
