# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from .broker_data_account_type_enum import BrokerDataAccountTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class Accounts(BaseModel):
    """
    Accounts
    """ # noqa: E501
    id: Optional[UUID] = None
    account_created_at: Optional[datetime] = None
    account_first_trade_at: Optional[datetime] = None
    account_name: Optional[StrictStr] = None
    account_number: Optional[StrictStr] = None
    account_type: Optional[BrokerDataAccountTypeEnum] = None
    account_updated_at: Optional[datetime] = None
    balances_synced_at: Optional[datetime] = None
    broker_provided_account_id: StrictStr
    connection_metadata: Optional[Dict[str, Any]] = None
    created_at: Optional[datetime]
    currency: Optional[StrictStr] = None
    is_simulation_account: Optional[StrictBool] = None
    last_synced_at: Optional[datetime] = None
    orders_synced_at: Optional[datetime] = None
    positions_synced_at: Optional[datetime] = None
    status: Optional[StrictStr] = None
    updated_at: Optional[datetime]
    user_broker_connection_id: UUID
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account_created_at", "account_first_trade_at", "account_name", "account_number", "account_type", "account_updated_at", "balances_synced_at", "broker_provided_account_id", "connection_metadata", "created_at", "currency", "is_simulation_account", "last_synced_at", "orders_synced_at", "positions_synced_at", "status", "updated_at", "user_broker_connection_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Accounts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if account_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_created_at is None and "account_created_at" in self.model_fields_set:
            _dict['account_created_at'] = None

        # set to None if account_first_trade_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_first_trade_at is None and "account_first_trade_at" in self.model_fields_set:
            _dict['account_first_trade_at'] = None

        # set to None if account_name (nullable) is None
        # and model_fields_set contains the field
        if self.account_name is None and "account_name" in self.model_fields_set:
            _dict['account_name'] = None

        # set to None if account_number (nullable) is None
        # and model_fields_set contains the field
        if self.account_number is None and "account_number" in self.model_fields_set:
            _dict['account_number'] = None

        # set to None if account_type (nullable) is None
        # and model_fields_set contains the field
        if self.account_type is None and "account_type" in self.model_fields_set:
            _dict['account_type'] = None

        # set to None if account_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_updated_at is None and "account_updated_at" in self.model_fields_set:
            _dict['account_updated_at'] = None

        # set to None if balances_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.balances_synced_at is None and "balances_synced_at" in self.model_fields_set:
            _dict['balances_synced_at'] = None

        # set to None if connection_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.connection_metadata is None and "connection_metadata" in self.model_fields_set:
            _dict['connection_metadata'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if is_simulation_account (nullable) is None
        # and model_fields_set contains the field
        if self.is_simulation_account is None and "is_simulation_account" in self.model_fields_set:
            _dict['is_simulation_account'] = None

        # set to None if last_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_synced_at is None and "last_synced_at" in self.model_fields_set:
            _dict['last_synced_at'] = None

        # set to None if orders_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.orders_synced_at is None and "orders_synced_at" in self.model_fields_set:
            _dict['orders_synced_at'] = None

        # set to None if positions_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.positions_synced_at is None and "positions_synced_at" in self.model_fields_set:
            _dict['positions_synced_at'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Accounts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account_created_at": obj.get("account_created_at"),
            "account_first_trade_at": obj.get("account_first_trade_at"),
            "account_name": obj.get("account_name"),
            "account_number": obj.get("account_number"),
            "account_type": obj.get("account_type"),
            "account_updated_at": obj.get("account_updated_at"),
            "balances_synced_at": obj.get("balances_synced_at"),
            "broker_provided_account_id": obj.get("broker_provided_account_id"),
            "connection_metadata": obj.get("connection_metadata"),
            "created_at": obj.get("created_at"),
            "currency": obj.get("currency"),
            "is_simulation_account": obj.get("is_simulation_account"),
            "last_synced_at": obj.get("last_synced_at"),
            "orders_synced_at": obj.get("orders_synced_at"),
            "positions_synced_at": obj.get("positions_synced_at"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "user_broker_connection_id": obj.get("user_broker_connection_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


