# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .order_leg import OrderLeg
from typing import Optional, Set
from typing_extensions import Self

class OrderResponse(BaseModel):
    """
    Unified order response for broker data endpoints.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    symbol: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    order_type: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    account_id: Optional[StrictStr] = None
    order_legs: Optional[List[OrderLeg]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "symbol", "side", "order_type", "status", "created_at", "account_id", "order_legs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in order_legs (list)
        _items = []
        if self.order_legs:
            for _item_order_legs in self.order_legs:
                if _item_order_legs:
                    _items.append(_item_order_legs.to_dict())
            _dict['order_legs'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if symbol (nullable) is None
        # and model_fields_set contains the field
        if self.symbol is None and "symbol" in self.model_fields_set:
            _dict['symbol'] = None

        # set to None if side (nullable) is None
        # and model_fields_set contains the field
        if self.side is None and "side" in self.model_fields_set:
            _dict['side'] = None

        # set to None if order_type (nullable) is None
        # and model_fields_set contains the field
        if self.order_type is None and "order_type" in self.model_fields_set:
            _dict['order_type'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if account_id (nullable) is None
        # and model_fields_set contains the field
        if self.account_id is None and "account_id" in self.model_fields_set:
            _dict['account_id'] = None

        # set to None if order_legs (nullable) is None
        # and model_fields_set contains the field
        if self.order_legs is None and "order_legs" in self.model_fields_set:
            _dict['order_legs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "symbol": obj.get("symbol"),
            "side": obj.get("side"),
            "order_type": obj.get("order_type"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "account_id": obj.get("account_id"),
            "order_legs": [OrderLeg.from_dict(_item) for _item in obj["order_legs"]] if obj.get("order_legs") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


