# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from .position_lot_fill_response import PositionLotFillResponse
from typing import Optional, Set
from typing_extensions import Self

class PositionLotResponse(BaseModel):
    """
    Unified position lot (tax lot) response.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    position_id: Optional[StrictStr] = None
    symbol: Optional[StrictStr] = None
    opened_at: Optional[StrictStr] = None
    closed_at: Optional[StrictStr] = None
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    cost_basis: Optional[Union[StrictFloat, StrictInt]] = None
    position_lot_fills: Optional[List[PositionLotFillResponse]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "position_id", "symbol", "opened_at", "closed_at", "quantity", "cost_basis", "position_lot_fills"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PositionLotResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in position_lot_fills (list)
        _items = []
        if self.position_lot_fills:
            for _item_position_lot_fills in self.position_lot_fills:
                if _item_position_lot_fills:
                    _items.append(_item_position_lot_fills.to_dict())
            _dict['position_lot_fills'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if position_id (nullable) is None
        # and model_fields_set contains the field
        if self.position_id is None and "position_id" in self.model_fields_set:
            _dict['position_id'] = None

        # set to None if symbol (nullable) is None
        # and model_fields_set contains the field
        if self.symbol is None and "symbol" in self.model_fields_set:
            _dict['symbol'] = None

        # set to None if opened_at (nullable) is None
        # and model_fields_set contains the field
        if self.opened_at is None and "opened_at" in self.model_fields_set:
            _dict['opened_at'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closed_at'] = None

        # set to None if quantity (nullable) is None
        # and model_fields_set contains the field
        if self.quantity is None and "quantity" in self.model_fields_set:
            _dict['quantity'] = None

        # set to None if cost_basis (nullable) is None
        # and model_fields_set contains the field
        if self.cost_basis is None and "cost_basis" in self.model_fields_set:
            _dict['cost_basis'] = None

        # set to None if position_lot_fills (nullable) is None
        # and model_fields_set contains the field
        if self.position_lot_fills is None and "position_lot_fills" in self.model_fields_set:
            _dict['position_lot_fills'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PositionLotResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "position_id": obj.get("position_id"),
            "symbol": obj.get("symbol"),
            "opened_at": obj.get("opened_at"),
            "closed_at": obj.get("closed_at"),
            "quantity": obj.get("quantity"),
            "cost_basis": obj.get("cost_basis"),
            "position_lot_fills": [PositionLotFillResponse.from_dict(_item) for _item in obj["position_lot_fills"]] if obj.get("position_lot_fills") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


