# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from .broker_data_connection_status_enum import BrokerDataConnectionStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class UserBrokerConnections(BaseModel):
    """
    UserBrokerConnections
    """ # noqa: E501
    id: Optional[UUID] = None
    broker_id: StrictStr
    circuit_open: Optional[StrictBool] = None
    circuit_open_until: Optional[datetime] = None
    connection_metadata: Optional[Dict[str, Any]] = None
    consecutive_failures: Optional[StrictInt] = None
    created_at: Optional[datetime]
    error_message: Optional[StrictStr] = None
    last_synced_at: Optional[datetime] = None
    status: Optional[BrokerDataConnectionStatusEnum] = None
    updated_at: Optional[datetime]
    user_id: UUID
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "broker_id", "circuit_open", "circuit_open_until", "connection_metadata", "consecutive_failures", "created_at", "error_message", "last_synced_at", "status", "updated_at", "user_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserBrokerConnections from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if circuit_open (nullable) is None
        # and model_fields_set contains the field
        if self.circuit_open is None and "circuit_open" in self.model_fields_set:
            _dict['circuit_open'] = None

        # set to None if circuit_open_until (nullable) is None
        # and model_fields_set contains the field
        if self.circuit_open_until is None and "circuit_open_until" in self.model_fields_set:
            _dict['circuit_open_until'] = None

        # set to None if connection_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.connection_metadata is None and "connection_metadata" in self.model_fields_set:
            _dict['connection_metadata'] = None

        # set to None if consecutive_failures (nullable) is None
        # and model_fields_set contains the field
        if self.consecutive_failures is None and "consecutive_failures" in self.model_fields_set:
            _dict['consecutive_failures'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if last_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_synced_at is None and "last_synced_at" in self.model_fields_set:
            _dict['last_synced_at'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserBrokerConnections from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "broker_id": obj.get("broker_id"),
            "circuit_open": obj.get("circuit_open"),
            "circuit_open_until": obj.get("circuit_open_until"),
            "connection_metadata": obj.get("connection_metadata"),
            "consecutive_failures": obj.get("consecutive_failures"),
            "created_at": obj.get("created_at"),
            "error_message": obj.get("error_message"),
            "last_synced_at": obj.get("last_synced_at"),
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "user_id": obj.get("user_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


