# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .assettype import Assettype
from .closedquantity import Closedquantity
from .closepriceavg import Closepriceavg
from .costbasis1 import Costbasis1
from .costbasiswithcommission1 import Costbasiswithcommission1
from .fdx_broker_position_lot_fill import FDXBrokerPositionLotFill
from .openprice import Openprice
from .openquantity import Openquantity
from .realizedprofitloss1 import Realizedprofitloss1
from .realizedprofitlosswithcommission1 import Realizedprofitlosswithcommission1
from .remainingquantity1 import Remainingquantity1
from .side3 import Side3
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerPositionLot(BaseModel):
    """
    FDX-style position lot schema for tax lot tracking.  Represents tax lots for positions, used for tax reporting and FIFO/LIFO tracking.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    lot_id: StrictStr = Field(description="Lot identifier", alias="lotId")
    position_id: Optional[StrictStr] = Field(default=None, alias="positionId")
    account_id: StrictStr = Field(description="Broker account identifier", alias="accountId")
    security_id: StrictStr = Field(description="Security identifier", alias="securityId")
    asset_type: Assettype = Field(alias="assetType")
    side: Optional[Side3] = None
    opened_at: datetime = Field(description="When lot was opened", alias="openedAt")
    closed_at: Optional[datetime] = Field(default=None, alias="closedAt")
    open_quantity: Openquantity = Field(alias="openQuantity")
    remaining_quantity: Remainingquantity1 = Field(alias="remainingQuantity")
    closed_quantity: Closedquantity = Field(alias="closedQuantity")
    open_price: Openprice = Field(alias="openPrice")
    close_price_avg: Optional[Closepriceavg] = Field(default=None, alias="closePriceAvg")
    cost_basis: Costbasis1 = Field(alias="costBasis")
    cost_basis_with_commission: Costbasiswithcommission1 = Field(alias="costBasisWithCommission")
    realized_profit_loss: Realizedprofitloss1 = Field(alias="realizedProfitLoss")
    realized_profit_loss_with_commission: Realizedprofitlosswithcommission1 = Field(alias="realizedProfitLossWithCommission")
    position_lot_fills: Optional[List[FDXBrokerPositionLotFill]] = Field(default=None, description="Fills associated with this lot", alias="positionLotFills")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "lotId", "positionId", "accountId", "securityId", "assetType", "side", "openedAt", "closedAt", "openQuantity", "remainingQuantity", "closedQuantity", "openPrice", "closePriceAvg", "costBasis", "costBasisWithCommission", "realizedProfitLoss", "realizedProfitLossWithCommission", "positionLotFills", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerPositionLot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of asset_type
        if self.asset_type:
            _dict['assetType'] = self.asset_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of side
        if self.side:
            _dict['side'] = self.side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of open_quantity
        if self.open_quantity:
            _dict['openQuantity'] = self.open_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remaining_quantity
        if self.remaining_quantity:
            _dict['remainingQuantity'] = self.remaining_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of closed_quantity
        if self.closed_quantity:
            _dict['closedQuantity'] = self.closed_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of open_price
        if self.open_price:
            _dict['openPrice'] = self.open_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of close_price_avg
        if self.close_price_avg:
            _dict['closePriceAvg'] = self.close_price_avg.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_basis
        if self.cost_basis:
            _dict['costBasis'] = self.cost_basis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_basis_with_commission
        if self.cost_basis_with_commission:
            _dict['costBasisWithCommission'] = self.cost_basis_with_commission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realized_profit_loss
        if self.realized_profit_loss:
            _dict['realizedProfitLoss'] = self.realized_profit_loss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realized_profit_loss_with_commission
        if self.realized_profit_loss_with_commission:
            _dict['realizedProfitLossWithCommission'] = self.realized_profit_loss_with_commission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in position_lot_fills (list)
        _items = []
        if self.position_lot_fills:
            for _item_position_lot_fills in self.position_lot_fills:
                if _item_position_lot_fills:
                    _items.append(_item_position_lot_fills.to_dict())
            _dict['positionLotFills'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if position_id (nullable) is None
        # and model_fields_set contains the field
        if self.position_id is None and "position_id" in self.model_fields_set:
            _dict['positionId'] = None

        # set to None if side (nullable) is None
        # and model_fields_set contains the field
        if self.side is None and "side" in self.model_fields_set:
            _dict['side'] = None

        # set to None if closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.closed_at is None and "closed_at" in self.model_fields_set:
            _dict['closedAt'] = None

        # set to None if close_price_avg (nullable) is None
        # and model_fields_set contains the field
        if self.close_price_avg is None and "close_price_avg" in self.model_fields_set:
            _dict['closePriceAvg'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerPositionLot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "lotId": obj.get("lotId"),
            "positionId": obj.get("positionId"),
            "accountId": obj.get("accountId"),
            "securityId": obj.get("securityId"),
            "assetType": Assettype.from_dict(obj["assetType"]) if obj.get("assetType") is not None else None,
            "side": Side3.from_dict(obj["side"]) if obj.get("side") is not None else None,
            "openedAt": obj.get("openedAt"),
            "closedAt": obj.get("closedAt"),
            "openQuantity": Openquantity.from_dict(obj["openQuantity"]) if obj.get("openQuantity") is not None else None,
            "remainingQuantity": Remainingquantity1.from_dict(obj["remainingQuantity"]) if obj.get("remainingQuantity") is not None else None,
            "closedQuantity": Closedquantity.from_dict(obj["closedQuantity"]) if obj.get("closedQuantity") is not None else None,
            "openPrice": Openprice.from_dict(obj["openPrice"]) if obj.get("openPrice") is not None else None,
            "closePriceAvg": Closepriceavg.from_dict(obj["closePriceAvg"]) if obj.get("closePriceAvg") is not None else None,
            "costBasis": Costbasis1.from_dict(obj["costBasis"]) if obj.get("costBasis") is not None else None,
            "costBasisWithCommission": Costbasiswithcommission1.from_dict(obj["costBasisWithCommission"]) if obj.get("costBasisWithCommission") is not None else None,
            "realizedProfitLoss": Realizedprofitloss1.from_dict(obj["realizedProfitLoss"]) if obj.get("realizedProfitLoss") is not None else None,
            "realizedProfitLossWithCommission": Realizedprofitlosswithcommission1.from_dict(obj["realizedProfitLossWithCommission"]) if obj.get("realizedProfitLossWithCommission") is not None else None,
            "positionLotFills": [FDXBrokerPositionLotFill.from_dict(_item) for _item in obj["positionLotFills"]] if obj.get("positionLotFills") is not None else None,
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


