# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .assettype import Assettype
from .averagebuyprice import Averagebuyprice
from .averagesellprice import Averagesellprice
from .costbasis import Costbasis
from .costbasiswithcommission import Costbasiswithcommission
from .currentprice import Currentprice
from .marketvalue import Marketvalue
from .quantity1 import Quantity1
from .realizedprofitloss import Realizedprofitloss
from .realizedprofitlosspercent import Realizedprofitlosspercent
from .realizedprofitlosswithcommission import Realizedprofitlosswithcommission
from .securityidtype import Securityidtype
from .side1 import Side1
from .status1 import Status1
from .units import Units
from .unrealizedprofitloss import Unrealizedprofitloss
from .unrealizedprofitlosspercent import Unrealizedprofitlosspercent
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerPosition(BaseModel):
    """
    FDX-style broker position schema.  Based on FDX Holdings, significantly extended for trading: - Short positions - Realized/unrealized P&L - Position lifecycle - Commission tracking
    """ # noqa: E501
    id: Optional[StrictStr] = None
    account_id: StrictStr = Field(description="Broker account identifier", alias="accountId")
    connection_id: StrictStr = Field(description="User-broker connection identifier", alias="connectionId")
    security_id: StrictStr = Field(description="Symbol or instrument", alias="securityId")
    security_id_type: Securityidtype = Field(alias="securityIdType")
    asset_type: Assettype = Field(alias="assetType")
    quantity: Quantity1
    side: Optional[Side1] = None
    status: Optional[Status1] = None
    cost_basis: Optional[Costbasis] = Field(default=None, alias="costBasis")
    market_value: Optional[Marketvalue] = Field(default=None, alias="marketValue")
    units: Optional[Units] = None
    average_buy_price: Optional[Averagebuyprice] = Field(default=None, alias="averageBuyPrice")
    average_sell_price: Optional[Averagesellprice] = Field(default=None, alias="averageSellPrice")
    cost_basis_with_commission: Optional[Costbasiswithcommission] = Field(default=None, alias="costBasisWithCommission")
    current_price: Optional[Currentprice] = Field(default=None, alias="currentPrice")
    realized_profit_loss: Optional[Realizedprofitloss] = Field(default=None, alias="realizedProfitLoss")
    realized_profit_loss_with_commission: Optional[Realizedprofitlosswithcommission] = Field(default=None, alias="realizedProfitLossWithCommission")
    realized_profit_loss_percent: Optional[Realizedprofitlosspercent] = Field(default=None, alias="realizedProfitLossPercent")
    unrealized_profit_loss: Optional[Unrealizedprofitloss] = Field(default=None, alias="unrealizedProfitLoss")
    unrealized_profit_loss_percent: Optional[Unrealizedprofitlosspercent] = Field(default=None, alias="unrealizedProfitLossPercent")
    position_created_at: Optional[datetime] = Field(default=None, alias="positionCreatedAt")
    position_updated_at: Optional[datetime] = Field(default=None, alias="positionUpdatedAt")
    position_closed_at: Optional[datetime] = Field(default=None, alias="positionClosedAt")
    position_group_id: Optional[StrictStr] = Field(default=None, alias="positionGroupId")
    snapshot_date: Optional[date] = Field(default=None, alias="snapshotDate")
    instrument_key: Optional[StrictStr] = Field(default=None, alias="instrumentKey")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "connectionId", "securityId", "securityIdType", "assetType", "quantity", "side", "status", "costBasis", "marketValue", "units", "averageBuyPrice", "averageSellPrice", "costBasisWithCommission", "currentPrice", "realizedProfitLoss", "realizedProfitLossWithCommission", "realizedProfitLossPercent", "unrealizedProfitLoss", "unrealizedProfitLossPercent", "positionCreatedAt", "positionUpdatedAt", "positionClosedAt", "positionGroupId", "snapshotDate", "instrumentKey", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerPosition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security_id_type
        if self.security_id_type:
            _dict['securityIdType'] = self.security_id_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset_type
        if self.asset_type:
            _dict['assetType'] = self.asset_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict['quantity'] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of side
        if self.side:
            _dict['side'] = self.side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_basis
        if self.cost_basis:
            _dict['costBasis'] = self.cost_basis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of market_value
        if self.market_value:
            _dict['marketValue'] = self.market_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of units
        if self.units:
            _dict['units'] = self.units.to_dict()
        # override the default output from pydantic by calling `to_dict()` of average_buy_price
        if self.average_buy_price:
            _dict['averageBuyPrice'] = self.average_buy_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of average_sell_price
        if self.average_sell_price:
            _dict['averageSellPrice'] = self.average_sell_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_basis_with_commission
        if self.cost_basis_with_commission:
            _dict['costBasisWithCommission'] = self.cost_basis_with_commission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of current_price
        if self.current_price:
            _dict['currentPrice'] = self.current_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realized_profit_loss
        if self.realized_profit_loss:
            _dict['realizedProfitLoss'] = self.realized_profit_loss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realized_profit_loss_with_commission
        if self.realized_profit_loss_with_commission:
            _dict['realizedProfitLossWithCommission'] = self.realized_profit_loss_with_commission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of realized_profit_loss_percent
        if self.realized_profit_loss_percent:
            _dict['realizedProfitLossPercent'] = self.realized_profit_loss_percent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unrealized_profit_loss
        if self.unrealized_profit_loss:
            _dict['unrealizedProfitLoss'] = self.unrealized_profit_loss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unrealized_profit_loss_percent
        if self.unrealized_profit_loss_percent:
            _dict['unrealizedProfitLossPercent'] = self.unrealized_profit_loss_percent.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if side (nullable) is None
        # and model_fields_set contains the field
        if self.side is None and "side" in self.model_fields_set:
            _dict['side'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if cost_basis (nullable) is None
        # and model_fields_set contains the field
        if self.cost_basis is None and "cost_basis" in self.model_fields_set:
            _dict['costBasis'] = None

        # set to None if market_value (nullable) is None
        # and model_fields_set contains the field
        if self.market_value is None and "market_value" in self.model_fields_set:
            _dict['marketValue'] = None

        # set to None if units (nullable) is None
        # and model_fields_set contains the field
        if self.units is None and "units" in self.model_fields_set:
            _dict['units'] = None

        # set to None if average_buy_price (nullable) is None
        # and model_fields_set contains the field
        if self.average_buy_price is None and "average_buy_price" in self.model_fields_set:
            _dict['averageBuyPrice'] = None

        # set to None if average_sell_price (nullable) is None
        # and model_fields_set contains the field
        if self.average_sell_price is None and "average_sell_price" in self.model_fields_set:
            _dict['averageSellPrice'] = None

        # set to None if cost_basis_with_commission (nullable) is None
        # and model_fields_set contains the field
        if self.cost_basis_with_commission is None and "cost_basis_with_commission" in self.model_fields_set:
            _dict['costBasisWithCommission'] = None

        # set to None if current_price (nullable) is None
        # and model_fields_set contains the field
        if self.current_price is None and "current_price" in self.model_fields_set:
            _dict['currentPrice'] = None

        # set to None if realized_profit_loss (nullable) is None
        # and model_fields_set contains the field
        if self.realized_profit_loss is None and "realized_profit_loss" in self.model_fields_set:
            _dict['realizedProfitLoss'] = None

        # set to None if realized_profit_loss_with_commission (nullable) is None
        # and model_fields_set contains the field
        if self.realized_profit_loss_with_commission is None and "realized_profit_loss_with_commission" in self.model_fields_set:
            _dict['realizedProfitLossWithCommission'] = None

        # set to None if realized_profit_loss_percent (nullable) is None
        # and model_fields_set contains the field
        if self.realized_profit_loss_percent is None and "realized_profit_loss_percent" in self.model_fields_set:
            _dict['realizedProfitLossPercent'] = None

        # set to None if unrealized_profit_loss (nullable) is None
        # and model_fields_set contains the field
        if self.unrealized_profit_loss is None and "unrealized_profit_loss" in self.model_fields_set:
            _dict['unrealizedProfitLoss'] = None

        # set to None if unrealized_profit_loss_percent (nullable) is None
        # and model_fields_set contains the field
        if self.unrealized_profit_loss_percent is None and "unrealized_profit_loss_percent" in self.model_fields_set:
            _dict['unrealizedProfitLossPercent'] = None

        # set to None if position_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_created_at is None and "position_created_at" in self.model_fields_set:
            _dict['positionCreatedAt'] = None

        # set to None if position_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_updated_at is None and "position_updated_at" in self.model_fields_set:
            _dict['positionUpdatedAt'] = None

        # set to None if position_closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_closed_at is None and "position_closed_at" in self.model_fields_set:
            _dict['positionClosedAt'] = None

        # set to None if position_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.position_group_id is None and "position_group_id" in self.model_fields_set:
            _dict['positionGroupId'] = None

        # set to None if snapshot_date (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_date is None and "snapshot_date" in self.model_fields_set:
            _dict['snapshotDate'] = None

        # set to None if instrument_key (nullable) is None
        # and model_fields_set contains the field
        if self.instrument_key is None and "instrument_key" in self.model_fields_set:
            _dict['instrumentKey'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerPosition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "connectionId": obj.get("connectionId"),
            "securityId": obj.get("securityId"),
            "securityIdType": Securityidtype.from_dict(obj["securityIdType"]) if obj.get("securityIdType") is not None else None,
            "assetType": Assettype.from_dict(obj["assetType"]) if obj.get("assetType") is not None else None,
            "quantity": Quantity1.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
            "side": Side1.from_dict(obj["side"]) if obj.get("side") is not None else None,
            "status": Status1.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "costBasis": Costbasis.from_dict(obj["costBasis"]) if obj.get("costBasis") is not None else None,
            "marketValue": Marketvalue.from_dict(obj["marketValue"]) if obj.get("marketValue") is not None else None,
            "units": Units.from_dict(obj["units"]) if obj.get("units") is not None else None,
            "averageBuyPrice": Averagebuyprice.from_dict(obj["averageBuyPrice"]) if obj.get("averageBuyPrice") is not None else None,
            "averageSellPrice": Averagesellprice.from_dict(obj["averageSellPrice"]) if obj.get("averageSellPrice") is not None else None,
            "costBasisWithCommission": Costbasiswithcommission.from_dict(obj["costBasisWithCommission"]) if obj.get("costBasisWithCommission") is not None else None,
            "currentPrice": Currentprice.from_dict(obj["currentPrice"]) if obj.get("currentPrice") is not None else None,
            "realizedProfitLoss": Realizedprofitloss.from_dict(obj["realizedProfitLoss"]) if obj.get("realizedProfitLoss") is not None else None,
            "realizedProfitLossWithCommission": Realizedprofitlosswithcommission.from_dict(obj["realizedProfitLossWithCommission"]) if obj.get("realizedProfitLossWithCommission") is not None else None,
            "realizedProfitLossPercent": Realizedprofitlosspercent.from_dict(obj["realizedProfitLossPercent"]) if obj.get("realizedProfitLossPercent") is not None else None,
            "unrealizedProfitLoss": Unrealizedprofitloss.from_dict(obj["unrealizedProfitLoss"]) if obj.get("unrealizedProfitLoss") is not None else None,
            "unrealizedProfitLossPercent": Unrealizedprofitlosspercent.from_dict(obj["unrealizedProfitLossPercent"]) if obj.get("unrealizedProfitLossPercent") is not None else None,
            "positionCreatedAt": obj.get("positionCreatedAt"),
            "positionUpdatedAt": obj.get("positionUpdatedAt"),
            "positionClosedAt": obj.get("positionClosedAt"),
            "positionGroupId": obj.get("positionGroupId"),
            "snapshotDate": obj.get("snapshotDate"),
            "instrumentKey": obj.get("instrumentKey"),
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


