# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .commissionshare import Commissionshare
from .fillprice import Fillprice
from .fillquantity import Fillquantity
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerPositionLotFill(BaseModel):
    """
    FDX-style position lot fill schema.  Represents individual fills associated with position lots for tax lot tracking.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    lot_fill_id: StrictStr = Field(description="Lot fill identifier", alias="lotFillId")
    lot_id: StrictStr = Field(description="Associated position lot identifier", alias="lotId")
    order_fill_id: StrictStr = Field(description="Associated order fill identifier", alias="orderFillId")
    fill_quantity: Fillquantity = Field(alias="fillQuantity")
    fill_price: Fillprice = Field(alias="fillPrice")
    commission_share: Optional[Commissionshare] = Field(default=None, alias="commissionShare")
    executed_at: datetime = Field(description="Execution timestamp", alias="executedAt")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "lotFillId", "lotId", "orderFillId", "fillQuantity", "fillPrice", "commissionShare", "executedAt", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerPositionLotFill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fill_quantity
        if self.fill_quantity:
            _dict['fillQuantity'] = self.fill_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fill_price
        if self.fill_price:
            _dict['fillPrice'] = self.fill_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of commission_share
        if self.commission_share:
            _dict['commissionShare'] = self.commission_share.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if commission_share (nullable) is None
        # and model_fields_set contains the field
        if self.commission_share is None and "commission_share" in self.model_fields_set:
            _dict['commissionShare'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerPositionLotFill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "lotFillId": obj.get("lotFillId"),
            "lotId": obj.get("lotId"),
            "orderFillId": obj.get("orderFillId"),
            "fillQuantity": Fillquantity.from_dict(obj["fillQuantity"]) if obj.get("fillQuantity") is not None else None,
            "fillPrice": Fillprice.from_dict(obj["fillPrice"]) if obj.get("fillPrice") is not None else None,
            "commissionShare": Commissionshare.from_dict(obj["commissionShare"]) if obj.get("commissionShare") is not None else None,
            "executedAt": obj.get("executedAt"),
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


