# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class DisconnectCompanyFromBrokerConnectionResult(BaseModel):
    """
    Result model for disconnect company from broker connection endpoint.  This model represents the outcome of disconnecting a company account from a broker connection. Used by the DELETE /disconnect-company/{connection_id} endpoint to return success or failure status along with a descriptive message.  Disconnecting a company removes the company's access to the broker connection but does not delete the connection itself, which may still be accessible to other companies or the original user.  Attributes ---------- success : bool     Whether the disconnection operation completed successfully. True if the     company was disconnected from the connection, False if an error occurred. message : str     Human-readable message describing the result of the disconnection operation.     Contains success confirmation or error details.  Notes ----- 1. **Partial Removal**: Disconnecting a company only removes the company's    access permissions. The underlying broker connection remains intact.  2. **CompanyAccess Table**: This operation removes or updates records in the    CompanyAccess table that link the company to the broker connection.  3. **Multi-Company Support**: A single broker connection can be shared across    multiple companies. Disconnecting one company does not affect others.  Examples -------- >>> # Successful disconnection >>> result = DisconnectCompanyFromBrokerConnectionResult( ...     success=True, ...     message=\"Successfully disconnected company from broker connection\", ... ) >>> # Failed disconnection >>> result = DisconnectCompanyFromBrokerConnectionResult( ...     success=False, ...     message=\"Error: Company not associated with this connection\", ... )  See Also -------- finaticapi.api.v1.routers.brokers.brokers_router.disconnect_company_from_connection     : Endpoint that returns this model finaticapi.core.services.broker_service.BrokerService.disconnect_company_from_connection     : Service method that performs disconnection
    """ # noqa: E501
    success: StrictBool
    message: StrictStr
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["success", "message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DisconnectCompanyFromBrokerConnectionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DisconnectCompanyFromBrokerConnectionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "message": obj.get("message")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


