# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .assettype import Assettype
from .commission import Commission
from .price import Price
from .quantity2 import Quantity2
from .securityidtype import Securityidtype
from .side2 import Side2
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerOrderFill(BaseModel):
    """
    FDX-style order fill/execution schema.  Represents individual order executions/fills.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    fill_id: StrictStr = Field(description="Finatic fill ID", alias="fillId")
    order_id: StrictStr = Field(description="Parent order identifier", alias="orderId")
    leg_id: Optional[StrictStr] = Field(default=None, alias="legId")
    execution_id: Optional[StrictStr] = Field(default=None, alias="executionId")
    trade_id: Optional[StrictStr] = Field(default=None, alias="tradeId")
    security_id: StrictStr = Field(description="Security identifier", alias="securityId")
    security_id_type: Securityidtype = Field(alias="securityIdType")
    asset_type: Assettype = Field(alias="assetType")
    side: Side2
    quantity: Quantity2
    price: Price
    executed_at: datetime = Field(description="Broker execution timestamp", alias="executedAt")
    venue: Optional[StrictStr] = None
    commission: Optional[Commission] = None
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "fillId", "orderId", "legId", "executionId", "tradeId", "securityId", "securityIdType", "assetType", "side", "quantity", "price", "executedAt", "venue", "commission", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderFill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security_id_type
        if self.security_id_type:
            _dict['securityIdType'] = self.security_id_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset_type
        if self.asset_type:
            _dict['assetType'] = self.asset_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of side
        if self.side:
            _dict['side'] = self.side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict['quantity'] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of commission
        if self.commission:
            _dict['commission'] = self.commission.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if leg_id (nullable) is None
        # and model_fields_set contains the field
        if self.leg_id is None and "leg_id" in self.model_fields_set:
            _dict['legId'] = None

        # set to None if execution_id (nullable) is None
        # and model_fields_set contains the field
        if self.execution_id is None and "execution_id" in self.model_fields_set:
            _dict['executionId'] = None

        # set to None if trade_id (nullable) is None
        # and model_fields_set contains the field
        if self.trade_id is None and "trade_id" in self.model_fields_set:
            _dict['tradeId'] = None

        # set to None if venue (nullable) is None
        # and model_fields_set contains the field
        if self.venue is None and "venue" in self.model_fields_set:
            _dict['venue'] = None

        # set to None if commission (nullable) is None
        # and model_fields_set contains the field
        if self.commission is None and "commission" in self.model_fields_set:
            _dict['commission'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderFill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "fillId": obj.get("fillId"),
            "orderId": obj.get("orderId"),
            "legId": obj.get("legId"),
            "executionId": obj.get("executionId"),
            "tradeId": obj.get("tradeId"),
            "securityId": obj.get("securityId"),
            "securityIdType": Securityidtype.from_dict(obj["securityIdType"]) if obj.get("securityIdType") is not None else None,
            "assetType": Assettype.from_dict(obj["assetType"]) if obj.get("assetType") is not None else None,
            "side": Side2.from_dict(obj["side"]) if obj.get("side") is not None else None,
            "quantity": Quantity2.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
            "price": Price.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "executedAt": obj.get("executedAt"),
            "venue": obj.get("venue"),
            "commission": Commission.from_dict(obj["commission"]) if obj.get("commission") is not None else None,
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


