# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from .eventtype import Eventtype
from .orderstatus import Orderstatus
from .previousstatus import Previousstatus
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerOrderEvent(BaseModel):
    """
    FDX-style order event schema for lifecycle tracking.  Represents order lifecycle events and state changes.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    event_id: StrictStr = Field(description="Event identifier (for idempotency)", alias="eventId")
    order_id: StrictStr = Field(description="Associated order identifier", alias="orderId")
    order_group_id: Optional[StrictStr] = Field(default=None, alias="orderGroupId")
    event_type: Eventtype = Field(alias="eventType")
    event_category: Optional[StrictStr] = Field(default=None, alias="eventCategory")
    order_status: Optional[Orderstatus] = Field(default=None, alias="orderStatus")
    previous_status: Optional[Previousstatus] = Field(default=None, alias="previousStatus")
    event_time: datetime = Field(description="Broker-reported event time", alias="eventTime")
    recorded_at: Optional[datetime] = Field(default=None, alias="recordedAt")
    related_order_id: Optional[StrictStr] = Field(default=None, alias="relatedOrderId")
    related_event_id: Optional[StrictStr] = Field(default=None, alias="relatedEventId")
    inferred: Optional[StrictBool] = None
    confidence: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = None
    reason_code: Optional[StrictStr] = Field(default=None, alias="reasonCode")
    affected_legs: Optional[List[StrictInt]] = Field(default=None, alias="affectedLegs")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "eventId", "orderId", "orderGroupId", "eventType", "eventCategory", "orderStatus", "previousStatus", "eventTime", "recordedAt", "relatedOrderId", "relatedEventId", "inferred", "confidence", "reasonCode", "affectedLegs", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of event_type
        if self.event_type:
            _dict['eventType'] = self.event_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_status
        if self.order_status:
            _dict['orderStatus'] = self.order_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_status
        if self.previous_status:
            _dict['previousStatus'] = self.previous_status.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if order_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_group_id is None and "order_group_id" in self.model_fields_set:
            _dict['orderGroupId'] = None

        # set to None if event_category (nullable) is None
        # and model_fields_set contains the field
        if self.event_category is None and "event_category" in self.model_fields_set:
            _dict['eventCategory'] = None

        # set to None if order_status (nullable) is None
        # and model_fields_set contains the field
        if self.order_status is None and "order_status" in self.model_fields_set:
            _dict['orderStatus'] = None

        # set to None if previous_status (nullable) is None
        # and model_fields_set contains the field
        if self.previous_status is None and "previous_status" in self.model_fields_set:
            _dict['previousStatus'] = None

        # set to None if recorded_at (nullable) is None
        # and model_fields_set contains the field
        if self.recorded_at is None and "recorded_at" in self.model_fields_set:
            _dict['recordedAt'] = None

        # set to None if related_order_id (nullable) is None
        # and model_fields_set contains the field
        if self.related_order_id is None and "related_order_id" in self.model_fields_set:
            _dict['relatedOrderId'] = None

        # set to None if related_event_id (nullable) is None
        # and model_fields_set contains the field
        if self.related_event_id is None and "related_event_id" in self.model_fields_set:
            _dict['relatedEventId'] = None

        # set to None if inferred (nullable) is None
        # and model_fields_set contains the field
        if self.inferred is None and "inferred" in self.model_fields_set:
            _dict['inferred'] = None

        # set to None if confidence (nullable) is None
        # and model_fields_set contains the field
        if self.confidence is None and "confidence" in self.model_fields_set:
            _dict['confidence'] = None

        # set to None if reason_code (nullable) is None
        # and model_fields_set contains the field
        if self.reason_code is None and "reason_code" in self.model_fields_set:
            _dict['reasonCode'] = None

        # set to None if affected_legs (nullable) is None
        # and model_fields_set contains the field
        if self.affected_legs is None and "affected_legs" in self.model_fields_set:
            _dict['affectedLegs'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "eventId": obj.get("eventId"),
            "orderId": obj.get("orderId"),
            "orderGroupId": obj.get("orderGroupId"),
            "eventType": Eventtype.from_dict(obj["eventType"]) if obj.get("eventType") is not None else None,
            "eventCategory": obj.get("eventCategory"),
            "orderStatus": Orderstatus.from_dict(obj["orderStatus"]) if obj.get("orderStatus") is not None else None,
            "previousStatus": Previousstatus.from_dict(obj["previousStatus"]) if obj.get("previousStatus") is not None else None,
            "eventTime": obj.get("eventTime"),
            "recordedAt": obj.get("recordedAt"),
            "relatedOrderId": obj.get("relatedOrderId"),
            "relatedEventId": obj.get("relatedEventId"),
            "inferred": obj.get("inferred"),
            "confidence": obj.get("confidence"),
            "reasonCode": obj.get("reasonCode"),
            "affectedLegs": obj.get("affectedLegs"),
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


