# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LegacyBrokerAccount(BaseModel):
    """
    Legacy broker account schema matching pre-refactor JSON format.  This model uses camelCase field names to match the legacy API response format.
    """ # noqa: E501
    id: StrictStr = Field(description="Account UUID")
    account_id: StrictStr = Field(description="Broker-provided account ID", alias="accountId")
    account_number: Optional[StrictStr] = Field(default=None, alias="accountNumber")
    account_name: Optional[StrictStr] = Field(default=None, alias="accountName")
    account_type: Optional[StrictStr] = Field(default=None, alias="accountType")
    broker_id: Optional[StrictStr] = Field(default=None, alias="brokerId")
    broker_name: Optional[StrictStr] = Field(default=None, alias="brokerName")
    institution_id: Optional[StrictStr] = Field(default=None, alias="institutionId")
    currency_code: Optional[StrictStr] = Field(default=None, alias="currencyCode")
    account_status: Optional[StrictStr] = Field(default=None, alias="accountStatus")
    sub_account_type: Optional[StrictStr] = Field(default=None, alias="subAccountType")
    account_classification: Optional[StrictStr] = Field(default=None, alias="accountClassification")
    connection_id: Optional[StrictStr] = Field(default=None, alias="connectionId")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    account_created_at: Optional[datetime] = Field(default=None, alias="accountCreatedAt")
    account_updated_at: Optional[datetime] = Field(default=None, alias="accountUpdatedAt")
    account_first_trade_at: Optional[datetime] = Field(default=None, alias="accountFirstTradeAt")
    last_synced_at: Optional[datetime] = Field(default=None, alias="lastSyncedAt")
    balances_synced_at: Optional[datetime] = Field(default=None, alias="balancesSyncedAt")
    orders_synced_at: Optional[datetime] = Field(default=None, alias="ordersSyncedAt")
    positions_synced_at: Optional[datetime] = Field(default=None, alias="positionsSyncedAt")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "accountId", "accountNumber", "accountName", "accountType", "brokerId", "brokerName", "institutionId", "currencyCode", "accountStatus", "subAccountType", "accountClassification", "connectionId", "userId", "createdAt", "updatedAt", "accountCreatedAt", "accountUpdatedAt", "accountFirstTradeAt", "lastSyncedAt", "balancesSyncedAt", "ordersSyncedAt", "positionsSyncedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LegacyBrokerAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if account_number (nullable) is None
        # and model_fields_set contains the field
        if self.account_number is None and "account_number" in self.model_fields_set:
            _dict['accountNumber'] = None

        # set to None if account_name (nullable) is None
        # and model_fields_set contains the field
        if self.account_name is None and "account_name" in self.model_fields_set:
            _dict['accountName'] = None

        # set to None if account_type (nullable) is None
        # and model_fields_set contains the field
        if self.account_type is None and "account_type" in self.model_fields_set:
            _dict['accountType'] = None

        # set to None if broker_id (nullable) is None
        # and model_fields_set contains the field
        if self.broker_id is None and "broker_id" in self.model_fields_set:
            _dict['brokerId'] = None

        # set to None if broker_name (nullable) is None
        # and model_fields_set contains the field
        if self.broker_name is None and "broker_name" in self.model_fields_set:
            _dict['brokerName'] = None

        # set to None if institution_id (nullable) is None
        # and model_fields_set contains the field
        if self.institution_id is None and "institution_id" in self.model_fields_set:
            _dict['institutionId'] = None

        # set to None if currency_code (nullable) is None
        # and model_fields_set contains the field
        if self.currency_code is None and "currency_code" in self.model_fields_set:
            _dict['currencyCode'] = None

        # set to None if account_status (nullable) is None
        # and model_fields_set contains the field
        if self.account_status is None and "account_status" in self.model_fields_set:
            _dict['accountStatus'] = None

        # set to None if sub_account_type (nullable) is None
        # and model_fields_set contains the field
        if self.sub_account_type is None and "sub_account_type" in self.model_fields_set:
            _dict['subAccountType'] = None

        # set to None if account_classification (nullable) is None
        # and model_fields_set contains the field
        if self.account_classification is None and "account_classification" in self.model_fields_set:
            _dict['accountClassification'] = None

        # set to None if connection_id (nullable) is None
        # and model_fields_set contains the field
        if self.connection_id is None and "connection_id" in self.model_fields_set:
            _dict['connectionId'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userId'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if account_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_created_at is None and "account_created_at" in self.model_fields_set:
            _dict['accountCreatedAt'] = None

        # set to None if account_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_updated_at is None and "account_updated_at" in self.model_fields_set:
            _dict['accountUpdatedAt'] = None

        # set to None if account_first_trade_at (nullable) is None
        # and model_fields_set contains the field
        if self.account_first_trade_at is None and "account_first_trade_at" in self.model_fields_set:
            _dict['accountFirstTradeAt'] = None

        # set to None if last_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_synced_at is None and "last_synced_at" in self.model_fields_set:
            _dict['lastSyncedAt'] = None

        # set to None if balances_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.balances_synced_at is None and "balances_synced_at" in self.model_fields_set:
            _dict['balancesSyncedAt'] = None

        # set to None if orders_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.orders_synced_at is None and "orders_synced_at" in self.model_fields_set:
            _dict['ordersSyncedAt'] = None

        # set to None if positions_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.positions_synced_at is None and "positions_synced_at" in self.model_fields_set:
            _dict['positionsSyncedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LegacyBrokerAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "accountNumber": obj.get("accountNumber"),
            "accountName": obj.get("accountName"),
            "accountType": obj.get("accountType"),
            "brokerId": obj.get("brokerId"),
            "brokerName": obj.get("brokerName"),
            "institutionId": obj.get("institutionId"),
            "currencyCode": obj.get("currencyCode"),
            "accountStatus": obj.get("accountStatus"),
            "subAccountType": obj.get("subAccountType"),
            "accountClassification": obj.get("accountClassification"),
            "connectionId": obj.get("connectionId"),
            "userId": obj.get("userId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "accountCreatedAt": obj.get("accountCreatedAt"),
            "accountUpdatedAt": obj.get("accountUpdatedAt"),
            "accountFirstTradeAt": obj.get("accountFirstTradeAt"),
            "lastSyncedAt": obj.get("lastSyncedAt"),
            "balancesSyncedAt": obj.get("balancesSyncedAt"),
            "ordersSyncedAt": obj.get("ordersSyncedAt"),
            "positionsSyncedAt": obj.get("positionsSyncedAt")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


