# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .ninja_trader_limit_order_modify_query_params import NinjaTraderLimitOrderModifyQueryParams
from .ninja_trader_market_order_modify_query_params import NinjaTraderMarketOrderModifyQueryParams
from .ninja_trader_stop_order_modify_query_params import NinjaTraderStopOrderModifyQueryParams
from .ninja_trader_trailing_stop_order_modify_query_params import NinjaTraderTrailingStopOrderModifyQueryParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDER3_ONE_OF_SCHEMAS = ["NinjaTraderLimitOrderModifyQueryParams", "NinjaTraderMarketOrderModifyQueryParams", "NinjaTraderStopOrderModifyQueryParams", "NinjaTraderTrailingStopOrderModifyQueryParams"]

class Order3(BaseModel):
    """
    Order3
    """
    # data type: NinjaTraderMarketOrderModifyQueryParams
    oneof_schema_1_validator: Optional[NinjaTraderMarketOrderModifyQueryParams] = None
    # data type: NinjaTraderLimitOrderModifyQueryParams
    oneof_schema_2_validator: Optional[NinjaTraderLimitOrderModifyQueryParams] = None
    # data type: NinjaTraderStopOrderModifyQueryParams
    oneof_schema_3_validator: Optional[NinjaTraderStopOrderModifyQueryParams] = None
    # data type: NinjaTraderTrailingStopOrderModifyQueryParams
    oneof_schema_4_validator: Optional[NinjaTraderTrailingStopOrderModifyQueryParams] = None
    actual_instance: Optional[Union[NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams]] = None
    one_of_schemas: Set[str] = { "NinjaTraderLimitOrderModifyQueryParams", "NinjaTraderMarketOrderModifyQueryParams", "NinjaTraderStopOrderModifyQueryParams", "NinjaTraderTrailingStopOrderModifyQueryParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Order3.model_construct()
        error_messages = []
        match = 0
        # validate data type: NinjaTraderMarketOrderModifyQueryParams
        if not isinstance(v, NinjaTraderMarketOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NinjaTraderMarketOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: NinjaTraderLimitOrderModifyQueryParams
        if not isinstance(v, NinjaTraderLimitOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NinjaTraderLimitOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: NinjaTraderStopOrderModifyQueryParams
        if not isinstance(v, NinjaTraderStopOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NinjaTraderStopOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: NinjaTraderTrailingStopOrderModifyQueryParams
        if not isinstance(v, NinjaTraderTrailingStopOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NinjaTraderTrailingStopOrderModifyQueryParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Order3 with oneOf schemas: NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Order3 with oneOf schemas: NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("orderType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `orderType` in the input.")

        # check if data type is `NinjaTraderLimitOrderModifyQueryParams`
        if _data_type == "limit":
            instance.actual_instance = NinjaTraderLimitOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `NinjaTraderMarketOrderModifyQueryParams`
        if _data_type == "market":
            instance.actual_instance = NinjaTraderMarketOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `NinjaTraderStopOrderModifyQueryParams`
        if _data_type == "stop":
            instance.actual_instance = NinjaTraderStopOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `NinjaTraderTrailingStopOrderModifyQueryParams`
        if _data_type == "trailing_stop":
            instance.actual_instance = NinjaTraderTrailingStopOrderModifyQueryParams.from_json(json_str)
            return instance

        # deserialize data into NinjaTraderMarketOrderModifyQueryParams
        try:
            instance.actual_instance = NinjaTraderMarketOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NinjaTraderLimitOrderModifyQueryParams
        try:
            instance.actual_instance = NinjaTraderLimitOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NinjaTraderStopOrderModifyQueryParams
        try:
            instance.actual_instance = NinjaTraderStopOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into NinjaTraderTrailingStopOrderModifyQueryParams
        try:
            instance.actual_instance = NinjaTraderTrailingStopOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Order3 with oneOf schemas: NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order3 with oneOf schemas: NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], NinjaTraderLimitOrderModifyQueryParams, NinjaTraderMarketOrderModifyQueryParams, NinjaTraderStopOrderModifyQueryParams, NinjaTraderTrailingStopOrderModifyQueryParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


