# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .tasty_trade_limit_order_modify_query_params import TastyTradeLimitOrderModifyQueryParams
from .tasty_trade_market_order_modify_query_params import TastyTradeMarketOrderModifyQueryParams
from .tasty_trade_stop_order_modify_query_params import TastyTradeStopOrderModifyQueryParams
from .tasty_trade_trailing_stop_order_modify_query_params import TastyTradeTrailingStopOrderModifyQueryParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDER4_ONE_OF_SCHEMAS = ["TastyTradeLimitOrderModifyQueryParams", "TastyTradeMarketOrderModifyQueryParams", "TastyTradeStopOrderModifyQueryParams", "TastyTradeTrailingStopOrderModifyQueryParams"]

class Order4(BaseModel):
    """
    Order4
    """
    # data type: TastyTradeMarketOrderModifyQueryParams
    oneof_schema_1_validator: Optional[TastyTradeMarketOrderModifyQueryParams] = None
    # data type: TastyTradeLimitOrderModifyQueryParams
    oneof_schema_2_validator: Optional[TastyTradeLimitOrderModifyQueryParams] = None
    # data type: TastyTradeStopOrderModifyQueryParams
    oneof_schema_3_validator: Optional[TastyTradeStopOrderModifyQueryParams] = None
    # data type: TastyTradeTrailingStopOrderModifyQueryParams
    oneof_schema_4_validator: Optional[TastyTradeTrailingStopOrderModifyQueryParams] = None
    actual_instance: Optional[Union[TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams]] = None
    one_of_schemas: Set[str] = { "TastyTradeLimitOrderModifyQueryParams", "TastyTradeMarketOrderModifyQueryParams", "TastyTradeStopOrderModifyQueryParams", "TastyTradeTrailingStopOrderModifyQueryParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Order4.model_construct()
        error_messages = []
        match = 0
        # validate data type: TastyTradeMarketOrderModifyQueryParams
        if not isinstance(v, TastyTradeMarketOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TastyTradeMarketOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: TastyTradeLimitOrderModifyQueryParams
        if not isinstance(v, TastyTradeLimitOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TastyTradeLimitOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: TastyTradeStopOrderModifyQueryParams
        if not isinstance(v, TastyTradeStopOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TastyTradeStopOrderModifyQueryParams`")
        else:
            match += 1
        # validate data type: TastyTradeTrailingStopOrderModifyQueryParams
        if not isinstance(v, TastyTradeTrailingStopOrderModifyQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TastyTradeTrailingStopOrderModifyQueryParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Order4 with oneOf schemas: TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Order4 with oneOf schemas: TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("orderType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `orderType` in the input.")

        # check if data type is `TastyTradeLimitOrderModifyQueryParams`
        if _data_type == "limit":
            instance.actual_instance = TastyTradeLimitOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `TastyTradeMarketOrderModifyQueryParams`
        if _data_type == "market":
            instance.actual_instance = TastyTradeMarketOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `TastyTradeStopOrderModifyQueryParams`
        if _data_type == "stop":
            instance.actual_instance = TastyTradeStopOrderModifyQueryParams.from_json(json_str)
            return instance

        # check if data type is `TastyTradeTrailingStopOrderModifyQueryParams`
        if _data_type == "trailing_stop":
            instance.actual_instance = TastyTradeTrailingStopOrderModifyQueryParams.from_json(json_str)
            return instance

        # deserialize data into TastyTradeMarketOrderModifyQueryParams
        try:
            instance.actual_instance = TastyTradeMarketOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TastyTradeLimitOrderModifyQueryParams
        try:
            instance.actual_instance = TastyTradeLimitOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TastyTradeStopOrderModifyQueryParams
        try:
            instance.actual_instance = TastyTradeStopOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TastyTradeTrailingStopOrderModifyQueryParams
        try:
            instance.actual_instance = TastyTradeTrailingStopOrderModifyQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Order4 with oneOf schemas: TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order4 with oneOf schemas: TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TastyTradeLimitOrderModifyQueryParams, TastyTradeMarketOrderModifyQueryParams, TastyTradeStopOrderModifyQueryParams, TastyTradeTrailingStopOrderModifyQueryParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


