# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OrderActionResult(BaseModel):
    """
    Result model for order action endpoints (place, cancel, modify).  This model represents the outcome of broker order operations including placing, canceling, and modifying orders. Used by POST /orders, DELETE /orders/{order_id}, and PUT /orders/{order_id} endpoints to return operation status and relevant order identifiers.  The model provides a consistent response structure across all order action types, allowing clients to handle success and failure cases uniformly.  Attributes ---------- success : bool     Whether the order action completed successfully. True if the operation     was accepted and processed, False if an error occurred or the operation     was rejected. message : str | None     Human-readable message describing the result of the order action. Contains     success confirmation, error details, or status information. None if no     message is provided. order_id : str | None     Broker-assigned order identifier if the operation created or referenced     a specific order. Format depends on the broker (e.g., numeric string for     some brokers, UUID for others). None if no order ID is applicable or     available.  Notes ----- 1. **Order ID Format**: The order_id format varies by broker. Some brokers    use numeric strings, others use UUIDs or custom identifiers.  2. **Partial Success**: Some operations may return success=True even if the    order was not immediately executed (e.g., pending orders). Check the message    field for detailed status.  3. **Error Handling**: When success is False, the message field contains    error details. The order_id may still be present if the broker assigned    an ID before rejecting the order.  Examples -------- >>> # Successful order placement >>> result = OrderActionResult( ...     success=True, ...     message=\"Order placed successfully\", ...     order_id=\"12345678\", ... ) >>> # Failed order cancellation >>> result = OrderActionResult( ...     success=False, ...     message=\"Order not found or already filled\", ...     order_id=None, ... ) >>> # Order modification with partial information >>> result = OrderActionResult( ...     success=True, ...     message=\"Order modification submitted\", ...     order_id=\"87654321\", ... )  See Also -------- finaticapi.api.v1.routers.brokers.brokers_router.place_order : Endpoint for placing orders finaticapi.api.v1.routers.brokers.brokers_router.cancel_order : Endpoint for canceling orders finaticapi.api.v1.routers.brokers.brokers_router.modify_order : Endpoint for modifying orders finaticapi.core.services.broker_service.BrokerService     : Service methods that perform order operations
    """ # noqa: E501
    success: StrictBool
    message: Optional[StrictStr] = None
    order_id: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["success", "message", "order_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderActionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        # set to None if order_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_id is None and "order_id" in self.model_fields_set:
            _dict['order_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderActionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "message": obj.get("message"),
            "order_id": obj.get("order_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


