# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr
from typing import Any, Optional
from typing_extensions import Annotated
from uuid import UUID
from ..models.finatic_response_disconnect_company_from_broker_connection_result import FinaticResponseDisconnectCompanyFromBrokerConnectionResult
from ..models.finatic_response_list_broker_info import FinaticResponseListBrokerInfo
from ..models.finatic_response_list_fdx_broker_order import FinaticResponseListFDXBrokerOrder
from ..models.finatic_response_list_fdx_broker_order_event import FinaticResponseListFDXBrokerOrderEvent
from ..models.finatic_response_list_fdx_broker_order_fill import FinaticResponseListFDXBrokerOrderFill
from ..models.finatic_response_list_fdx_broker_order_group import FinaticResponseListFDXBrokerOrderGroup
from ..models.finatic_response_list_fdx_broker_position import FinaticResponseListFDXBrokerPosition
from ..models.finatic_response_list_fdx_broker_position_lot import FinaticResponseListFDXBrokerPositionLot
from ..models.finatic_response_list_fdx_broker_position_lot_fill import FinaticResponseListFDXBrokerPositionLotFill
from ..models.finatic_response_list_fdx_broker_transaction import FinaticResponseListFDXBrokerTransaction
from ..models.finatic_response_list_legacy_broker_account import FinaticResponseListLegacyBrokerAccount
from ..models.finatic_response_list_legacy_broker_balance import FinaticResponseListLegacyBrokerBalance
from ..models.finatic_response_list_user_broker_connection_with_permissions import FinaticResponseListUserBrokerConnectionWithPermissions
from ..models.finatic_response_order_action_result import FinaticResponseOrderActionResult
from ..models.modify_order_api_beta_brokers_orders_order_id_patch_request import ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest
from ..models.place_order_api_beta_brokers_orders_post_request import PlaceOrderApiBetaBrokersOrdersPostRequest

from ..api_client import ApiClient, RequestSerialized
from ..api_response import ApiResponse
from ..rest import RESTResponseType


class BrokersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def cancel_order_api_beta_brokers_orders_order_id_delete(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseOrderActionResult:
        """Cancel Order

        Cancel an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  The order_id is used to identify the order and automatically resolve the broker connection from the orders table.

        :param order_id: Order ID (required)
        :type order_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_order_api_beta_brokers_orders_order_id_delete_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def cancel_order_api_beta_brokers_orders_order_id_delete_with_http_info(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseOrderActionResult]:
        """Cancel Order

        Cancel an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  The order_id is used to identify the order and automatically resolve the broker connection from the orders table.

        :param order_id: Order ID (required)
        :type order_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_order_api_beta_brokers_orders_order_id_delete_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def cancel_order_api_beta_brokers_orders_order_id_delete_without_preload_content(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Cancel Order

        Cancel an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  The order_id is used to identify the order and automatically resolve the broker connection from the orders table.

        :param order_id: Order ID (required)
        :type order_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_order_api_beta_brokers_orders_order_id_delete_serialize(
            order_id=order_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _cancel_order_api_beta_brokers_orders_order_id_delete_serialize(
        self,
        order_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/beta/brokers/orders/{order_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseDisconnectCompanyFromBrokerConnectionResult:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: UUID
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectCompanyFromBrokerConnectionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_with_http_info(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseDisconnectCompanyFromBrokerConnectionResult]:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: UUID
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectCompanyFromBrokerConnectionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_without_preload_content(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: UUID
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectCompanyFromBrokerConnectionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _disconnect_company_from_broker_api_beta_brokers_disconnect_company_connection_id_delete_serialize(
        self,
        connection_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if connection_id is not None:
            _path_params['connection_id'] = connection_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/beta/brokers/disconnect-company/{connection_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_accounts_api_beta_brokers_data_accounts_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[Any], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListLegacyBrokerAccount:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param include_metadata: Include connection metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_beta_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerAccount",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_accounts_api_beta_brokers_data_accounts_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[Any], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListLegacyBrokerAccount]:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param include_metadata: Include connection metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_beta_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerAccount",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_accounts_api_beta_brokers_data_accounts_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[Any], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param include_metadata: Include connection metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_beta_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerAccount",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_accounts_api_beta_brokers_data_accounts_get_serialize(
        self,
        broker_id,
        connection_id,
        account_type,
        currency,
        limit,
        offset,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_type is not None:
            
            _query_params.append(('account_type', account_type.value))
            
        if currency is not None:
            
            _query_params.append(('currency', currency))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/accounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_balances_api_beta_brokers_data_balances_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListLegacyBrokerBalance:
        """Get Balances

        Get current unit-based balances for all authorized broker connections.  Returns array of current balances (one per unit_code per account). This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param include_metadata: Include balance metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_beta_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerBalance",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_balances_api_beta_brokers_data_balances_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListLegacyBrokerBalance]:
        """Get Balances

        Get current unit-based balances for all authorized broker connections.  Returns array of current balances (one per unit_code per account). This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param include_metadata: Include balance metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_beta_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerBalance",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_balances_api_beta_brokers_data_balances_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Balances

        Get current unit-based balances for all authorized broker connections.  Returns array of current balances (one per unit_code per account). This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param include_metadata: Include balance metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_beta_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListLegacyBrokerBalance",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_balances_api_beta_brokers_data_balances_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        unit_code,
        currency,
        limit,
        offset,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if unit_code is not None:
            
            _query_params.append(('unit_code', unit_code))
            
        if currency is not None:
            
            _query_params.append(('currency', currency))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/balances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_brokers_api_beta_brokers_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListBrokerInfo:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_beta_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_brokers_api_beta_brokers_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListBrokerInfo]:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_beta_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_brokers_api_beta_brokers_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_beta_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_brokers_api_beta_brokers_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_events_api_beta_brokers_data_orders_order_id_events_get(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include event metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerOrderEvent:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param include_metadata: Include event metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_beta_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderEvent",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_events_api_beta_brokers_data_orders_order_id_events_get_with_http_info(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include event metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerOrderEvent]:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param include_metadata: Include event metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_beta_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderEvent",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_events_api_beta_brokers_data_orders_order_id_events_get_without_preload_content(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include event metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param include_metadata: Include event metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_beta_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderEvent",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_events_api_beta_brokers_data_orders_order_id_events_get_serialize(
        self,
        order_id,
        connection_id,
        limit,
        offset,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/orders/{order_id}/events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_fills_api_beta_brokers_data_orders_order_id_fills_get(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include fill metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerOrderFill:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param include_metadata: Include fill metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_with_http_info(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include fill metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerOrderFill]:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param include_metadata: Include fill metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_without_preload_content(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include fill metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param include_metadata: Include fill metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_fills_api_beta_brokers_data_orders_order_id_fills_get_serialize(
        self,
        order_id,
        connection_id,
        limit,
        offset,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/orders/{order_id}/fills',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_groups_api_beta_brokers_data_orders_groups_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include group metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerOrderGroup:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include group metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_beta_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderGroup",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_groups_api_beta_brokers_data_orders_groups_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include group metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerOrderGroup]:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include group metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_beta_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderGroup",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_groups_api_beta_brokers_data_orders_groups_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include group metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include group metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_beta_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrderGroup",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_groups_api_beta_brokers_data_orders_groups_get_serialize(
        self,
        broker_id,
        connection_id,
        limit,
        offset,
        created_after,
        created_before,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'created_after',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_after', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'created_before',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_before', created_before))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/orders/groups',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_orders_api_beta_brokers_data_orders_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[StrictStr], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerOrder:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: str
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include order metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_beta_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrder",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_orders_api_beta_brokers_data_orders_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[StrictStr], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerOrder]:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: str
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include order metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_beta_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrder",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_orders_api_beta_brokers_data_orders_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[StrictStr], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: str
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param include_metadata: Include order metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_beta_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerOrder",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_orders_api_beta_brokers_data_orders_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        order_status,
        side,
        asset_type,
        limit,
        offset,
        created_after,
        created_before,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if order_status is not None:
            
            _query_params.append(('order_status', order_status))
            
        if side is not None:
            
            _query_params.append(('side', side.value))
            
        if asset_type is not None:
            
            _query_params.append(('asset_type', asset_type.value))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'created_after',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_after', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'created_before',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_before', created_before))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerPositionLotFill:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLotFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_with_http_info(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerPositionLotFill]:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLotFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_without_preload_content(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: UUID
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLotFill",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_position_lot_fills_api_beta_brokers_data_positions_lots_lot_id_fills_get_serialize(
        self,
        lot_id,
        connection_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if lot_id is not None:
            _path_params['lot_id'] = lot_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/positions/lots/{lot_id}/fills',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_position_lots_api_beta_brokers_data_positions_lots_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerPositionLot:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: UUID
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_beta_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLot",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_position_lots_api_beta_brokers_data_positions_lots_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerPositionLot]:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: UUID
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_beta_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLot",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_position_lots_api_beta_brokers_data_positions_lots_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: UUID
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_beta_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPositionLot",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_position_lots_api_beta_brokers_data_positions_lots_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        position_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if position_id is not None:
            
            _query_params.append(('position_id', position_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/positions/lots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_positions_api_beta_brokers_data_positions_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[Any], Field(description="Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerPosition:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param include_metadata: Include position metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_beta_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPosition",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_positions_api_beta_brokers_data_positions_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[Any], Field(description="Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerPosition]:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param include_metadata: Include position metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_beta_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPosition",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_positions_api_beta_brokers_data_positions_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[Any], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[Any], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[Any], Field(description="Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response (excluded by default for FDX compliance)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'active' (open positions) or 'closed' (closed positions). Use 'all' or omit to get both.
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param include_metadata: Include position metadata in response (excluded by default for FDX compliance)
        :type include_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_beta_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            include_metadata=include_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerPosition",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_positions_api_beta_brokers_data_positions_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        side,
        asset_type,
        position_status,
        limit,
        offset,
        updated_after,
        updated_before,
        include_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if side is not None:
            
            _query_params.append(('side', side.value))
            
        if asset_type is not None:
            
            _query_params.append(('asset_type', asset_type.value))
            
        if position_status is not None:
            
            _query_params.append(('position_status', position_status.value))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if updated_after is not None:
            if isinstance(updated_after, datetime):
                _query_params.append(
                    (
                        'updated_after',
                        updated_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_after', updated_after))
            
        if updated_before is not None:
            if isinstance(updated_before, datetime):
                _query_params.append(
                    (
                        'updated_before',
                        updated_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_before', updated_before))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/positions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_transactions_api_beta_brokers_data_transactions_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        transaction_type: Annotated[Optional[StrictStr], Field(description="Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Filter transactions from this date (ISO 8601)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="Filter transactions until this date (ISO 8601)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of transactions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of transactions to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListFDXBrokerTransaction:
        """Get Transactions

        Get transactions for all authorized broker connections.  Returns transactions from connections the company has read access to. This endpoint is accessible from the portal and uses session-only authentication.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param transaction_type: Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')
        :type transaction_type: str
        :param start_date: Filter transactions from this date (ISO 8601)
        :type start_date: datetime
        :param end_date: Filter transactions until this date (ISO 8601)
        :type end_date: datetime
        :param limit: Maximum number of transactions to return
        :type limit: int
        :param offset: Number of transactions to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transactions_api_beta_brokers_data_transactions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            transaction_type=transaction_type,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerTransaction",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_transactions_api_beta_brokers_data_transactions_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        transaction_type: Annotated[Optional[StrictStr], Field(description="Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Filter transactions from this date (ISO 8601)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="Filter transactions until this date (ISO 8601)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of transactions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of transactions to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListFDXBrokerTransaction]:
        """Get Transactions

        Get transactions for all authorized broker connections.  Returns transactions from connections the company has read access to. This endpoint is accessible from the portal and uses session-only authentication.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param transaction_type: Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')
        :type transaction_type: str
        :param start_date: Filter transactions from this date (ISO 8601)
        :type start_date: datetime
        :param end_date: Filter transactions until this date (ISO 8601)
        :type end_date: datetime
        :param limit: Maximum number of transactions to return
        :type limit: int
        :param offset: Number of transactions to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transactions_api_beta_brokers_data_transactions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            transaction_type=transaction_type,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerTransaction",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_transactions_api_beta_brokers_data_transactions_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID or internal account UUID")] = None,
        unit_code: Annotated[Optional[StrictStr], Field(description="Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')")] = None,
        transaction_type: Annotated[Optional[StrictStr], Field(description="Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Filter transactions from this date (ISO 8601)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="Filter transactions until this date (ISO 8601)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of transactions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of transactions to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Transactions

        Get transactions for all authorized broker connections.  Returns transactions from connections the company has read access to. This endpoint is accessible from the portal and uses session-only authentication.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: UUID
        :param account_id: Filter by broker provided account ID or internal account UUID
        :type account_id: str
        :param unit_code: Filter by unit code (preferred, e.g., 'USD', 'BTC', 'ETH')
        :type unit_code: str
        :param currency: Filter by currency (for FDX fiat filtering only, e.g., 'USD', 'EUR')
        :type currency: str
        :param transaction_type: Filter by transaction type (e.g., 'DEPOSIT', 'WITHDRAWAL', 'DIVIDEND')
        :type transaction_type: str
        :param start_date: Filter transactions from this date (ISO 8601)
        :type start_date: datetime
        :param end_date: Filter transactions until this date (ISO 8601)
        :type end_date: datetime
        :param limit: Maximum number of transactions to return
        :type limit: int
        :param offset: Number of transactions to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transactions_api_beta_brokers_data_transactions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            unit_code=unit_code,
            currency=currency,
            transaction_type=transaction_type,
            start_date=start_date,
            end_date=end_date,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListFDXBrokerTransaction",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_transactions_api_beta_brokers_data_transactions_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        unit_code,
        currency,
        transaction_type,
        start_date,
        end_date,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if unit_code is not None:
            
            _query_params.append(('unit_code', unit_code))
            
        if currency is not None:
            
            _query_params.append(('currency', currency))
            
        if transaction_type is not None:
            
            _query_params.append(('transaction_type', transaction_type))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'start_date',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('start_date', start_date))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'end_date',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('end_date', end_date))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/data/transactions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_broker_connections_api_beta_brokers_connections_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListUserBrokerConnectionWithPermissions:
        """List Broker Connections

        List all broker connections for the current user with permissions.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for, including the current company's permissions (read/write) for each connection.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_beta_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnectionWithPermissions",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_broker_connections_api_beta_brokers_connections_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListUserBrokerConnectionWithPermissions]:
        """List Broker Connections

        List all broker connections for the current user with permissions.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for, including the current company's permissions (read/write) for each connection.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_beta_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnectionWithPermissions",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_broker_connections_api_beta_brokers_connections_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Broker Connections

        List all broker connections for the current user with permissions.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for, including the current company's permissions (read/write) for each connection.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_beta_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnectionWithPermissions",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_broker_connections_api_beta_brokers_connections_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/beta/brokers/connections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def modify_order_api_beta_brokers_orders_order_id_patch(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        account_number: Annotated[Optional[StrictStr], Field(description="Account number owning the order")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        modify_order_api_beta_brokers_orders_order_id_patch_request: Optional[ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseOrderActionResult:
        """Modify Order

        Modify an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.

        :param order_id: Order ID (required)
        :type order_id: str
        :param account_number: Account number owning the order
        :type account_number: str
        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param modify_order_api_beta_brokers_orders_order_id_patch_request:
        :type modify_order_api_beta_brokers_orders_order_id_patch_request: ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._modify_order_api_beta_brokers_orders_order_id_patch_serialize(
            order_id=order_id,
            account_number=account_number,
            connection_id=connection_id,
            modify_order_api_beta_brokers_orders_order_id_patch_request=modify_order_api_beta_brokers_orders_order_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def modify_order_api_beta_brokers_orders_order_id_patch_with_http_info(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        account_number: Annotated[Optional[StrictStr], Field(description="Account number owning the order")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        modify_order_api_beta_brokers_orders_order_id_patch_request: Optional[ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseOrderActionResult]:
        """Modify Order

        Modify an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.

        :param order_id: Order ID (required)
        :type order_id: str
        :param account_number: Account number owning the order
        :type account_number: str
        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param modify_order_api_beta_brokers_orders_order_id_patch_request:
        :type modify_order_api_beta_brokers_orders_order_id_patch_request: ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._modify_order_api_beta_brokers_orders_order_id_patch_serialize(
            order_id=order_id,
            account_number=account_number,
            connection_id=connection_id,
            modify_order_api_beta_brokers_orders_order_id_patch_request=modify_order_api_beta_brokers_orders_order_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def modify_order_api_beta_brokers_orders_order_id_patch_without_preload_content(
        self,
        order_id: Annotated[StrictStr, Field(description="Order ID")],
        account_number: Annotated[Optional[StrictStr], Field(description="Account number owning the order")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        modify_order_api_beta_brokers_orders_order_id_patch_request: Optional[ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Modify Order

        Modify an existing order.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.

        :param order_id: Order ID (required)
        :type order_id: str
        :param account_number: Account number owning the order
        :type account_number: str
        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param modify_order_api_beta_brokers_orders_order_id_patch_request:
        :type modify_order_api_beta_brokers_orders_order_id_patch_request: ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._modify_order_api_beta_brokers_orders_order_id_patch_serialize(
            order_id=order_id,
            account_number=account_number,
            connection_id=connection_id,
            modify_order_api_beta_brokers_orders_order_id_patch_request=modify_order_api_beta_brokers_orders_order_id_patch_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _modify_order_api_beta_brokers_orders_order_id_patch_serialize(
        self,
        order_id,
        account_number,
        connection_id,
        modify_order_api_beta_brokers_orders_order_id_patch_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        if account_number is not None:
            
            _query_params.append(('account_number', account_number))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if modify_order_api_beta_brokers_orders_order_id_patch_request is not None:
            _body_params = modify_order_api_beta_brokers_orders_order_id_patch_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/beta/brokers/orders/{order_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def place_order_api_beta_brokers_orders_post(
        self,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        place_order_api_beta_brokers_orders_post_request: Optional[PlaceOrderApiBetaBrokersOrdersPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseOrderActionResult:
        """Place Order

        Create a new order via the specified broker connection.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  Standard parameters ------------------- The following fields constitute the unified Finatic *common order schema* and therefore appear individually as query parameters in the autogenerated OpenAPI documentation:  - ``broker`` - ``account_number`` - ``order_type`` - ``asset_type`` - ``action`` - ``time_in_force`` - ``symbol`` - ``order_qty``  They are surfaced as *query* parameters **only to make the accepted fields obvious in the interactive docs**. In production usage you should send these fields inside the JSON body (see ``order_request``) so that the entire order specification travels in one payload. (Nothing will break if you send both, but there is no need to do so.)  Body payload & broker-specific extras -------------------------------------  Put the standard parameters plus any broker-specific extensions under the ``order`` key of the body. Refer to the bundled OpenAPI examples below to see complete payloads for common order types (market, limit, spreads, etc.) across supported brokers.  For a formal reference of broker-specific extensions inspect the ``BrokerOrderPlaceExtras`` schema.  The endpoint resolves the active ``user_broker_connection`` by calling the ``get_user_broker_connection_ids_for_broker`` RPC in Supabase. If no active connection exists it returns a list of *available* brokers so your client can guide the user accordingly.  Broker Notes ------------ - The responses that you get back from the broker are not always the same. The response models are validated for each broker, but we do not standardize the repsonses.  - Tasty Trade: If you want to trade options for a particular stock, first fetch the full option chain via the GET https://api.tastyworks.com/option-chains/{stock_symbol}/nested endpoint. This endpoint returns all available expirations that tastytrade offers for that equity symbol. Each expiration contains a list of strikes, where each strike has a call and put field representing the call symbol and put symbol respectively.  We are planning to add a new endpoint to fetch the option chain for a particular stock and handle this logic for you, but for now you need to fetch the option chain manually.

        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param place_order_api_beta_brokers_orders_post_request:
        :type place_order_api_beta_brokers_orders_post_request: PlaceOrderApiBetaBrokersOrdersPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_api_beta_brokers_orders_post_serialize(
            connection_id=connection_id,
            place_order_api_beta_brokers_orders_post_request=place_order_api_beta_brokers_orders_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def place_order_api_beta_brokers_orders_post_with_http_info(
        self,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        place_order_api_beta_brokers_orders_post_request: Optional[PlaceOrderApiBetaBrokersOrdersPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseOrderActionResult]:
        """Place Order

        Create a new order via the specified broker connection.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  Standard parameters ------------------- The following fields constitute the unified Finatic *common order schema* and therefore appear individually as query parameters in the autogenerated OpenAPI documentation:  - ``broker`` - ``account_number`` - ``order_type`` - ``asset_type`` - ``action`` - ``time_in_force`` - ``symbol`` - ``order_qty``  They are surfaced as *query* parameters **only to make the accepted fields obvious in the interactive docs**. In production usage you should send these fields inside the JSON body (see ``order_request``) so that the entire order specification travels in one payload. (Nothing will break if you send both, but there is no need to do so.)  Body payload & broker-specific extras -------------------------------------  Put the standard parameters plus any broker-specific extensions under the ``order`` key of the body. Refer to the bundled OpenAPI examples below to see complete payloads for common order types (market, limit, spreads, etc.) across supported brokers.  For a formal reference of broker-specific extensions inspect the ``BrokerOrderPlaceExtras`` schema.  The endpoint resolves the active ``user_broker_connection`` by calling the ``get_user_broker_connection_ids_for_broker`` RPC in Supabase. If no active connection exists it returns a list of *available* brokers so your client can guide the user accordingly.  Broker Notes ------------ - The responses that you get back from the broker are not always the same. The response models are validated for each broker, but we do not standardize the repsonses.  - Tasty Trade: If you want to trade options for a particular stock, first fetch the full option chain via the GET https://api.tastyworks.com/option-chains/{stock_symbol}/nested endpoint. This endpoint returns all available expirations that tastytrade offers for that equity symbol. Each expiration contains a list of strikes, where each strike has a call and put field representing the call symbol and put symbol respectively.  We are planning to add a new endpoint to fetch the option chain for a particular stock and handle this logic for you, but for now you need to fetch the option chain manually.

        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param place_order_api_beta_brokers_orders_post_request:
        :type place_order_api_beta_brokers_orders_post_request: PlaceOrderApiBetaBrokersOrdersPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_api_beta_brokers_orders_post_serialize(
            connection_id=connection_id,
            place_order_api_beta_brokers_orders_post_request=place_order_api_beta_brokers_orders_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def place_order_api_beta_brokers_orders_post_without_preload_content(
        self,
        connection_id: Annotated[Optional[UUID], Field(description="Temporary bypass for testing: specify connection ID directly")] = None,
        place_order_api_beta_brokers_orders_post_request: Optional[PlaceOrderApiBetaBrokersOrdersPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Place Order

        Create a new order via the specified broker connection.  This endpoint is accessible from the portal and uses session-only authentication. Requires trading permissions for the company.  Standard parameters ------------------- The following fields constitute the unified Finatic *common order schema* and therefore appear individually as query parameters in the autogenerated OpenAPI documentation:  - ``broker`` - ``account_number`` - ``order_type`` - ``asset_type`` - ``action`` - ``time_in_force`` - ``symbol`` - ``order_qty``  They are surfaced as *query* parameters **only to make the accepted fields obvious in the interactive docs**. In production usage you should send these fields inside the JSON body (see ``order_request``) so that the entire order specification travels in one payload. (Nothing will break if you send both, but there is no need to do so.)  Body payload & broker-specific extras -------------------------------------  Put the standard parameters plus any broker-specific extensions under the ``order`` key of the body. Refer to the bundled OpenAPI examples below to see complete payloads for common order types (market, limit, spreads, etc.) across supported brokers.  For a formal reference of broker-specific extensions inspect the ``BrokerOrderPlaceExtras`` schema.  The endpoint resolves the active ``user_broker_connection`` by calling the ``get_user_broker_connection_ids_for_broker`` RPC in Supabase. If no active connection exists it returns a list of *available* brokers so your client can guide the user accordingly.  Broker Notes ------------ - The responses that you get back from the broker are not always the same. The response models are validated for each broker, but we do not standardize the repsonses.  - Tasty Trade: If you want to trade options for a particular stock, first fetch the full option chain via the GET https://api.tastyworks.com/option-chains/{stock_symbol}/nested endpoint. This endpoint returns all available expirations that tastytrade offers for that equity symbol. Each expiration contains a list of strikes, where each strike has a call and put field representing the call symbol and put symbol respectively.  We are planning to add a new endpoint to fetch the option chain for a particular stock and handle this logic for you, but for now you need to fetch the option chain manually.

        :param connection_id: Temporary bypass for testing: specify connection ID directly
        :type connection_id: UUID
        :param place_order_api_beta_brokers_orders_post_request:
        :type place_order_api_beta_brokers_orders_post_request: PlaceOrderApiBetaBrokersOrdersPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._place_order_api_beta_brokers_orders_post_serialize(
            connection_id=connection_id,
            place_order_api_beta_brokers_orders_post_request=place_order_api_beta_brokers_orders_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseOrderActionResult",
            '400': "FinaticAPIErrorResponse",
            '401': "FinaticAPIErrorResponse",
            '403': "FinaticAPIErrorResponse",
            '404': "FinaticAPIErrorResponse",
            '409': "FinaticAPIErrorResponse",
            '422': "FinaticAPIErrorResponse",
            '429': "FinaticAPIErrorResponse",
            '500': "FinaticAPIErrorResponse",
            '502': "FinaticAPIErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _place_order_api_beta_brokers_orders_post_serialize(
        self,
        connection_id,
        place_order_api_beta_brokers_orders_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if place_order_api_beta_brokers_orders_post_request is not None:
            _body_params = place_order_api_beta_brokers_orders_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/beta/brokers/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


