# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class Accounts(BaseModel):
    """
    Accounts
    """ # noqa: E501
    id: Optional[UUID] = None
    api_key_created_at: Optional[datetime] = None
    api_key_expires_at: Optional[datetime] = None
    api_key_hash: Optional[StrictStr] = None
    api_key_last_used_at: Optional[datetime] = None
    compliance_agreement: Optional[StrictBool] = None
    created_at: Optional[datetime]
    created_by: Optional[UUID] = None
    email: Optional[StrictStr] = None
    is_personal_account: StrictBool
    name: StrictStr
    onboarding_completed: Optional[StrictBool] = None
    onboarding_step: Optional[StrictInt] = None
    picture_url: Optional[StrictStr] = None
    primary_owner_user_id: UUID
    public_data: Optional[Any]
    referral_source: Optional[StrictStr] = None
    sandbox_api_key_hash: Optional[StrictStr] = None
    sandbox_key_created_at: Optional[datetime] = None
    sandbox_key_expires_at: Optional[datetime] = None
    sandbox_key_last_used_at: Optional[datetime] = None
    slug: Optional[StrictStr] = None
    terms_accepted_at: Optional[datetime] = None
    trading_enabled: Optional[StrictBool] = None
    trading_usage_description: Optional[StrictStr] = None
    updated_at: Optional[datetime]
    updated_by: Optional[UUID] = None
    use_case_features: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "api_key_created_at", "api_key_expires_at", "api_key_hash", "api_key_last_used_at", "compliance_agreement", "created_at", "created_by", "email", "is_personal_account", "name", "onboarding_completed", "onboarding_step", "picture_url", "primary_owner_user_id", "public_data", "referral_source", "sandbox_api_key_hash", "sandbox_key_created_at", "sandbox_key_expires_at", "sandbox_key_last_used_at", "slug", "terms_accepted_at", "trading_enabled", "trading_usage_description", "updated_at", "updated_by", "use_case_features"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Accounts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if api_key_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.api_key_created_at is None and "api_key_created_at" in self.model_fields_set:
            _dict['api_key_created_at'] = None

        # set to None if api_key_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.api_key_expires_at is None and "api_key_expires_at" in self.model_fields_set:
            _dict['api_key_expires_at'] = None

        # set to None if api_key_hash (nullable) is None
        # and model_fields_set contains the field
        if self.api_key_hash is None and "api_key_hash" in self.model_fields_set:
            _dict['api_key_hash'] = None

        # set to None if api_key_last_used_at (nullable) is None
        # and model_fields_set contains the field
        if self.api_key_last_used_at is None and "api_key_last_used_at" in self.model_fields_set:
            _dict['api_key_last_used_at'] = None

        # set to None if compliance_agreement (nullable) is None
        # and model_fields_set contains the field
        if self.compliance_agreement is None and "compliance_agreement" in self.model_fields_set:
            _dict['compliance_agreement'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if onboarding_completed (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_completed is None and "onboarding_completed" in self.model_fields_set:
            _dict['onboarding_completed'] = None

        # set to None if onboarding_step (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_step is None and "onboarding_step" in self.model_fields_set:
            _dict['onboarding_step'] = None

        # set to None if picture_url (nullable) is None
        # and model_fields_set contains the field
        if self.picture_url is None and "picture_url" in self.model_fields_set:
            _dict['picture_url'] = None

        # set to None if public_data (nullable) is None
        # and model_fields_set contains the field
        if self.public_data is None and "public_data" in self.model_fields_set:
            _dict['public_data'] = None

        # set to None if referral_source (nullable) is None
        # and model_fields_set contains the field
        if self.referral_source is None and "referral_source" in self.model_fields_set:
            _dict['referral_source'] = None

        # set to None if sandbox_api_key_hash (nullable) is None
        # and model_fields_set contains the field
        if self.sandbox_api_key_hash is None and "sandbox_api_key_hash" in self.model_fields_set:
            _dict['sandbox_api_key_hash'] = None

        # set to None if sandbox_key_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.sandbox_key_created_at is None and "sandbox_key_created_at" in self.model_fields_set:
            _dict['sandbox_key_created_at'] = None

        # set to None if sandbox_key_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.sandbox_key_expires_at is None and "sandbox_key_expires_at" in self.model_fields_set:
            _dict['sandbox_key_expires_at'] = None

        # set to None if sandbox_key_last_used_at (nullable) is None
        # and model_fields_set contains the field
        if self.sandbox_key_last_used_at is None and "sandbox_key_last_used_at" in self.model_fields_set:
            _dict['sandbox_key_last_used_at'] = None

        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if terms_accepted_at (nullable) is None
        # and model_fields_set contains the field
        if self.terms_accepted_at is None and "terms_accepted_at" in self.model_fields_set:
            _dict['terms_accepted_at'] = None

        # set to None if trading_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.trading_enabled is None and "trading_enabled" in self.model_fields_set:
            _dict['trading_enabled'] = None

        # set to None if trading_usage_description (nullable) is None
        # and model_fields_set contains the field
        if self.trading_usage_description is None and "trading_usage_description" in self.model_fields_set:
            _dict['trading_usage_description'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updated_by'] = None

        # set to None if use_case_features (nullable) is None
        # and model_fields_set contains the field
        if self.use_case_features is None and "use_case_features" in self.model_fields_set:
            _dict['use_case_features'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Accounts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "api_key_created_at": obj.get("api_key_created_at"),
            "api_key_expires_at": obj.get("api_key_expires_at"),
            "api_key_hash": obj.get("api_key_hash"),
            "api_key_last_used_at": obj.get("api_key_last_used_at"),
            "compliance_agreement": obj.get("compliance_agreement"),
            "created_at": obj.get("created_at"),
            "created_by": obj.get("created_by"),
            "email": obj.get("email"),
            "is_personal_account": obj.get("is_personal_account"),
            "name": obj.get("name"),
            "onboarding_completed": obj.get("onboarding_completed"),
            "onboarding_step": obj.get("onboarding_step"),
            "picture_url": obj.get("picture_url"),
            "primary_owner_user_id": obj.get("primary_owner_user_id"),
            "public_data": obj.get("public_data"),
            "referral_source": obj.get("referral_source"),
            "sandbox_api_key_hash": obj.get("sandbox_api_key_hash"),
            "sandbox_key_created_at": obj.get("sandbox_key_created_at"),
            "sandbox_key_expires_at": obj.get("sandbox_key_expires_at"),
            "sandbox_key_last_used_at": obj.get("sandbox_key_last_used_at"),
            "slug": obj.get("slug"),
            "terms_accepted_at": obj.get("terms_accepted_at"),
            "trading_enabled": obj.get("trading_enabled"),
            "trading_usage_description": obj.get("trading_usage_description"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by"),
            "use_case_features": obj.get("use_case_features")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


