# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BrokerInfo(BaseModel):
    """
    Model for broker information.  This model represents metadata about an available broker integration. Used by the GET /brokers endpoint to return a list of all supported brokers with their capabilities, authentication requirements, and display information.  The model provides clients with the information needed to: - Display broker options in UI - Determine authentication flow (OAuth vs API key) - Check feature availability - Handle broker aliases that resolve to base brokers  Attributes ---------- id : str     Unique broker identifier used in API requests (e.g., \"tradestation\",     \"tasty_trade\"). This is the value used in BrokerConnectionRequest.broker_id. name : str     Internal broker name, typically matching the id. Used for internal     identification and logging. display_name : str     Human-readable broker name for display in UI (e.g., \"TradeStation\",     \"TastyTrade\"). Should be formatted for end-user presentation. description : str     Detailed description of the broker, including supported features,     account types, and any relevant information for users. website : str     Official broker website URL. Used for linking and reference. features : list[str]     List of supported features for this broker (e.g., [\"trading\", \"options\",     \"futures\", \"crypto\"]). Used to determine what operations are available. auth_type : str     Authentication method required by the broker. Common values:     - \"oauth\": OAuth 2.0 flow (may be multi-step)     - \"api_key\": API key/secret authentication     - \"username_password\": Username and password authentication logo_path : str     Path or URL to the broker's logo image. Used for UI display. is_active : bool     Whether the broker integration is currently active and available for     new connections. Inactive brokers may still support existing connections     but cannot accept new ones. is_alias : bool     Whether this broker entry is an alias that resolves to another broker.     Default is False. When True, base_broker_id indicates the actual broker. base_broker_id : str | None     The actual broker_id this alias resolves to. Only set when is_alias=True.     Used to route requests to the correct broker adapter. Default is None. supports_trading : bool     Whether this broker supports trading operations (placing, canceling,     modifying orders). Default is True. Some brokers may be read-only.  Notes ----- 1. **Broker Aliases**: Aliases allow multiple broker entries to share the    same underlying implementation. Useful for rebranding or regional variants.  2. **Feature List**: The features list is used by clients to enable/disable    UI elements and validate operation availability.  3. **Caching**: Broker information is loaded once at startup and cached.    Changes require application restart to take effect.  4. **Auth Type Handling**: Clients should check auth_type to determine the    appropriate authentication flow and UI components to display.  Examples -------- >>> # Standard broker entry >>> broker = BrokerInfo( ...     id=\"tradestation\", ...     name=\"tradestation\", ...     display_name=\"TradeStation\", ...     description=\"Professional trading platform\", ...     website=\"https://www.tradestation.com\", ...     features=[\"trading\", \"options\", \"futures\"], ...     auth_type=\"oauth\", ...     logo_path=\"/logos/tradestation.png\", ...     is_active=True, ...     supports_trading=True, ... ) >>> # Broker alias >>> alias = BrokerInfo( ...     id=\"tradestation_pro\", ...     name=\"tradestation_pro\", ...     display_name=\"TradeStation Pro\", ...     description=\"TradeStation Professional\", ...     website=\"https://www.tradestation.com\", ...     features=[\"trading\", \"options\"], ...     auth_type=\"oauth\", ...     logo_path=\"/logos/tradestation_pro.png\", ...     is_active=True, ...     is_alias=True, ...     base_broker_id=\"tradestation\", ...     supports_trading=True, ... )  See Also -------- finaticapi.api.v1.routers.brokers.brokers_router.get_brokers     : Endpoint that returns list of BrokerInfo BrokerConnectionRequest : Request model that uses broker_id from this model finatic_broker_factory.core.broker_factory.BrokerFactory.get_available_brokers     : Factory method that provides broker data
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    display_name: StrictStr
    description: StrictStr
    website: StrictStr
    features: List[StrictStr]
    auth_type: StrictStr
    logo_path: StrictStr
    is_active: StrictBool
    is_alias: Optional[StrictBool] = False
    base_broker_id: Optional[StrictStr] = None
    supports_trading: Optional[StrictBool] = True
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "display_name", "description", "website", "features", "auth_type", "logo_path", "is_active", "is_alias", "base_broker_id", "supports_trading"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BrokerInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if base_broker_id (nullable) is None
        # and model_fields_set contains the field
        if self.base_broker_id is None and "base_broker_id" in self.model_fields_set:
            _dict['base_broker_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BrokerInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "description": obj.get("description"),
            "website": obj.get("website"),
            "features": obj.get("features"),
            "auth_type": obj.get("auth_type"),
            "logo_path": obj.get("logo_path"),
            "is_active": obj.get("is_active"),
            "is_alias": obj.get("is_alias") if obj.get("is_alias") is not None else False,
            "base_broker_id": obj.get("base_broker_id"),
            "supports_trading": obj.get("supports_trading") if obj.get("supports_trading") is not None else True
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


