# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .ninja_trader_order_modify_request import NinjaTraderOrderModifyRequest
from .robinhood_order_modify_request import RobinhoodOrderModifyRequest
from .tasty_trade_order_modify_request import TastyTradeOrderModifyRequest
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

MODIFYORDERAPIBETABROKERSORDERSORDERIDPATCHREQUEST_ONE_OF_SCHEMAS = ["NinjaTraderOrderModifyRequest", "RobinhoodOrderModifyRequest", "TastyTradeOrderModifyRequest"]

class ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest(BaseModel):
    """
    Broker-specific parameters object for *modify order* operations
    """
    # data type: NinjaTraderOrderModifyRequest
    oneof_schema_1_validator: Optional[NinjaTraderOrderModifyRequest] = None
    # data type: TastyTradeOrderModifyRequest
    oneof_schema_2_validator: Optional[TastyTradeOrderModifyRequest] = None
    # data type: RobinhoodOrderModifyRequest
    oneof_schema_3_validator: Optional[RobinhoodOrderModifyRequest] = None
    actual_instance: Optional[Union[NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest]] = None
    one_of_schemas: Set[str] = { "NinjaTraderOrderModifyRequest", "RobinhoodOrderModifyRequest", "TastyTradeOrderModifyRequest" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        if v is None:
            return v

        instance = ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: NinjaTraderOrderModifyRequest
        if not isinstance(v, NinjaTraderOrderModifyRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NinjaTraderOrderModifyRequest`")
        else:
            match += 1
        # validate data type: TastyTradeOrderModifyRequest
        if not isinstance(v, TastyTradeOrderModifyRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TastyTradeOrderModifyRequest`")
        else:
            match += 1
        # validate data type: RobinhoodOrderModifyRequest
        if not isinstance(v, RobinhoodOrderModifyRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOrderModifyRequest`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest with oneOf schemas: NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest with oneOf schemas: NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: Optional[str]) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("broker")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `broker` in the input.")

        # check if data type is `NinjaTraderOrderModifyRequest`
        if _data_type == "ninja_trader":
            instance.actual_instance = NinjaTraderOrderModifyRequest.from_json(json_str)
            return instance

        # check if data type is `RobinhoodOrderModifyRequest`
        if _data_type == "robinhood":
            instance.actual_instance = RobinhoodOrderModifyRequest.from_json(json_str)
            return instance

        # check if data type is `TastyTradeOrderModifyRequest`
        if _data_type == "tasty_trade":
            instance.actual_instance = TastyTradeOrderModifyRequest.from_json(json_str)
            return instance

        # deserialize data into NinjaTraderOrderModifyRequest
        try:
            instance.actual_instance = NinjaTraderOrderModifyRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TastyTradeOrderModifyRequest
        try:
            instance.actual_instance = TastyTradeOrderModifyRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodOrderModifyRequest
        try:
            instance.actual_instance = RobinhoodOrderModifyRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest with oneOf schemas: NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ModifyOrderApiBetaBrokersOrdersOrderIdPatchRequest with oneOf schemas: NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], NinjaTraderOrderModifyRequest, RobinhoodOrderModifyRequest, TastyTradeOrderModifyRequest]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


