# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from .accountnumber import Accountnumber
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class NinjaTraderTrailingStopOrderPlaceQueryParams(BaseModel):
    """
    Parameters for a NinjaTrader trailing stop order.
    """ # noqa: E501
    account_spec: Optional[StrictStr] = Field(default=None, alias="accountSpec")
    is_automated: Optional[StrictBool] = Field(default=True, alias="isAutomated")
    activation_time: Optional[datetime] = Field(default=None, alias="activationTime")
    text: Optional[StrictStr] = None
    peg_difference: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pegDifference")
    account_number: Accountnumber = Field(alias="accountNumber")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: StrictStr = Field(alias="assetType")
    action: StrictStr
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    symbol: StrictStr
    order_qty: StrictInt = Field(alias="orderQty")
    stop_price: Union[StrictFloat, StrictInt] = Field(alias="stopPrice")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["accountSpec", "isAutomated", "activationTime", "text", "pegDifference", "accountNumber", "orderType", "assetType", "action", "timeInForce", "symbol", "orderQty", "stopPrice"]

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['trailing_stop']):
            raise ValueError("must be one of enum values ('trailing_stop')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['equity', 'equity_option', 'crypto', 'forex']):
            raise ValueError("must be one of enum values ('equity', 'equity_option', 'crypto', 'forex')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NinjaTraderTrailingStopOrderPlaceQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_number
        if self.account_number:
            _dict['accountNumber'] = self.account_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if account_spec (nullable) is None
        # and model_fields_set contains the field
        if self.account_spec is None and "account_spec" in self.model_fields_set:
            _dict['accountSpec'] = None

        # set to None if activation_time (nullable) is None
        # and model_fields_set contains the field
        if self.activation_time is None and "activation_time" in self.model_fields_set:
            _dict['activationTime'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        # set to None if peg_difference (nullable) is None
        # and model_fields_set contains the field
        if self.peg_difference is None and "peg_difference" in self.model_fields_set:
            _dict['pegDifference'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NinjaTraderTrailingStopOrderPlaceQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountSpec": obj.get("accountSpec"),
            "isAutomated": obj.get("isAutomated") if obj.get("isAutomated") is not None else True,
            "activationTime": obj.get("activationTime"),
            "text": obj.get("text"),
            "pegDifference": obj.get("pegDifference"),
            "accountNumber": Accountnumber.from_dict(obj["accountNumber"]) if obj.get("accountNumber") is not None else None,
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType"),
            "action": obj.get("action"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "symbol": obj.get("symbol"),
            "orderQty": obj.get("orderQty"),
            "stopPrice": obj.get("stopPrice")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


