# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .robinhood_equity_limit_order_place_query_params import RobinhoodEquityLimitOrderPlaceQueryParams
from .robinhood_equity_market_order_place_query_params import RobinhoodEquityMarketOrderPlaceQueryParams
from .robinhood_equity_stop_limit_order_place_query_params import RobinhoodEquityStopLimitOrderPlaceQueryParams
from .robinhood_equity_stop_order_place_query_params import RobinhoodEquityStopOrderPlaceQueryParams
from .robinhood_equity_trailing_stop_order_place_query_params import RobinhoodEquityTrailingStopOrderPlaceQueryParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDER1ANYOF_ONE_OF_SCHEMAS = ["RobinhoodEquityLimitOrderPlaceQueryParams", "RobinhoodEquityMarketOrderPlaceQueryParams", "RobinhoodEquityStopLimitOrderPlaceQueryParams", "RobinhoodEquityStopOrderPlaceQueryParams", "RobinhoodEquityTrailingStopOrderPlaceQueryParams"]

class Order1AnyOf(BaseModel):
    """
    Order1AnyOf
    """
    # data type: RobinhoodEquityMarketOrderPlaceQueryParams
    oneof_schema_1_validator: Optional[RobinhoodEquityMarketOrderPlaceQueryParams] = None
    # data type: RobinhoodEquityLimitOrderPlaceQueryParams
    oneof_schema_2_validator: Optional[RobinhoodEquityLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodEquityStopOrderPlaceQueryParams
    oneof_schema_3_validator: Optional[RobinhoodEquityStopOrderPlaceQueryParams] = None
    # data type: RobinhoodEquityStopLimitOrderPlaceQueryParams
    oneof_schema_4_validator: Optional[RobinhoodEquityStopLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodEquityTrailingStopOrderPlaceQueryParams
    oneof_schema_5_validator: Optional[RobinhoodEquityTrailingStopOrderPlaceQueryParams] = None
    actual_instance: Optional[Union[RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams]] = None
    one_of_schemas: Set[str] = { "RobinhoodEquityLimitOrderPlaceQueryParams", "RobinhoodEquityMarketOrderPlaceQueryParams", "RobinhoodEquityStopLimitOrderPlaceQueryParams", "RobinhoodEquityStopOrderPlaceQueryParams", "RobinhoodEquityTrailingStopOrderPlaceQueryParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Order1AnyOf.model_construct()
        error_messages = []
        match = 0
        # validate data type: RobinhoodEquityMarketOrderPlaceQueryParams
        if not isinstance(v, RobinhoodEquityMarketOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodEquityMarketOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodEquityLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodEquityLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodEquityLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodEquityStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodEquityStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodEquityStopOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodEquityStopLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodEquityStopLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodEquityStopLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodEquityTrailingStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodEquityTrailingStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodEquityTrailingStopOrderPlaceQueryParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Order1AnyOf with oneOf schemas: RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Order1AnyOf with oneOf schemas: RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("orderType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `orderType` in the input.")

        # check if data type is `RobinhoodEquityLimitOrderPlaceQueryParams`
        if _data_type == "limit":
            instance.actual_instance = RobinhoodEquityLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodEquityMarketOrderPlaceQueryParams`
        if _data_type == "market":
            instance.actual_instance = RobinhoodEquityMarketOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodEquityStopOrderPlaceQueryParams`
        if _data_type == "stop":
            instance.actual_instance = RobinhoodEquityStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodEquityStopLimitOrderPlaceQueryParams`
        if _data_type == "stop_limit":
            instance.actual_instance = RobinhoodEquityStopLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodEquityTrailingStopOrderPlaceQueryParams`
        if _data_type == "trailing_stop":
            instance.actual_instance = RobinhoodEquityTrailingStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # deserialize data into RobinhoodEquityMarketOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodEquityMarketOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodEquityLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodEquityLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodEquityStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodEquityStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodEquityStopLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodEquityStopLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodEquityTrailingStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodEquityTrailingStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Order1AnyOf with oneOf schemas: RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order1AnyOf with oneOf schemas: RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RobinhoodEquityLimitOrderPlaceQueryParams, RobinhoodEquityMarketOrderPlaceQueryParams, RobinhoodEquityStopLimitOrderPlaceQueryParams, RobinhoodEquityStopOrderPlaceQueryParams, RobinhoodEquityTrailingStopOrderPlaceQueryParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


