# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .commission import Commission
from .fdx_order_leg import FDXOrderLeg
from .orderclass import Orderclass
from .ordertype import Ordertype
from .status import Status
from .timeinforce import Timeinforce
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerOrder(BaseModel):
    """
    FDX-style broker order schema following FDX patterns.  New broker-specific schema for trading orders.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    order_id: StrictStr = Field(description="Finatic canonical order ID", alias="orderId")
    broker_order_id: Optional[StrictStr] = Field(default=None, alias="brokerOrderId")
    client_order_id: Optional[StrictStr] = Field(default=None, alias="clientOrderId")
    account_id: StrictStr = Field(description="Broker account identifier", alias="accountId")
    internal_account_id: Optional[StrictStr] = Field(default=None, alias="internalAccountId")
    connection_id: Optional[StrictStr] = Field(default=None, alias="connectionId")
    order_type: Optional[Ordertype] = Field(default=None, alias="orderType")
    order_class: Optional[Orderclass] = Field(default=None, alias="orderClass")
    time_in_force: Optional[Timeinforce] = Field(default=None, alias="timeInForce")
    status: Status
    state: Optional[StrictStr] = None
    legs: Optional[List[FDXOrderLeg]] = Field(default=None, description="Multi-leg orders")
    order_group_id: Optional[StrictStr] = Field(default=None, alias="orderGroupId")
    order_created_at: Optional[datetime] = Field(default=None, alias="orderCreatedAt")
    order_live_at: Optional[datetime] = Field(default=None, alias="orderLiveAt")
    order_updated_at: Optional[datetime] = Field(default=None, alias="orderUpdatedAt")
    order_terminal_at: Optional[datetime] = Field(default=None, alias="orderTerminalAt")
    metadata: Optional[Dict[str, Any]] = None
    commission: Optional[Commission] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "orderId", "brokerOrderId", "clientOrderId", "accountId", "internalAccountId", "connectionId", "orderType", "orderClass", "timeInForce", "status", "state", "legs", "orderGroupId", "orderCreatedAt", "orderLiveAt", "orderUpdatedAt", "orderTerminalAt", "metadata", "commission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of order_type
        if self.order_type:
            _dict['orderType'] = self.order_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_class
        if self.order_class:
            _dict['orderClass'] = self.order_class.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in legs (list)
        _items = []
        if self.legs:
            for _item_legs in self.legs:
                if _item_legs:
                    _items.append(_item_legs.to_dict())
            _dict['legs'] = _items
        # override the default output from pydantic by calling `to_dict()` of commission
        if self.commission:
            _dict['commission'] = self.commission.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if broker_order_id (nullable) is None
        # and model_fields_set contains the field
        if self.broker_order_id is None and "broker_order_id" in self.model_fields_set:
            _dict['brokerOrderId'] = None

        # set to None if client_order_id (nullable) is None
        # and model_fields_set contains the field
        if self.client_order_id is None and "client_order_id" in self.model_fields_set:
            _dict['clientOrderId'] = None

        # set to None if internal_account_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_account_id is None and "internal_account_id" in self.model_fields_set:
            _dict['internalAccountId'] = None

        # set to None if connection_id (nullable) is None
        # and model_fields_set contains the field
        if self.connection_id is None and "connection_id" in self.model_fields_set:
            _dict['connectionId'] = None

        # set to None if order_type (nullable) is None
        # and model_fields_set contains the field
        if self.order_type is None and "order_type" in self.model_fields_set:
            _dict['orderType'] = None

        # set to None if order_class (nullable) is None
        # and model_fields_set contains the field
        if self.order_class is None and "order_class" in self.model_fields_set:
            _dict['orderClass'] = None

        # set to None if time_in_force (nullable) is None
        # and model_fields_set contains the field
        if self.time_in_force is None and "time_in_force" in self.model_fields_set:
            _dict['timeInForce'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if order_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_group_id is None and "order_group_id" in self.model_fields_set:
            _dict['orderGroupId'] = None

        # set to None if order_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.order_created_at is None and "order_created_at" in self.model_fields_set:
            _dict['orderCreatedAt'] = None

        # set to None if order_live_at (nullable) is None
        # and model_fields_set contains the field
        if self.order_live_at is None and "order_live_at" in self.model_fields_set:
            _dict['orderLiveAt'] = None

        # set to None if order_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.order_updated_at is None and "order_updated_at" in self.model_fields_set:
            _dict['orderUpdatedAt'] = None

        # set to None if order_terminal_at (nullable) is None
        # and model_fields_set contains the field
        if self.order_terminal_at is None and "order_terminal_at" in self.model_fields_set:
            _dict['orderTerminalAt'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if commission (nullable) is None
        # and model_fields_set contains the field
        if self.commission is None and "commission" in self.model_fields_set:
            _dict['commission'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "orderId": obj.get("orderId"),
            "brokerOrderId": obj.get("brokerOrderId"),
            "clientOrderId": obj.get("clientOrderId"),
            "accountId": obj.get("accountId"),
            "internalAccountId": obj.get("internalAccountId"),
            "connectionId": obj.get("connectionId"),
            "orderType": Ordertype.from_dict(obj["orderType"]) if obj.get("orderType") is not None else None,
            "orderClass": Orderclass.from_dict(obj["orderClass"]) if obj.get("orderClass") is not None else None,
            "timeInForce": Timeinforce.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "status": Status.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "state": obj.get("state"),
            "legs": [FDXOrderLeg.from_dict(_item) for _item in obj["legs"]] if obj.get("legs") is not None else None,
            "orderGroupId": obj.get("orderGroupId"),
            "orderCreatedAt": obj.get("orderCreatedAt"),
            "orderLiveAt": obj.get("orderLiveAt"),
            "orderUpdatedAt": obj.get("orderUpdatedAt"),
            "orderTerminalAt": obj.get("orderTerminalAt"),
            "metadata": obj.get("metadata"),
            "commission": Commission.from_dict(obj["commission"]) if obj.get("commission") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


