# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .assettype import Assettype
from .averagefillprice import Averagefillprice
from .filledquantity import Filledquantity
from .futureunderlyingassettype import Futureunderlyingassettype
from .limitprice import Limitprice
from .notional import Notional
from .quantity import Quantity
from .remainingquantity import Remainingquantity
from .securityidtype import Securityidtype
from .side import Side
from .stopprice import Stopprice
from .strikeprice import Strikeprice
from typing import Optional, Set
from typing_extensions import Self

class FDXOrderLeg(BaseModel):
    """
    FDX-style order leg schema for multi-leg orders.
    """ # noqa: E501
    leg_index: StrictInt = Field(description="Leg index (0 for single-leg)", alias="legIndex")
    security_id: StrictStr = Field(description="Symbol or instrument identifier", alias="securityId")
    security_id_type: Securityidtype = Field(alias="securityIdType")
    asset_type: Assettype = Field(alias="assetType")
    side: Side
    quantity: Quantity
    remaining_quantity: Optional[Remainingquantity] = Field(default=None, alias="remainingQuantity")
    limit_price: Optional[Limitprice] = Field(default=None, alias="limitPrice")
    stop_price: Optional[Stopprice] = Field(default=None, alias="stopPrice")
    filled_quantity: Optional[Filledquantity] = Field(default=None, alias="filledQuantity")
    average_fill_price: Optional[Averagefillprice] = Field(default=None, alias="averageFillPrice")
    option_type: Optional[StrictStr] = Field(default=None, alias="optionType")
    strike_price: Optional[Strikeprice] = Field(default=None, alias="strikePrice")
    expiration_date: Optional[date] = Field(default=None, alias="expirationDate")
    underlying_symbol: Optional[StrictStr] = Field(default=None, alias="underlyingSymbol")
    contract_code: Optional[StrictStr] = Field(default=None, alias="contractCode")
    future_underlying_asset_type: Optional[Futureunderlyingassettype] = Field(default=None, alias="futureUnderlyingAssetType")
    crypto_base_symbol: Optional[StrictStr] = Field(default=None, alias="cryptoBaseSymbol")
    crypto_quote_symbol: Optional[StrictStr] = Field(default=None, alias="cryptoQuoteSymbol")
    broker_provided_symbol: Optional[StrictStr] = Field(default=None, alias="brokerProvidedSymbol")
    notional: Optional[Notional] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["legIndex", "securityId", "securityIdType", "assetType", "side", "quantity", "remainingQuantity", "limitPrice", "stopPrice", "filledQuantity", "averageFillPrice", "optionType", "strikePrice", "expirationDate", "underlyingSymbol", "contractCode", "futureUnderlyingAssetType", "cryptoBaseSymbol", "cryptoQuoteSymbol", "brokerProvidedSymbol", "notional"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXOrderLeg from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of security_id_type
        if self.security_id_type:
            _dict['securityIdType'] = self.security_id_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset_type
        if self.asset_type:
            _dict['assetType'] = self.asset_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of side
        if self.side:
            _dict['side'] = self.side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quantity
        if self.quantity:
            _dict['quantity'] = self.quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remaining_quantity
        if self.remaining_quantity:
            _dict['remainingQuantity'] = self.remaining_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limit_price
        if self.limit_price:
            _dict['limitPrice'] = self.limit_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop_price
        if self.stop_price:
            _dict['stopPrice'] = self.stop_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filled_quantity
        if self.filled_quantity:
            _dict['filledQuantity'] = self.filled_quantity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of average_fill_price
        if self.average_fill_price:
            _dict['averageFillPrice'] = self.average_fill_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of strike_price
        if self.strike_price:
            _dict['strikePrice'] = self.strike_price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of future_underlying_asset_type
        if self.future_underlying_asset_type:
            _dict['futureUnderlyingAssetType'] = self.future_underlying_asset_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notional
        if self.notional:
            _dict['notional'] = self.notional.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if remaining_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.remaining_quantity is None and "remaining_quantity" in self.model_fields_set:
            _dict['remainingQuantity'] = None

        # set to None if limit_price (nullable) is None
        # and model_fields_set contains the field
        if self.limit_price is None and "limit_price" in self.model_fields_set:
            _dict['limitPrice'] = None

        # set to None if stop_price (nullable) is None
        # and model_fields_set contains the field
        if self.stop_price is None and "stop_price" in self.model_fields_set:
            _dict['stopPrice'] = None

        # set to None if filled_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.filled_quantity is None and "filled_quantity" in self.model_fields_set:
            _dict['filledQuantity'] = None

        # set to None if average_fill_price (nullable) is None
        # and model_fields_set contains the field
        if self.average_fill_price is None and "average_fill_price" in self.model_fields_set:
            _dict['averageFillPrice'] = None

        # set to None if option_type (nullable) is None
        # and model_fields_set contains the field
        if self.option_type is None and "option_type" in self.model_fields_set:
            _dict['optionType'] = None

        # set to None if strike_price (nullable) is None
        # and model_fields_set contains the field
        if self.strike_price is None and "strike_price" in self.model_fields_set:
            _dict['strikePrice'] = None

        # set to None if expiration_date (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_date is None and "expiration_date" in self.model_fields_set:
            _dict['expirationDate'] = None

        # set to None if underlying_symbol (nullable) is None
        # and model_fields_set contains the field
        if self.underlying_symbol is None and "underlying_symbol" in self.model_fields_set:
            _dict['underlyingSymbol'] = None

        # set to None if contract_code (nullable) is None
        # and model_fields_set contains the field
        if self.contract_code is None and "contract_code" in self.model_fields_set:
            _dict['contractCode'] = None

        # set to None if future_underlying_asset_type (nullable) is None
        # and model_fields_set contains the field
        if self.future_underlying_asset_type is None and "future_underlying_asset_type" in self.model_fields_set:
            _dict['futureUnderlyingAssetType'] = None

        # set to None if crypto_base_symbol (nullable) is None
        # and model_fields_set contains the field
        if self.crypto_base_symbol is None and "crypto_base_symbol" in self.model_fields_set:
            _dict['cryptoBaseSymbol'] = None

        # set to None if crypto_quote_symbol (nullable) is None
        # and model_fields_set contains the field
        if self.crypto_quote_symbol is None and "crypto_quote_symbol" in self.model_fields_set:
            _dict['cryptoQuoteSymbol'] = None

        # set to None if broker_provided_symbol (nullable) is None
        # and model_fields_set contains the field
        if self.broker_provided_symbol is None and "broker_provided_symbol" in self.model_fields_set:
            _dict['brokerProvidedSymbol'] = None

        # set to None if notional (nullable) is None
        # and model_fields_set contains the field
        if self.notional is None and "notional" in self.model_fields_set:
            _dict['notional'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXOrderLeg from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "legIndex": obj.get("legIndex"),
            "securityId": obj.get("securityId"),
            "securityIdType": Securityidtype.from_dict(obj["securityIdType"]) if obj.get("securityIdType") is not None else None,
            "assetType": Assettype.from_dict(obj["assetType"]) if obj.get("assetType") is not None else None,
            "side": Side.from_dict(obj["side"]) if obj.get("side") is not None else None,
            "quantity": Quantity.from_dict(obj["quantity"]) if obj.get("quantity") is not None else None,
            "remainingQuantity": Remainingquantity.from_dict(obj["remainingQuantity"]) if obj.get("remainingQuantity") is not None else None,
            "limitPrice": Limitprice.from_dict(obj["limitPrice"]) if obj.get("limitPrice") is not None else None,
            "stopPrice": Stopprice.from_dict(obj["stopPrice"]) if obj.get("stopPrice") is not None else None,
            "filledQuantity": Filledquantity.from_dict(obj["filledQuantity"]) if obj.get("filledQuantity") is not None else None,
            "averageFillPrice": Averagefillprice.from_dict(obj["averageFillPrice"]) if obj.get("averageFillPrice") is not None else None,
            "optionType": obj.get("optionType"),
            "strikePrice": Strikeprice.from_dict(obj["strikePrice"]) if obj.get("strikePrice") is not None else None,
            "expirationDate": obj.get("expirationDate"),
            "underlyingSymbol": obj.get("underlyingSymbol"),
            "contractCode": obj.get("contractCode"),
            "futureUnderlyingAssetType": Futureunderlyingassettype.from_dict(obj["futureUnderlyingAssetType"]) if obj.get("futureUnderlyingAssetType") is not None else None,
            "cryptoBaseSymbol": obj.get("cryptoBaseSymbol"),
            "cryptoQuoteSymbol": obj.get("cryptoQuoteSymbol"),
            "brokerProvidedSymbol": obj.get("brokerProvidedSymbol"),
            "notional": Notional.from_dict(obj["notional"]) if obj.get("notional") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


