# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, Optional, Union
from typing_extensions import Annotated
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class NinjaTraderStopOrderModifyQueryParams(BaseModel):
    """
    Stop-order modification payload for NinjaTrader.
    """ # noqa: E501
    order_qty: Optional[StrictInt] = Field(default=None, alias="orderQty")
    cl_ord_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, alias="clOrdId")
    max_show: Optional[StrictInt] = Field(default=None, alias="maxShow")
    peg_difference: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="pegDifference")
    activation_time: Optional[datetime] = Field(default=None, alias="activationTime")
    text: Optional[Annotated[str, Field(strict=True, max_length=64)]] = None
    order_id: StrictStr = Field(description="Broker-assigned order identifier", alias="orderId")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: StrictStr = Field(alias="assetType")
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    is_automated: Optional[StrictBool] = Field(default=None, alias="isAutomated")
    stop_price: Union[StrictFloat, StrictInt] = Field(alias="stopPrice")
    __properties: ClassVar[List[str]] = ["orderQty", "clOrdId", "maxShow", "pegDifference", "activationTime", "text", "orderId", "orderType", "assetType", "timeInForce", "isAutomated", "stopPrice"]

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['stop']):
            raise ValueError("must be one of enum values ('stop')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['equity', 'equity_option', 'crypto', 'forex']):
            raise ValueError("must be one of enum values ('equity', 'equity_option', 'crypto', 'forex')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NinjaTraderStopOrderModifyQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # set to None if order_qty (nullable) is None
        # and model_fields_set contains the field
        if self.order_qty is None and "order_qty" in self.model_fields_set:
            _dict['orderQty'] = None

        # set to None if cl_ord_id (nullable) is None
        # and model_fields_set contains the field
        if self.cl_ord_id is None and "cl_ord_id" in self.model_fields_set:
            _dict['clOrdId'] = None

        # set to None if max_show (nullable) is None
        # and model_fields_set contains the field
        if self.max_show is None and "max_show" in self.model_fields_set:
            _dict['maxShow'] = None

        # set to None if peg_difference (nullable) is None
        # and model_fields_set contains the field
        if self.peg_difference is None and "peg_difference" in self.model_fields_set:
            _dict['pegDifference'] = None

        # set to None if activation_time (nullable) is None
        # and model_fields_set contains the field
        if self.activation_time is None and "activation_time" in self.model_fields_set:
            _dict['activationTime'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        # set to None if is_automated (nullable) is None
        # and model_fields_set contains the field
        if self.is_automated is None and "is_automated" in self.model_fields_set:
            _dict['isAutomated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NinjaTraderStopOrderModifyQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderQty": obj.get("orderQty"),
            "clOrdId": obj.get("clOrdId"),
            "maxShow": obj.get("maxShow"),
            "pegDifference": obj.get("pegDifference"),
            "activationTime": obj.get("activationTime"),
            "text": obj.get("text"),
            "orderId": obj.get("orderId"),
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "isAutomated": obj.get("isAutomated"),
            "stopPrice": obj.get("stopPrice")
        })
        return _obj


