# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from .order1_any_of import Order1AnyOf
from .order1_any_of1 import Order1AnyOf1
from .order1_any_of2 import Order1AnyOf2
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

ORDER1_ANY_OF_SCHEMAS = ["Order1AnyOf", "Order1AnyOf1", "Order1AnyOf2"]

class Order1(BaseModel):
    """
    Order1
    """

    # data type: Order1AnyOf
    anyof_schema_1_validator: Optional[Order1AnyOf] = None
    # data type: Order1AnyOf1
    anyof_schema_2_validator: Optional[Order1AnyOf1] = None
    # data type: Order1AnyOf2
    anyof_schema_3_validator: Optional[Order1AnyOf2] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[Order1AnyOf, Order1AnyOf1, Order1AnyOf2]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "Order1AnyOf", "Order1AnyOf1", "Order1AnyOf2" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Order1.model_construct()
        error_messages = []
        # validate data type: Order1AnyOf
        if not isinstance(v, Order1AnyOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Order1AnyOf`")
        else:
            return v

        # validate data type: Order1AnyOf1
        if not isinstance(v, Order1AnyOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Order1AnyOf1`")
        else:
            return v

        # validate data type: Order1AnyOf2
        if not isinstance(v, Order1AnyOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Order1AnyOf2`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Order1 with anyOf schemas: Order1AnyOf, Order1AnyOf1, Order1AnyOf2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[Order1AnyOf] = None
        try:
            instance.actual_instance = Order1AnyOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[Order1AnyOf1] = None
        try:
            instance.actual_instance = Order1AnyOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[Order1AnyOf2] = None
        try:
            instance.actual_instance = Order1AnyOf2.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order1 with anyOf schemas: Order1AnyOf, Order1AnyOf1, Order1AnyOf2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], Order1AnyOf, Order1AnyOf1, Order1AnyOf2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


