# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .robinhood_option_limit_order_place_query_params import RobinhoodOptionLimitOrderPlaceQueryParams
from .robinhood_option_market_order_place_query_params import RobinhoodOptionMarketOrderPlaceQueryParams
from .robinhood_option_stop_limit_order_place_query_params import RobinhoodOptionStopLimitOrderPlaceQueryParams
from .robinhood_option_stop_order_place_query_params import RobinhoodOptionStopOrderPlaceQueryParams
from .robinhood_option_trailing_stop_order_place_query_params import RobinhoodOptionTrailingStopOrderPlaceQueryParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDER1ANYOF1_ONE_OF_SCHEMAS = ["RobinhoodOptionLimitOrderPlaceQueryParams", "RobinhoodOptionMarketOrderPlaceQueryParams", "RobinhoodOptionStopLimitOrderPlaceQueryParams", "RobinhoodOptionStopOrderPlaceQueryParams", "RobinhoodOptionTrailingStopOrderPlaceQueryParams"]

class Order1AnyOf1(BaseModel):
    """
    Order1AnyOf1
    """
    # data type: RobinhoodOptionMarketOrderPlaceQueryParams
    oneof_schema_1_validator: Optional[RobinhoodOptionMarketOrderPlaceQueryParams] = None
    # data type: RobinhoodOptionLimitOrderPlaceQueryParams
    oneof_schema_2_validator: Optional[RobinhoodOptionLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodOptionStopOrderPlaceQueryParams
    oneof_schema_3_validator: Optional[RobinhoodOptionStopOrderPlaceQueryParams] = None
    # data type: RobinhoodOptionStopLimitOrderPlaceQueryParams
    oneof_schema_4_validator: Optional[RobinhoodOptionStopLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodOptionTrailingStopOrderPlaceQueryParams
    oneof_schema_5_validator: Optional[RobinhoodOptionTrailingStopOrderPlaceQueryParams] = None
    actual_instance: Optional[Union[RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams]] = None
    one_of_schemas: Set[str] = { "RobinhoodOptionLimitOrderPlaceQueryParams", "RobinhoodOptionMarketOrderPlaceQueryParams", "RobinhoodOptionStopLimitOrderPlaceQueryParams", "RobinhoodOptionStopOrderPlaceQueryParams", "RobinhoodOptionTrailingStopOrderPlaceQueryParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Order1AnyOf1.model_construct()
        error_messages = []
        match = 0
        # validate data type: RobinhoodOptionMarketOrderPlaceQueryParams
        if not isinstance(v, RobinhoodOptionMarketOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOptionMarketOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodOptionLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodOptionLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOptionLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodOptionStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodOptionStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOptionStopOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodOptionStopLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodOptionStopLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOptionStopLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodOptionTrailingStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodOptionTrailingStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodOptionTrailingStopOrderPlaceQueryParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Order1AnyOf1 with oneOf schemas: RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Order1AnyOf1 with oneOf schemas: RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("orderType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `orderType` in the input.")

        # check if data type is `RobinhoodOptionLimitOrderPlaceQueryParams`
        if _data_type == "limit":
            instance.actual_instance = RobinhoodOptionLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodOptionMarketOrderPlaceQueryParams`
        if _data_type == "market":
            instance.actual_instance = RobinhoodOptionMarketOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodOptionStopOrderPlaceQueryParams`
        if _data_type == "stop":
            instance.actual_instance = RobinhoodOptionStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodOptionStopLimitOrderPlaceQueryParams`
        if _data_type == "stop_limit":
            instance.actual_instance = RobinhoodOptionStopLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodOptionTrailingStopOrderPlaceQueryParams`
        if _data_type == "trailing_stop":
            instance.actual_instance = RobinhoodOptionTrailingStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # deserialize data into RobinhoodOptionMarketOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodOptionMarketOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodOptionLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodOptionLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodOptionStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodOptionStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodOptionStopLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodOptionStopLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodOptionTrailingStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodOptionTrailingStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Order1AnyOf1 with oneOf schemas: RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order1AnyOf1 with oneOf schemas: RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RobinhoodOptionLimitOrderPlaceQueryParams, RobinhoodOptionMarketOrderPlaceQueryParams, RobinhoodOptionStopLimitOrderPlaceQueryParams, RobinhoodOptionStopOrderPlaceQueryParams, RobinhoodOptionTrailingStopOrderPlaceQueryParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


