# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .robinhood_crypto_limit_order_place_query_params import RobinhoodCryptoLimitOrderPlaceQueryParams
from .robinhood_crypto_market_order_place_query_params import RobinhoodCryptoMarketOrderPlaceQueryParams
from .robinhood_crypto_stop_limit_order_place_query_params import RobinhoodCryptoStopLimitOrderPlaceQueryParams
from .robinhood_crypto_stop_order_place_query_params import RobinhoodCryptoStopOrderPlaceQueryParams
from .robinhood_crypto_trailing_stop_order_place_query_params import RobinhoodCryptoTrailingStopOrderPlaceQueryParams
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDER1ANYOF2_ONE_OF_SCHEMAS = ["RobinhoodCryptoLimitOrderPlaceQueryParams", "RobinhoodCryptoMarketOrderPlaceQueryParams", "RobinhoodCryptoStopLimitOrderPlaceQueryParams", "RobinhoodCryptoStopOrderPlaceQueryParams", "RobinhoodCryptoTrailingStopOrderPlaceQueryParams"]

class Order1AnyOf2(BaseModel):
    """
    Order1AnyOf2
    """
    # data type: RobinhoodCryptoMarketOrderPlaceQueryParams
    oneof_schema_1_validator: Optional[RobinhoodCryptoMarketOrderPlaceQueryParams] = None
    # data type: RobinhoodCryptoLimitOrderPlaceQueryParams
    oneof_schema_2_validator: Optional[RobinhoodCryptoLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodCryptoStopOrderPlaceQueryParams
    oneof_schema_3_validator: Optional[RobinhoodCryptoStopOrderPlaceQueryParams] = None
    # data type: RobinhoodCryptoStopLimitOrderPlaceQueryParams
    oneof_schema_4_validator: Optional[RobinhoodCryptoStopLimitOrderPlaceQueryParams] = None
    # data type: RobinhoodCryptoTrailingStopOrderPlaceQueryParams
    oneof_schema_5_validator: Optional[RobinhoodCryptoTrailingStopOrderPlaceQueryParams] = None
    actual_instance: Optional[Union[RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams]] = None
    one_of_schemas: Set[str] = { "RobinhoodCryptoLimitOrderPlaceQueryParams", "RobinhoodCryptoMarketOrderPlaceQueryParams", "RobinhoodCryptoStopLimitOrderPlaceQueryParams", "RobinhoodCryptoStopOrderPlaceQueryParams", "RobinhoodCryptoTrailingStopOrderPlaceQueryParams" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Order1AnyOf2.model_construct()
        error_messages = []
        match = 0
        # validate data type: RobinhoodCryptoMarketOrderPlaceQueryParams
        if not isinstance(v, RobinhoodCryptoMarketOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodCryptoMarketOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodCryptoLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodCryptoLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodCryptoLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodCryptoStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodCryptoStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodCryptoStopOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodCryptoStopLimitOrderPlaceQueryParams
        if not isinstance(v, RobinhoodCryptoStopLimitOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodCryptoStopLimitOrderPlaceQueryParams`")
        else:
            match += 1
        # validate data type: RobinhoodCryptoTrailingStopOrderPlaceQueryParams
        if not isinstance(v, RobinhoodCryptoTrailingStopOrderPlaceQueryParams):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RobinhoodCryptoTrailingStopOrderPlaceQueryParams`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Order1AnyOf2 with oneOf schemas: RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Order1AnyOf2 with oneOf schemas: RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("orderType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `orderType` in the input.")

        # check if data type is `RobinhoodCryptoLimitOrderPlaceQueryParams`
        if _data_type == "limit":
            instance.actual_instance = RobinhoodCryptoLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodCryptoMarketOrderPlaceQueryParams`
        if _data_type == "market":
            instance.actual_instance = RobinhoodCryptoMarketOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodCryptoStopOrderPlaceQueryParams`
        if _data_type == "stop":
            instance.actual_instance = RobinhoodCryptoStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodCryptoStopLimitOrderPlaceQueryParams`
        if _data_type == "stop_limit":
            instance.actual_instance = RobinhoodCryptoStopLimitOrderPlaceQueryParams.from_json(json_str)
            return instance

        # check if data type is `RobinhoodCryptoTrailingStopOrderPlaceQueryParams`
        if _data_type == "trailing_stop":
            instance.actual_instance = RobinhoodCryptoTrailingStopOrderPlaceQueryParams.from_json(json_str)
            return instance

        # deserialize data into RobinhoodCryptoMarketOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodCryptoMarketOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodCryptoLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodCryptoLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodCryptoStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodCryptoStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodCryptoStopLimitOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodCryptoStopLimitOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RobinhoodCryptoTrailingStopOrderPlaceQueryParams
        try:
            instance.actual_instance = RobinhoodCryptoTrailingStopOrderPlaceQueryParams.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Order1AnyOf2 with oneOf schemas: RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Order1AnyOf2 with oneOf schemas: RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], RobinhoodCryptoLimitOrderPlaceQueryParams, RobinhoodCryptoMarketOrderPlaceQueryParams, RobinhoodCryptoStopLimitOrderPlaceQueryParams, RobinhoodCryptoStopOrderPlaceQueryParams, RobinhoodCryptoTrailingStopOrderPlaceQueryParams]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


