# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from .accountnumber import Accountnumber
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class RobinhoodEquityStopLimitOrderPlaceQueryParams(BaseModel):
    """
    Equity stop limit order with Robinhood-specific extras.
    """ # noqa: E501
    account_number: Accountnumber = Field(alias="accountNumber")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: Optional[StrictStr] = Field(default='equity', alias="assetType")
    action: StrictStr
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    symbol: StrictStr
    order_qty: StrictInt = Field(alias="orderQty")
    stop_price: Union[StrictFloat, StrictInt] = Field(alias="stopPrice")
    limit_price: Union[StrictFloat, StrictInt] = Field(alias="limitPrice")
    extended_hours: Optional[StrictBool] = Field(default=False, description="Allow trading during extended hours (premium users only)", alias="extendedHours")
    market_hours: Optional[StrictStr] = Field(default='regular_hours', description="Market hours to trade in", alias="marketHours")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["accountNumber", "orderType", "assetType", "action", "timeInForce", "symbol", "orderQty", "stopPrice", "limitPrice", "extendedHours", "marketHours"]

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['stop_limit']):
            raise ValueError("must be one of enum values ('stop_limit')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['equity']):
            raise ValueError("must be one of enum values ('equity')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('market_hours')
    def market_hours_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['regular_hours', 'all_day_hours', 'extended_hours']):
            raise ValueError("must be one of enum values ('regular_hours', 'all_day_hours', 'extended_hours')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobinhoodEquityStopLimitOrderPlaceQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_number
        if self.account_number:
            _dict['accountNumber'] = self.account_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobinhoodEquityStopLimitOrderPlaceQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountNumber": Accountnumber.from_dict(obj["accountNumber"]) if obj.get("accountNumber") is not None else None,
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType") if obj.get("assetType") is not None else 'equity',
            "action": obj.get("action"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "symbol": obj.get("symbol"),
            "orderQty": obj.get("orderQty"),
            "stopPrice": obj.get("stopPrice"),
            "limitPrice": obj.get("limitPrice"),
            "extendedHours": obj.get("extendedHours") if obj.get("extendedHours") is not None else False,
            "marketHours": obj.get("marketHours") if obj.get("marketHours") is not None else 'regular_hours'
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


