# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from .finatic_broker_factory_brokers_robinhood_executors_consumer_robinhood_order_modify_query_params_robinhood_option_spread_leg import FinaticBrokerFactoryBrokersRobinhoodExecutorsConsumerRobinhoodOrderModifyQueryParamsRobinhoodOptionSpreadLeg
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class RobinhoodMarketOrderModifyQueryParams(BaseModel):
    """
    Market order modification with Robinhood-specific extras.
    """ # noqa: E501
    extended_hours: Optional[StrictBool] = Field(default=False, description="Allow trading during extended hours (premium users only)", alias="extendedHours")
    market_hours: Optional[StrictStr] = Field(default='regular_hours', description="Market hours to trade in", alias="marketHours")
    direction: Optional[StrictStr] = None
    spread: Optional[List[FinaticBrokerFactoryBrokersRobinhoodExecutorsConsumerRobinhoodOrderModifyQueryParamsRobinhoodOptionSpreadLeg]] = None
    position_effect: Optional[StrictStr] = Field(default=None, alias="positionEffect")
    credit_or_debit: Optional[StrictStr] = Field(default=None, alias="creditOrDebit")
    expiration_date: Optional[StrictStr] = Field(default=None, alias="expirationDate")
    strike: Optional[Union[StrictFloat, StrictInt]] = None
    option_type: Optional[StrictStr] = Field(default=None, alias="optionType")
    amount_in: Optional[StrictStr] = Field(default='quantity', description="Whether quantityOrPrice represents quantity or price", alias="amountIn")
    order_id: StrictStr = Field(description="Broker-assigned order identifier", alias="orderId")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: StrictStr = Field(alias="assetType")
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    is_automated: Optional[StrictBool] = Field(default=None, alias="isAutomated")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["extendedHours", "marketHours", "direction", "spread", "positionEffect", "creditOrDebit", "expirationDate", "strike", "optionType", "amountIn", "orderId", "orderType", "assetType", "timeInForce", "isAutomated"]

    @field_validator('market_hours')
    def market_hours_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['regular_hours', 'all_day_hours', 'extended_hours']):
            raise ValueError("must be one of enum values ('regular_hours', 'all_day_hours', 'extended_hours')")
        return value

    @field_validator('direction')
    def direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['debit', 'credit']):
            raise ValueError("must be one of enum values ('debit', 'credit')")
        return value

    @field_validator('position_effect')
    def position_effect_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'close']):
            raise ValueError("must be one of enum values ('open', 'close')")
        return value

    @field_validator('credit_or_debit')
    def credit_or_debit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['debit', 'credit']):
            raise ValueError("must be one of enum values ('debit', 'credit')")
        return value

    @field_validator('option_type')
    def option_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['call', 'put', 'both']):
            raise ValueError("must be one of enum values ('call', 'put', 'both')")
        return value

    @field_validator('amount_in')
    def amount_in_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['quantity', 'price']):
            raise ValueError("must be one of enum values ('quantity', 'price')")
        return value

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['market']):
            raise ValueError("must be one of enum values ('market')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['equity', 'equity_option', 'crypto', 'forex']):
            raise ValueError("must be one of enum values ('equity', 'equity_option', 'crypto', 'forex')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobinhoodMarketOrderModifyQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in spread (list)
        _items = []
        if self.spread:
            for _item_spread in self.spread:
                if _item_spread:
                    _items.append(_item_spread.to_dict())
            _dict['spread'] = _items
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if direction (nullable) is None
        # and model_fields_set contains the field
        if self.direction is None and "direction" in self.model_fields_set:
            _dict['direction'] = None

        # set to None if spread (nullable) is None
        # and model_fields_set contains the field
        if self.spread is None and "spread" in self.model_fields_set:
            _dict['spread'] = None

        # set to None if position_effect (nullable) is None
        # and model_fields_set contains the field
        if self.position_effect is None and "position_effect" in self.model_fields_set:
            _dict['positionEffect'] = None

        # set to None if credit_or_debit (nullable) is None
        # and model_fields_set contains the field
        if self.credit_or_debit is None and "credit_or_debit" in self.model_fields_set:
            _dict['creditOrDebit'] = None

        # set to None if expiration_date (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_date is None and "expiration_date" in self.model_fields_set:
            _dict['expirationDate'] = None

        # set to None if strike (nullable) is None
        # and model_fields_set contains the field
        if self.strike is None and "strike" in self.model_fields_set:
            _dict['strike'] = None

        # set to None if option_type (nullable) is None
        # and model_fields_set contains the field
        if self.option_type is None and "option_type" in self.model_fields_set:
            _dict['optionType'] = None

        # set to None if is_automated (nullable) is None
        # and model_fields_set contains the field
        if self.is_automated is None and "is_automated" in self.model_fields_set:
            _dict['isAutomated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobinhoodMarketOrderModifyQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "extendedHours": obj.get("extendedHours") if obj.get("extendedHours") is not None else False,
            "marketHours": obj.get("marketHours") if obj.get("marketHours") is not None else 'regular_hours',
            "direction": obj.get("direction"),
            "spread": [FinaticBrokerFactoryBrokersRobinhoodExecutorsConsumerRobinhoodOrderModifyQueryParamsRobinhoodOptionSpreadLeg.from_dict(_item) for _item in obj["spread"]] if obj.get("spread") is not None else None,
            "positionEffect": obj.get("positionEffect"),
            "creditOrDebit": obj.get("creditOrDebit"),
            "expirationDate": obj.get("expirationDate"),
            "strike": obj.get("strike"),
            "optionType": obj.get("optionType"),
            "amountIn": obj.get("amountIn") if obj.get("amountIn") is not None else 'quantity',
            "orderId": obj.get("orderId"),
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "isAutomated": obj.get("isAutomated")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


