# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from .accountnumber import Accountnumber
from .robinhood_option_spread_leg import RobinhoodOptionSpreadLeg
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class RobinhoodOptionLimitOrderPlaceQueryParams(BaseModel):
    """
    Option limit order with Robinhood-specific extras.
    """ # noqa: E501
    account_number: Accountnumber = Field(alias="accountNumber")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: Optional[StrictStr] = Field(default='equity_option', alias="assetType")
    action: StrictStr
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    symbol: StrictStr
    order_qty: StrictInt = Field(alias="orderQty")
    price: Union[StrictFloat, StrictInt]
    direction: Optional[StrictStr] = None
    spread: Optional[List[RobinhoodOptionSpreadLeg]] = None
    position_effect: Optional[StrictStr] = Field(default=None, alias="positionEffect")
    credit_or_debit: Optional[StrictStr] = Field(default=None, alias="creditOrDebit")
    expiration_date: Optional[StrictStr] = Field(default=None, alias="expirationDate")
    strike_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="strikePrice")
    option_type: Optional[StrictStr] = Field(default=None, alias="optionType")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["accountNumber", "orderType", "assetType", "action", "timeInForce", "symbol", "orderQty", "price", "direction", "spread", "positionEffect", "creditOrDebit", "expirationDate", "strikePrice", "optionType"]

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['limit']):
            raise ValueError("must be one of enum values ('limit')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['equity_option']):
            raise ValueError("must be one of enum values ('equity_option')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    @field_validator('direction')
    def direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['debit', 'credit']):
            raise ValueError("must be one of enum values ('debit', 'credit')")
        return value

    @field_validator('position_effect')
    def position_effect_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'close']):
            raise ValueError("must be one of enum values ('open', 'close')")
        return value

    @field_validator('credit_or_debit')
    def credit_or_debit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['debit', 'credit']):
            raise ValueError("must be one of enum values ('debit', 'credit')")
        return value

    @field_validator('option_type')
    def option_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['call', 'put', 'both']):
            raise ValueError("must be one of enum values ('call', 'put', 'both')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobinhoodOptionLimitOrderPlaceQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_number
        if self.account_number:
            _dict['accountNumber'] = self.account_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in spread (list)
        _items = []
        if self.spread:
            for _item_spread in self.spread:
                if _item_spread:
                    _items.append(_item_spread.to_dict())
            _dict['spread'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if direction (nullable) is None
        # and model_fields_set contains the field
        if self.direction is None and "direction" in self.model_fields_set:
            _dict['direction'] = None

        # set to None if spread (nullable) is None
        # and model_fields_set contains the field
        if self.spread is None and "spread" in self.model_fields_set:
            _dict['spread'] = None

        # set to None if position_effect (nullable) is None
        # and model_fields_set contains the field
        if self.position_effect is None and "position_effect" in self.model_fields_set:
            _dict['positionEffect'] = None

        # set to None if credit_or_debit (nullable) is None
        # and model_fields_set contains the field
        if self.credit_or_debit is None and "credit_or_debit" in self.model_fields_set:
            _dict['creditOrDebit'] = None

        # set to None if expiration_date (nullable) is None
        # and model_fields_set contains the field
        if self.expiration_date is None and "expiration_date" in self.model_fields_set:
            _dict['expirationDate'] = None

        # set to None if strike_price (nullable) is None
        # and model_fields_set contains the field
        if self.strike_price is None and "strike_price" in self.model_fields_set:
            _dict['strikePrice'] = None

        # set to None if option_type (nullable) is None
        # and model_fields_set contains the field
        if self.option_type is None and "option_type" in self.model_fields_set:
            _dict['optionType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobinhoodOptionLimitOrderPlaceQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountNumber": Accountnumber.from_dict(obj["accountNumber"]) if obj.get("accountNumber") is not None else None,
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType") if obj.get("assetType") is not None else 'equity_option',
            "action": obj.get("action"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "symbol": obj.get("symbol"),
            "orderQty": obj.get("orderQty"),
            "price": obj.get("price"),
            "direction": obj.get("direction"),
            "spread": [RobinhoodOptionSpreadLeg.from_dict(_item) for _item in obj["spread"]] if obj.get("spread") is not None else None,
            "positionEffect": obj.get("positionEffect"),
            "creditOrDebit": obj.get("creditOrDebit"),
            "expirationDate": obj.get("expirationDate"),
            "strikePrice": obj.get("strikePrice"),
            "optionType": obj.get("optionType")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


