# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from .broker_data_option_type_enum import BrokerDataOptionTypeEnum
from .broker_data_order_side_enum import BrokerDataOrderSideEnum
from typing import Optional, Set
from typing_extensions import Self

class RobinhoodOptionSpreadLeg(BaseModel):
    """
    One leg within a spread for option orders.  Used by order_option_spread() function. Matches the structure expected by the raw query params layer.
    """ # noqa: E501
    expiration_date: StrictStr = Field(alias="expirationDate")
    strike_price: Union[StrictFloat, StrictInt] = Field(alias="strikePrice")
    option_type: BrokerDataOptionTypeEnum = Field(alias="optionType")
    position_effect: StrictStr = Field(alias="positionEffect")
    action: BrokerDataOrderSideEnum
    ratio_quantity: Optional[StrictInt] = Field(default=1, alias="ratioQuantity")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["expirationDate", "strikePrice", "optionType", "positionEffect", "action", "ratioQuantity"]

    @field_validator('position_effect')
    def position_effect_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'close']):
            raise ValueError("must be one of enum values ('open', 'close')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RobinhoodOptionSpreadLeg from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RobinhoodOptionSpreadLeg from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "expirationDate": obj.get("expirationDate"),
            "strikePrice": obj.get("strikePrice"),
            "optionType": obj.get("optionType"),
            "positionEffect": obj.get("positionEffect"),
            "action": obj.get("action"),
            "ratioQuantity": obj.get("ratioQuantity") if obj.get("ratioQuantity") is not None else 1
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


