# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from .accountnumber import Accountnumber
from .timeinforce1 import Timeinforce1
from typing import Optional, Set
from typing_extensions import Self

class TastyTradeMarketOrderPlaceQueryParams(BaseModel):
    """
    Parameters for a TastyTrade *market* order.
    """ # noqa: E501
    automated_source: Optional[StrictBool] = Field(default=True, alias="automated-source")
    price_effect: Optional[StrictStr] = Field(default=None, alias="price-effect")
    external_identifier: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, alias="external-identifier")
    partition_key: Optional[StrictStr] = Field(default=None, alias="partition-key")
    preflight_id: Optional[StrictStr] = Field(default=None, alias="preflight-id")
    source: Optional[StrictStr] = None
    value_effect: Optional[StrictStr] = Field(default=None, alias="value-effect")
    legs: Optional[List[Dict[str, Any]]] = None
    account_number: Accountnumber = Field(alias="accountNumber")
    order_type: StrictStr = Field(alias="orderType")
    asset_type: StrictStr = Field(alias="assetType")
    action: StrictStr
    time_in_force: Timeinforce1 = Field(alias="timeInForce")
    symbol: StrictStr
    order_qty: StrictInt = Field(alias="orderQty")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["automated-source", "price-effect", "external-identifier", "partition-key", "preflight-id", "source", "value-effect", "legs", "accountNumber", "orderType", "assetType", "action", "timeInForce", "symbol", "orderQty"]

    @field_validator('price_effect')
    def price_effect_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Debit', 'Credit']):
            raise ValueError("must be one of enum values ('Debit', 'Credit')")
        return value

    @field_validator('value_effect')
    def value_effect_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Debit', 'Credit']):
            raise ValueError("must be one of enum values ('Debit', 'Credit')")
        return value

    @field_validator('order_type')
    def order_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['market']):
            raise ValueError("must be one of enum values ('market')")
        return value

    @field_validator('asset_type')
    def asset_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['equity', 'equity_option', 'crypto', 'forex']):
            raise ValueError("must be one of enum values ('equity', 'equity_option', 'crypto', 'forex')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TastyTradeMarketOrderPlaceQueryParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account_number
        if self.account_number:
            _dict['accountNumber'] = self.account_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of time_in_force
        if self.time_in_force:
            _dict['timeInForce'] = self.time_in_force.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if price_effect (nullable) is None
        # and model_fields_set contains the field
        if self.price_effect is None and "price_effect" in self.model_fields_set:
            _dict['price-effect'] = None

        # set to None if external_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.external_identifier is None and "external_identifier" in self.model_fields_set:
            _dict['external-identifier'] = None

        # set to None if partition_key (nullable) is None
        # and model_fields_set contains the field
        if self.partition_key is None and "partition_key" in self.model_fields_set:
            _dict['partition-key'] = None

        # set to None if preflight_id (nullable) is None
        # and model_fields_set contains the field
        if self.preflight_id is None and "preflight_id" in self.model_fields_set:
            _dict['preflight-id'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if value_effect (nullable) is None
        # and model_fields_set contains the field
        if self.value_effect is None and "value_effect" in self.model_fields_set:
            _dict['value-effect'] = None

        # set to None if legs (nullable) is None
        # and model_fields_set contains the field
        if self.legs is None and "legs" in self.model_fields_set:
            _dict['legs'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TastyTradeMarketOrderPlaceQueryParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "automated-source": obj.get("automated-source") if obj.get("automated-source") is not None else True,
            "price-effect": obj.get("price-effect"),
            "external-identifier": obj.get("external-identifier"),
            "partition-key": obj.get("partition-key"),
            "preflight-id": obj.get("preflight-id"),
            "source": obj.get("source"),
            "value-effect": obj.get("value-effect"),
            "legs": obj.get("legs"),
            "accountNumber": Accountnumber.from_dict(obj["accountNumber"]) if obj.get("accountNumber") is not None else None,
            "orderType": obj.get("orderType"),
            "assetType": obj.get("assetType"),
            "action": obj.get("action"),
            "timeInForce": Timeinforce1.from_dict(obj["timeInForce"]) if obj.get("timeInForce") is not None else None,
            "symbol": obj.get("symbol"),
            "orderQty": obj.get("orderQty")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


