# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from .day_tif import DayTIF
from .foktif import FOKTIF
from .gtctif import GTCTIF
from .gtdtif import GTDTIF
from .ioctif import IOCTIF
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

TIMEINFORCE1_ONE_OF_SCHEMAS = ["DayTIF", "FOKTIF", "GTCTIF", "GTDTIF", "IOCTIF"]

class Timeinforce1(BaseModel):
    """
    Timeinforce1
    """
    # data type: DayTIF
    oneof_schema_1_validator: Optional[DayTIF] = None
    # data type: GTCTIF
    oneof_schema_2_validator: Optional[GTCTIF] = None
    # data type: GTDTIF
    oneof_schema_3_validator: Optional[GTDTIF] = None
    # data type: IOCTIF
    oneof_schema_4_validator: Optional[IOCTIF] = None
    # data type: FOKTIF
    oneof_schema_5_validator: Optional[FOKTIF] = None
    actual_instance: Optional[Union[DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF]] = None
    one_of_schemas: Set[str] = { "DayTIF", "FOKTIF", "GTCTIF", "GTDTIF", "IOCTIF" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Timeinforce1.model_construct()
        error_messages = []
        match = 0
        # validate data type: DayTIF
        if not isinstance(v, DayTIF):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DayTIF`")
        else:
            match += 1
        # validate data type: GTCTIF
        if not isinstance(v, GTCTIF):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GTCTIF`")
        else:
            match += 1
        # validate data type: GTDTIF
        if not isinstance(v, GTDTIF):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GTDTIF`")
        else:
            match += 1
        # validate data type: IOCTIF
        if not isinstance(v, IOCTIF):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IOCTIF`")
        else:
            match += 1
        # validate data type: FOKTIF
        if not isinstance(v, FOKTIF):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FOKTIF`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Timeinforce1 with oneOf schemas: DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Timeinforce1 with oneOf schemas: DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("timeInForce")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `timeInForce` in the input.")

        # check if data type is `DayTIF`
        if _data_type == "day":
            instance.actual_instance = DayTIF.from_json(json_str)
            return instance

        # check if data type is `FOKTIF`
        if _data_type == "fok":
            instance.actual_instance = FOKTIF.from_json(json_str)
            return instance

        # check if data type is `GTCTIF`
        if _data_type == "gtc":
            instance.actual_instance = GTCTIF.from_json(json_str)
            return instance

        # check if data type is `GTDTIF`
        if _data_type == "gtd":
            instance.actual_instance = GTDTIF.from_json(json_str)
            return instance

        # check if data type is `IOCTIF`
        if _data_type == "ioc":
            instance.actual_instance = IOCTIF.from_json(json_str)
            return instance

        # deserialize data into DayTIF
        try:
            instance.actual_instance = DayTIF.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GTCTIF
        try:
            instance.actual_instance = GTCTIF.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GTDTIF
        try:
            instance.actual_instance = GTDTIF.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IOCTIF
        try:
            instance.actual_instance = IOCTIF.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into FOKTIF
        try:
            instance.actual_instance = FOKTIF.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Timeinforce1 with oneOf schemas: DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Timeinforce1 with oneOf schemas: DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], DayTIF, FOKTIF, GTCTIF, GTDTIF, IOCTIF]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


