# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class UserBrokerConnectionWithPermissions(BaseModel):
    """
    Response model for user broker connection with permissions included.  This model extends UserBrokerConnections to include company-level permissions from the CompanyAccess table. Used by the GET /connections endpoint to return connection data with permission information for the requesting company account.  The model excludes internal circuit breaker fields (circuit_open, consecutive_failures, error_message, circuit_open_until) which are operational details and should not be exposed in API responses. This ensures clients only receive relevant connection and permission data.  Fields are derived from the UserBrokerConnections SQLModel and kept in sync through the from_connection() factory method, which validates against the database schema and automatically excludes circuit breaker fields.  Attributes ---------- id : UUID     Unique identifier for the broker connection. Primary key in UserBrokerConnections     table. Used to reference the connection in update and delete operations. user_id : UUID     UUID of the user who owns this broker connection. Connections are user-scoped,     but can be shared with company accounts via CompanyAccess records. broker_id : str     Identifier of the broker this connection is for (e.g., \"tradestation\",     \"tasty_trade\"). Determines which broker adapter handles requests. status : str | None     Current status of the connection (e.g., \"active\", \"inactive\", \"error\").     None if status is not set. Used to determine if the connection is usable. connection_metadata : dict[str, Any] | None     Additional metadata stored with the connection. May include account information,     labels, notes, or broker-specific data. None if no metadata is stored. created_at : datetime | None     Timestamp when the connection was first created. None if not available.     Used for auditing and connection age tracking. updated_at : datetime | None     Timestamp when the connection was last updated. None if not available.     Used to track connection modifications. last_synced_at : datetime | None     Timestamp when the connection was last synchronized with the broker's API.     None if synchronization has not occurred. Used to determine data freshness. permissions : dict[str, bool]     Permission levels for the current company account. Dictionary with keys:     - \"read\": bool - Whether company can read broker data (positions, orders, accounts)     - \"write\": bool - Whether company can execute trades and modify orders     Default is {\"read\": False, \"write\": False} if no CompanyAccess record exists.  Notes ----- 1. **Circuit Breaker Exclusion**: Internal circuit breaker fields are automatically    excluded from serialization to prevent exposing operational details. The    model_dump() method ensures these fields never appear in API responses.  2. **Schema Synchronization**: The from_connection() factory method ensures    field compatibility with UserBrokerConnections SQLModel. Changes to the    database schema should be reflected in this model.  3. **Permission Source**: Permissions are derived from the CompanyAccess table    by joining on user_broker_connection_id and filtering by account_id (company).  4. **Default Permissions**: If no CompanyAccess record exists for the company,    permissions default to {\"read\": False, \"write\": False}, effectively denying    access until permissions are explicitly granted.  5. **Multi-Company Support**: The same connection can have different permissions    for different companies. Permissions are always scoped to the requesting company.  Examples -------- >>> # Create from UserBrokerConnections with permissions >>> connection_sqlmodel = UserBrokerConnections( ...     id=UUID(\"123e4567-e89b-12d3-a456-426614174000\"), ...     user_id=UUID(\"user-123\"), ...     broker_id=\"tradestation\", ...     status=\"active\", ... ) >>> # Factory method with permissions >>> connection = UserBrokerConnectionWithPermissions.from_connection( ...     connection_sqlmodel, permissions={\"read\": True, \"write\": True} ... ) >>> # Serialize (circuit breaker fields automatically excluded) >>> data = connection.model_dump() >>> # data does not contain circuit_open, consecutive_failures, etc.  See Also -------- from_connection : Factory method to create instances from UserBrokerConnections finaticapi.api.v1.routers.brokers.brokers_router.get_connections     : Endpoint that returns this model finaticapi.core.services.broker_service.BrokerService.get_connections     : Service method that builds these models finatic_broker_factory.core.standard_models.supabase.schema_sql_models_broker_data_latest.UserBrokerConnections     : Database model this extends
    """ # noqa: E501
    id: UUID
    user_id: UUID
    broker_id: StrictStr
    status: Optional[StrictStr] = None
    connection_metadata: Optional[Dict[str, Any]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    last_synced_at: Optional[datetime] = None
    permissions: Optional[Dict[str, StrictBool]] = Field(default=None, description="Permissions for the current company (read/write access)")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "user_id", "broker_id", "status", "connection_metadata", "created_at", "updated_at", "last_synced_at", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserBrokerConnectionWithPermissions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if connection_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.connection_metadata is None and "connection_metadata" in self.model_fields_set:
            _dict['connection_metadata'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if last_synced_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_synced_at is None and "last_synced_at" in self.model_fields_set:
            _dict['last_synced_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserBrokerConnectionWithPermissions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "broker_id": obj.get("broker_id"),
            "status": obj.get("status"),
            "connection_metadata": obj.get("connection_metadata"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "last_synced_at": obj.get("last_synced_at"),
            "permissions": obj.get("permissions")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


