'''
finhack trader run --strategy=MyIndexStrategy --cash=30000000
'''
import datetime
import os
import random
from finhack.factor.default.factorManager import factorManager
from finhack.market.astock.astock import AStock
## 初始化函数，设定要操作的股票、基准等等
def initialize(context):
    # 设定沪深300作为基准
    set_benchmark('000001.SH')
    # True为开启动态复权模式，使用真实价格交易
    set_option('use_real_price', True) 
    # 设定成交量比例
    set_option('order_volume_ratio', 1)
    # # 股票类交易手续费是：买入时佣金万分之三，卖出时佣金万分之三加千分之一印花税, 每笔交易佣金最低扣5块钱
    set_order_cost(OrderCost(open_tax=0, close_tax=0.001, \
                             open_commission=0.0003, close_commission=0.0003,\
                             close_today_commission=0, min_commission=5), type='stock')
    
    # 为股票设定滑点为百分比滑点                       
    set_slippage(PriceRelatedSlippage(0.00246),type='stock')

    run_daily(trade, time="09:30")
    # run_daily(trade, time="8:05")
    log.info('get code list')

## 交易函数
def trade(context):
    
    
    
    
    
    my_list=['603660.SH', '000066.SZ', '002351.SZ', '300462.SZ', '300552.SZ', '300249.SZ', '872190.BJ', '430198.BJ', '688288.SH', '600817.SH', '002786.SZ', '002366.SZ', '300472.SZ', '300509.SZ', '300281.SZ', '835174.BJ', '688121.SH', '688633.SH', '002082.SZ', '300519.SZ', '300108.SZ', '300147.SZ', '833266.BJ', '002910.SZ', '600882.SH', '600887.SH', '002329.SZ', '300892.SZ', '300106.SZ', '832786.BJ', '603598.SH', '002127.SZ', '002602.SZ', '300459.SZ', '300063.SZ', '300242.SZ', '688500.SH', '002682.SZ', '600755.SH', '300240.SZ', '000421.SZ', '000407.SZ', '000692.SZ', '300335.SZ', '831010.BJ', '000627.SZ', '002765.SZ', '603186.SH', '600130.SH', '002217.SZ', '300476.SZ', '300493.SZ', '300269.SZ', '838701.BJ', '831167.BJ', '871857.BJ', '688519.SH', '688181.SH', '002133.SZ', '000736.SZ', '600791.SH', '600561.SH', '603069.SH', '002357.SZ', '605136.SH', '000829.SZ', '002177.SZ', '300622.SZ', '002785.SZ', '002043.SZ', '300986.SZ', '300374.SZ', '300163.SZ', '836149.BJ', '839792.BJ', '688119.SH', '002746.SZ', '000061.SZ', '002321.SZ', '300268.SZ', '300871.SZ', '838275.BJ', '688098.SH', '688526.SH', '002779.SZ', '000570.SZ', '000816.SZ', '300879.SZ', '300022.SZ', '872895.BJ', '603086.SH', '000912.SZ', '002274.SZ', '300575.SZ', '300261.SZ', '833819.BJ', '600551.SH', '600825.SH', '300654.SZ', '300788.SZ', '002755.SZ', '002102.SZ', '600774.SH', '002435.SZ', '300573.SZ', '300233.SZ', '832566.BJ', '871970.BJ', '832735.BJ', '688189.SH', '688658.SH', '002002.SZ', '600273.SH', '002669.SZ', '300446.SZ', '300437.SZ', '300082.SZ', '300243.SZ', '830832.BJ', '834261.BJ', '688350.SH', '688669.SH', '600579.SH', '002564.SZ', '300228.SZ', '002427.SZ', '000949.SZ', '600889.SH', '000782.SZ', '300180.SZ', '836077.BJ', '688722.SH', '600683.SH', '000718.SZ', '002208.SZ', '600327.SH', '000615.SZ', '600529.SH', '300562.SZ', '300247.SZ', '835892.BJ', '832278.BJ', '688399.SH', '688068.SH', '603108.SH', '002788.SZ', '600056.SH', '000411.SZ', '301126.SZ', '301017.SZ', '603690.SH', '600877.SH', '002077.SZ', '300708.SZ', '300458.SZ', '300046.SZ', '430139.BJ', '688216.SH', '688368.SH', '688699.SH', '600790.SH', '002344.SZ', '600287.SH', '600250.SH', '600710.SH', '000929.SZ', '600573.SH', '600658.SH', '600463.SH', '002457.SZ', '603856.SH', '600500.SH', '002632.SZ', '300478.SZ', '300538.SZ', '300321.SZ', '870204.BJ', '832089.BJ', '688219.SH', '603123.SH', '002647.SZ', '600120.SH', '603021.SH', '000910.SZ', '002631.SZ', '301356.SZ', '301061.SZ', '300616.SZ', '834765.BJ', '002011.SZ', '002005.SZ', '000810.SZ', '300625.SZ', '300160.SZ', '300217.SZ', '831768.BJ', '688696.SH', '688609.SH', '002716.SZ', '600301.SH', '000629.SZ', '601137.SH', '300618.SZ', '300328.SZ', '833914.BJ', '688786.SH', '600761.SH', '000680.SZ', '002523.SZ', '300201.SZ', '300185.SZ', '830839.BJ', '601968.SH', '002027.SZ', '002117.SZ', '300280.SZ', '300058.SZ', '837174.BJ', '872392.BJ', '002761.SZ', '600939.SH', '002062.SZ', '300732.SZ', '300500.SZ', '300675.SZ', '300284.SZ', '830964.BJ', '833427.BJ', '603721.SH', '002343.SZ', '600576.SH', '300528.SZ', '300291.SZ', '834021.BJ', '000560.SZ', '001914.SZ', '300947.SZ', '002999.SZ', '000652.SZ', '601777.SH', '000913.SZ', '002105.SZ', '301322.SZ', '301345.SZ', '834058.BJ', '689009.SH', '000558.SZ', '600861.SH', '002607.SZ', '300192.SZ', '300081.SZ', '000040.SZ', '600821.SH', '301046.SZ', '600706.SH', '000888.SZ', '000978.SZ', '300144.SZ', '000796.SZ', '600138.SH', '002159.SZ', '300756.SZ', '000523.SZ', '002637.SZ', '300955.SZ', '301108.SZ', '300740.SZ', '600782.SH', '000717.SZ', '600126.SH', '603518.SH', '600630.SH', '002098.SZ', '300591.SZ', '600897.SH', '600004.SH', '601882.SH', '000837.SZ', '300083.SZ', '831855.BJ', '688558.SH', '688577.SH', '688697.SH', '002760.SZ', '000530.SZ', '002347.SZ', '300464.SZ', '300260.SZ', '833943.BJ', '873169.BJ', '688455.SH', '688379.SH', '688355.SH', '000663.SZ', '600265.SH', '002679.SZ', '603737.SH', '002054.SZ', '000565.SZ', '301036.SZ']
    
    
    for code in my_list:
        if not code in list(context.portfolio.positions.keys()):
            order_value(code, 100000)
